/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classFilesIndex.chainsSearch.completion.lookup;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.compiler.classFilesIndex.chainsSearch.completion.lookup.ChainCompletionMethodCallLookupElement;
import com.intellij.compiler.classFilesIndex.chainsSearch.completion.lookup.sub.SubLookupElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import gnu.trove.TIntObjectHashMap;
import org.jetbrains.annotations.Nullable;

public final class ChainCompletionLookupElementUtil {
    private ChainCompletionLookupElementUtil() {
    }

    public static LookupElement createLookupElement(PsiMethod method2, @Nullable TIntObjectHashMap<SubLookupElement> replaceElements) {
        if (method2.isConstructor()) {
            return LookupElementBuilder.create((String)String.format("%s %s", "new", method2.getContainingClass().getName()));
        }
        if (method2.hasModifierProperty("static")) {
            return new ChainCompletionMethodCallLookupElement(method2, replaceElements, false, true);
        }
        return new ChainCompletionMethodCallLookupElement(method2, replaceElements);
    }

    public static String fillMethodParameters(PsiMethod method2, @Nullable TIntObjectHashMap<SubLookupElement> replaceElements) {
        TIntObjectHashMap notNullReplaceElements = replaceElements == null ? new TIntObjectHashMap(0) : replaceElements;
        PsiParameter[] parameters2 = method2.getParameterList().getParameters();
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < parameters2.length; ++i2) {
            if (i2 != 0) {
                sb.append(", ");
            }
            PsiParameter parameter = parameters2[i2];
            SubLookupElement replaceElement = (SubLookupElement)notNullReplaceElements.get(i2);
            if (replaceElement != null) {
                sb.append(replaceElement.getInsertString());
                continue;
            }
            sb.append(parameter.getName());
        }
        return sb.toString();
    }
}

