/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classFilesIndex.chainsSearch.completion.lookup;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ChainCompletionNewVariableLookupElement
extends LookupElementDecorator<LookupElement> {
    private static final Logger log = Logger.getInstance(ChainCompletionNewVariableLookupElement.class);
    private final PsiClass myPsiClass;
    private final String myNewVarName;

    public ChainCompletionNewVariableLookupElement(PsiClass psiClass, String newVarName, LookupElement calledMethods) {
        super(calledMethods);
        this.myNewVarName = newVarName;
        this.myPsiClass = psiClass;
    }

    public static ChainCompletionNewVariableLookupElement create(PsiClass psiClass, LookupElement calledMethods) {
        Project project2 = psiClass.getProject();
        String newVarName = ChainCompletionNewVariableLookupElement.chooseLongestName(JavaCodeStyleManager.getInstance((Project)project2).suggestVariableName(VariableKind.LOCAL_VARIABLE, null, null, (PsiType)JavaPsiFacade.getElementFactory((Project)project2).createType(psiClass)));
        return new ChainCompletionNewVariableLookupElement(psiClass, newVarName, calledMethods);
    }

    public void handleInsert(InsertionContext context) {
        RangeMarker rangeMarker = context.getDocument().createRangeMarker(context.getStartOffset(), context.getStartOffset());
        this.getDelegate().handleInsert(context);
        PsiFile file2 = context.getFile();
        ((PsiJavaFile)file2).importClass(this.myPsiClass);
        PsiElement caretElement = file2.findElementAt(context.getEditor().getCaretModel().getOffset());
        if (caretElement == null) {
            log.error("element on caret position MUST BE not null");
            return;
        }
        PsiStatement statement2 = (PsiStatement)caretElement.getPrevSibling();
        PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)statement2, PsiCodeBlock.class);
        if (codeBlock == null) {
            log.error("code block MUST BE not null");
            return;
        }
        Project project2 = context.getProject();
        Ref insertedStatementRef = Ref.create();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
        context.commitDocument();
        PsiStatement statementFromText = elementFactory.createStatementFromText(String.format("%s %s = null;", this.myPsiClass.getName(), this.myNewVarName), null);
        insertedStatementRef.set((Object)codeBlock.addBefore((PsiElement)statementFromText, (PsiElement)statement2));
        PsiLiteralExpression nullKeyword = ChainCompletionNewVariableLookupElement.findNull((PsiElement)insertedStatementRef.get());
        PsiDocumentManager.getInstance((Project)context.getProject()).doPostponedOperationsAndUnblockDocument(context.getDocument());
        context.getDocument().insertString(rangeMarker.getStartOffset(), (CharSequence)(this.myNewVarName + "."));
        context.commitDocument();
        int offset = nullKeyword.getTextOffset();
        int endOffset = offset + nullKeyword.getTextLength();
        context.getEditor().getSelectionModel().setSelection(offset, endOffset);
        context.getEditor().getCaretModel().moveToOffset(offset);
    }

    @NotNull
    public String getLookupString() {
        return this.getDelegate().getLookupString();
    }

    public void renderElement(LookupElementPresentation presentation) {
        super.renderElement(presentation);
        presentation.setItemText(this.myNewVarName + "." + presentation.getItemText());
    }

    private static PsiLiteralExpression findNull(PsiElement psiElement) {
        Collection literalExpressions = PsiTreeUtil.findChildrenOfType((PsiElement)psiElement, PsiLiteralExpression.class);
        for (PsiLiteralExpression literalExpression : literalExpressions) {
            if (!"null".equals(literalExpression.getText())) continue;
            return literalExpression;
        }
        throw new IllegalArgumentException();
    }

    private static String chooseLongestName(SuggestedNameInfo suggestedNameInfo) {
        String[] names = suggestedNameInfo.names;
        String longestWord = names[0];
        int maxLength = longestWord.length();
        for (int i2 = 1; i2 < names.length; ++i2) {
            int length = names[i2].length();
            if (length <= maxLength) continue;
            maxLength = length;
            longestWord = names[i2];
        }
        return longestWord;
    }
}

