/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classFilesIndex.chainsSearch.context;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

class ChainCompletionContextStringUtil {
    private static final int COMMON_PART_MIN_LENGTH = 3;

    private ChainCompletionContextStringUtil() {
    }

    public static boolean isSimilar(@NotNull String varName, @NotNull String parameterName) {
        String sanitizedParamName = ChainCompletionContextStringUtil.sanitizedToLowerCase(parameterName);
        if (StringUtil.commonPrefix((String)varName, (String)sanitizedParamName).length() >= 3) {
            return true;
        }
        String suffix = StringUtil.commonSuffix((String)varName, (String)sanitizedParamName);
        return suffix.length() >= 3;
    }

    @NotNull
    public static String sanitizedToLowerCase(@NotNull String name) {
        StringBuilder result2 = new StringBuilder();
        for (int i2 = 0; i2 < name.length(); ++i2) {
            char ch = name.charAt(i2);
            if (!Character.isLetter(ch)) continue;
            result2.append(Character.toLowerCase(ch));
        }
        return result2.toString();
    }
}

