/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.ProblemsView;
import com.intellij.compiler.impl.ProblemsViewPanel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.ErrorViewStructure;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.ui.UIUtil;
import java.util.EnumSet;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProblemsViewImpl
extends ProblemsView {
    private static final String PROBLEMS_TOOLWINDOW_ID = "Problems";
    private static final EnumSet<ErrorTreeElementKind> ALL_MESSAGE_KINDS = EnumSet.allOf(ErrorTreeElementKind.class);
    private final ProblemsViewPanel myPanel;
    private final ExecutorService myViewUpdater = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"ProblemsView pool");
    private final Icon myActiveIcon = AllIcons.Toolwindows.Problems;
    private final Icon myPassiveIcon = IconLoader.getDisabledIcon((Icon)this.myActiveIcon);

    public ProblemsViewImpl(Project project2, ToolWindowManager wm) {
        super(project2);
        this.myPanel = new ProblemsViewPanel(project2);
        Disposer.register((Disposable)project2, (Disposable)new Disposable(){

            public void dispose() {
                Disposer.dispose((Disposable)ProblemsViewImpl.this.myPanel);
            }
        });
        UIUtil.invokeLaterIfNeeded(() -> {
            if (project2.isDisposed()) {
                return;
            }
            final ToolWindow tw = wm.registerToolWindow(PROBLEMS_TOOLWINDOW_ID, false, ToolWindowAnchor.BOTTOM, (Disposable)project2, true);
            Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)this.myPanel, "", false);
            tw.getContentManager().addContent(content);
            Disposer.register((Disposable)project2, (Disposable)new Disposable(){

                public void dispose() {
                    tw.getContentManager().removeAllContents(true);
                }
            });
            this.updateIcon();
        });
    }

    @Override
    public void clearOldMessages(@Nullable CompileScope scope, @NotNull UUID currentSessionId) {
        this.myViewUpdater.execute(() -> {
            this.cleanupChildrenRecursively(this.myPanel.getErrorViewStructure().getRootElement(), scope, currentSessionId);
            this.updateIcon();
            this.myPanel.reload();
        });
    }

    private void cleanupChildrenRecursively(@NotNull Object fromElement, @Nullable CompileScope scope, @NotNull UUID currentSessionId) {
        ErrorViewStructure structure = this.myPanel.getErrorViewStructure();
        for (ErrorTreeElement element : structure.getChildElements(fromElement)) {
            if (element instanceof GroupingElement) {
                VirtualFile file2;
                if (scope != null && (file2 = ((GroupingElement)element).getFile()) != null && !scope.belongs(file2.getUrl())) continue;
                if (!currentSessionId.equals(element.getData())) {
                    structure.removeElement(element);
                    continue;
                }
                this.cleanupChildrenRecursively(element, scope, currentSessionId);
                continue;
            }
            if (currentSessionId.equals(element.getData())) continue;
            structure.removeElement(element);
        }
    }

    @Override
    public void addMessage(int type2, @NotNull String[] text, @Nullable String groupName, @Nullable Navigatable navigatable, @Nullable String exportTextPrefix, @Nullable String rendererTextPrefix, @Nullable UUID sessionId) {
        this.myViewUpdater.execute(() -> {
            ErrorViewStructure structure = this.myPanel.getErrorViewStructure();
            GroupingElement group = structure.lookupGroupingElement(groupName);
            if (group != null && sessionId != null && !sessionId.equals(group.getData())) {
                structure.removeElement(group);
            }
            if (navigatable != null) {
                this.myPanel.addMessage(type2, text, groupName, navigatable, exportTextPrefix, rendererTextPrefix, (Object)sessionId);
            } else {
                this.myPanel.addMessage(type2, text, null, -1, -1, sessionId);
            }
            this.updateIcon();
        });
    }

    private void updateIcon() {
        UIUtil.invokeLaterIfNeeded(() -> {
            ToolWindow tw;
            if (!this.myProject.isDisposed() && (tw = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(PROBLEMS_TOOLWINDOW_ID)) != null) {
                boolean active = this.myPanel.getErrorViewStructure().hasMessages(EnumSet.of(ErrorTreeElementKind.ERROR, ErrorTreeElementKind.WARNING, ErrorTreeElementKind.NOTE));
                tw.setIcon(active ? this.myActiveIcon : this.myPassiveIcon);
            }
        });
    }

    @Override
    public void setProgress(String text, float fraction) {
        this.myPanel.setProgress(text, fraction);
    }

    @Override
    public void setProgress(String text) {
        this.myPanel.setProgressText(text);
    }

    @Override
    public void clearProgress() {
        this.myPanel.clearProgressData();
    }
}

