/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.options.AnnotationProcessorsPanel;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;

public class AnnotationProcessorsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private final Project myProject;
    private AnnotationProcessorsPanel myMainPanel;

    public AnnotationProcessorsConfigurable(Project project2) {
        this.myProject = project2;
    }

    public String getDisplayName() {
        return "Annotation Processors";
    }

    public String getHelpTopic() {
        return "reference.projectsettings.compiler.annotationProcessors";
    }

    @NotNull
    public String getId() {
        return this.getHelpTopic();
    }

    public JComponent createComponent() {
        this.myMainPanel = new AnnotationProcessorsPanel(this.myProject);
        return this.myMainPanel;
    }

    public boolean isModified() {
        CompilerConfigurationImpl config = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)this.myProject);
        if (!config.getDefaultProcessorProfile().equals(this.myMainPanel.getDefaultProfile())) {
            return true;
        }
        HashMap<String, ProcessorConfigProfile> configProfiles = new HashMap<String, ProcessorConfigProfile>();
        for (ProcessorConfigProfile profile2 : config.getModuleProcessorProfiles()) {
            configProfiles.put(profile2.getName(), profile2);
        }
        List<ProcessorConfigProfile> panelProfiles = this.myMainPanel.getModuleProfiles();
        if (configProfiles.size() != panelProfiles.size()) {
            return true;
        }
        for (ProcessorConfigProfile panelProfile : panelProfiles) {
            ProcessorConfigProfile configProfile = (ProcessorConfigProfile)configProfiles.get(panelProfile.getName());
            if (configProfile != null && configProfile.equals(panelProfile)) continue;
            return true;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        try {
            CompilerConfigurationImpl config = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)this.myProject);
            config.setDefaultProcessorProfile(this.myMainPanel.getDefaultProfile());
            config.setModuleProcessorProfiles(this.myMainPanel.getModuleProfiles());
        }
        finally {
            BuildManager.getInstance().clearState(this.myProject);
        }
    }

    public void reset() {
        CompilerConfigurationImpl config = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)this.myProject);
        this.myMainPanel.initProfiles(config.getDefaultProcessorProfile(), config.getModuleProcessorProfiles());
    }

    public void disposeUIResources() {
        this.myMainPanel = null;
    }
}

