/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server;

import com.intellij.compiler.server.BuilderMessageHandler;
import com.intellij.compiler.server.CustomBuilderMessageHandler;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import io.netty.channel.Channel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;

public abstract class DefaultMessageHandler
implements BuilderMessageHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.server.DefaultMessageHandler");
    public static final long CONSTANT_SEARCH_TIME_LIMIT = 60000L;
    private final Project myProject;
    private final ExecutorService myTaskExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"DefaultMessageHandler pool");
    private volatile long myConstantSearchTime = 0L;

    protected DefaultMessageHandler(Project project2) {
        this.myProject = project2;
    }

    @Override
    public void buildStarted(UUID sessionId) {
    }

    @Override
    public final void handleBuildMessage(Channel channel, UUID sessionId, CmdlineRemoteProto.Message.BuilderMessage msg) {
        switch (msg.getType()) {
            case BUILD_EVENT: {
                CmdlineRemoteProto.Message.BuilderMessage.BuildEvent event = msg.getBuildEvent();
                if (event.getEventType() == CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Type.CUSTOM_BUILDER_MESSAGE && event.hasCustomBuilderMessage()) {
                    CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.CustomBuilderMessage message2 = event.getCustomBuilderMessage();
                    if (!this.myProject.isDisposed()) {
                        ((CustomBuilderMessageHandler)this.myProject.getMessageBus().syncPublisher(CustomBuilderMessageHandler.TOPIC)).messageReceived(message2.getBuilderId(), message2.getMessageType(), message2.getMessageText());
                    }
                }
                this.handleBuildEvent(sessionId, event);
                break;
            }
            case COMPILE_MESSAGE: {
                this.handleCompileMessage(sessionId, msg.getCompileMessage());
                break;
            }
            case CONSTANT_SEARCH_TASK: {
                CmdlineRemoteProto.Message.BuilderMessage.ConstantSearchTask task = msg.getConstantSearchTask();
                this.handleConstantSearchTask(channel, sessionId, task);
            }
        }
    }

    protected abstract void handleCompileMessage(UUID var1, CmdlineRemoteProto.Message.BuilderMessage.CompileMessage var2);

    protected abstract void handleBuildEvent(UUID var1, CmdlineRemoteProto.Message.BuilderMessage.BuildEvent var2);

    private void handleConstantSearchTask(final Channel channel, final UUID sessionId, final CmdlineRemoteProto.Message.BuilderMessage.ConstantSearchTask task) {
        ProgressIndicatorUtils.scheduleWithWriteActionPriority(this.myTaskExecutor, new ReadTask(){

            @Override
            public ReadTask.Continuation runBackgroundProcess(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
                return (ReadTask.Continuation)DumbService.getInstance((Project)DefaultMessageHandler.this.myProject).runReadActionInSmartMode((Computable)new Computable<ReadTask.Continuation>(){

                    public ReadTask.Continuation compute() {
                        DefaultMessageHandler.this.doHandleConstantSearchTask(channel, sessionId, task);
                        return null;
                    }
                });
            }

            @Override
            public void onCanceled(@NotNull ProgressIndicator indicator) {
                DumbService.getInstance((Project)DefaultMessageHandler.this.myProject).runWhenSmart(() -> DefaultMessageHandler.this.handleConstantSearchTask(channel, sessionId, task));
            }
        });
    }

    private void doHandleConstantSearchTask(Channel channel, UUID sessionId, CmdlineRemoteProto.Message.BuilderMessage.ConstantSearchTask task) {
        block15: {
            String ownerClassName = task.getOwnerClassName();
            final String fieldName = task.getFieldName();
            int accessFlags = task.getAccessFlags();
            boolean accessChanged = task.getIsAccessChanged();
            boolean isRemoved = task.getIsFieldRemoved();
            boolean canceled = false;
            Ref isSuccess = Ref.create((Object)Boolean.TRUE);
            Set<String> affectedPaths = Collections.synchronizedSet(new HashSet());
            long searchStart = System.currentTimeMillis();
            try {
                if (this.myConstantSearchTime > 60000L) {
                    isSuccess.set((Object)Boolean.FALSE);
                    LOG.debug("Total constant search time exceeded time limit for this build session");
                    break block15;
                }
                if (this.isDumbMode()) {
                    isSuccess.set((Object)Boolean.FALSE);
                    LOG.debug("Constant search task: cannot search in dumb mode");
                    break block15;
                }
                final String qualifiedName = ownerClassName.replace('$', '.');
                this.handleCompileMessage(sessionId, CmdlineProtoUtil.createCompileProgressMessageResponse((String)("Searching for usages of changed/removed constants for class " + qualifiedName)).getCompileMessage());
                final PsiClass[] classes2 = (PsiClass[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass[]>(){

                    public PsiClass[] compute() {
                        return JavaPsiFacade.getInstance((Project)DefaultMessageHandler.this.myProject).findClasses(qualifiedName, GlobalSearchScope.allScope((Project)DefaultMessageHandler.this.myProject));
                    }
                });
                try {
                    if (isRemoved) {
                        ApplicationManager.getApplication().runReadAction(() -> {
                            if (classes2.length > 0) {
                                for (PsiClass aClass : classes2) {
                                    boolean success;
                                    boolean bl = success = aClass.isValid() && this.performRemovedConstantSearch(aClass, fieldName, accessFlags, affectedPaths);
                                    if (success) continue;
                                    isSuccess.set((Object)Boolean.FALSE);
                                    break;
                                }
                            } else {
                                isSuccess.set((Object)this.performRemovedConstantSearch(null, fieldName, accessFlags, affectedPaths));
                            }
                        });
                        break block15;
                    }
                    if (classes2.length > 0) {
                        Collection changedFields = (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<PsiField>>(){

                            public Collection<PsiField> compute() {
                                SmartList fields = new SmartList();
                                for (PsiClass aClass : classes2) {
                                    if (!aClass.isValid()) {
                                        return Collections.emptyList();
                                    }
                                    PsiField changedField = aClass.findFieldByName(fieldName, false);
                                    if (changedField == null) continue;
                                    fields.add(changedField);
                                }
                                return fields;
                            }
                        });
                        if (changedFields.isEmpty()) {
                            isSuccess.set((Object)Boolean.FALSE);
                            LOG.debug("Constant search task: field " + fieldName + " not found in classes " + qualifiedName);
                        } else {
                            for (PsiField changedField : changedFields) {
                                if (!accessChanged && DefaultMessageHandler.isPrivate(accessFlags)) continue;
                                this.affectDirectUsages(changedField, accessChanged, affectedPaths);
                            }
                        }
                        break block15;
                    }
                    isSuccess.set((Object)Boolean.FALSE);
                    LOG.debug("Constant search task: class " + qualifiedName + " not found");
                }
                catch (Throwable e) {
                    isSuccess.set((Object)Boolean.FALSE);
                    LOG.debug("Constant search task: failed with message " + e.getMessage());
                }
            }
            catch (ProcessCanceledException e) {
                canceled = true;
                throw e;
            }
            finally {
                this.myConstantSearchTime += System.currentTimeMillis() - searchStart;
                if (!canceled) {
                    DefaultMessageHandler.notifyConstantSearchFinished(channel, sessionId, ownerClassName, fieldName, (Ref<Boolean>)isSuccess, affectedPaths);
                }
            }
        }
    }

    private static void notifyConstantSearchFinished(Channel channel, UUID sessionId, String ownerClassName, String fieldName, Ref<Boolean> isSuccess, Set<String> affectedPaths) {
        CmdlineRemoteProto.Message.ControllerMessage.ConstantSearchResult.Builder builder = CmdlineRemoteProto.Message.ControllerMessage.ConstantSearchResult.newBuilder();
        builder.setOwnerClassName(ownerClassName);
        builder.setFieldName(fieldName);
        if (((Boolean)isSuccess.get()).booleanValue()) {
            builder.setIsSuccess(true);
            builder.addAllPath(affectedPaths);
            LOG.debug("Constant search task: " + affectedPaths.size() + " affected files found");
        } else {
            builder.setIsSuccess(false);
            LOG.debug("Constant search task: unsuccessful");
        }
        channel.writeAndFlush((Object)CmdlineProtoUtil.toMessage((UUID)sessionId, (CmdlineRemoteProto.Message.ControllerMessage)CmdlineRemoteProto.Message.ControllerMessage.newBuilder().setType(CmdlineRemoteProto.Message.ControllerMessage.Type.CONSTANT_SEARCH_RESULT).setConstantSearchResult(builder.build()).build()));
    }

    private boolean isDumbMode() {
        DumbService dumbService = DumbService.getInstance((Project)this.myProject);
        boolean isDumb = dumbService.isDumb();
        if (isDumb) {
            for (int idx = 0; idx < 5; ++idx) {
                TimeoutUtil.sleep((long)10L);
                isDumb = dumbService.isDumb();
                if (!isDumb) break;
            }
        }
        return isDumb;
    }

    private boolean performRemovedConstantSearch(@Nullable PsiClass aClass, String fieldName, int fieldAccessFlags, final Set<String> affectedPaths) {
        PsiSearchHelper psiSearchHelper = PsiSearchHelper.SERVICE.getInstance((Project)this.myProject);
        final Ref result2 = new Ref((Object)Boolean.TRUE);
        final PsiFile fieldContainingFile = aClass != null ? aClass.getContainingFile() : null;
        DefaultMessageHandler.processIdentifiers(psiSearchHelper, new PsiElementProcessor<PsiIdentifier>(){

            public boolean execute(@NotNull PsiIdentifier identifier) {
                try {
                    VirtualFile vFile;
                    PsiFile usageFile;
                    PsiClass ownerClass;
                    PsiElement parent = identifier.getParent();
                    if (parent instanceof PsiReferenceExpression && (ownerClass = DefaultMessageHandler.getOwnerClass(parent)) != null && ownerClass.getQualifiedName() != null && (usageFile = ownerClass.getContainingFile()) != null && !usageFile.equals(fieldContainingFile) && (vFile = usageFile.getOriginalFile().getVirtualFile()) != null) {
                        affectedPaths.add(vFile.getPath());
                    }
                    return true;
                }
                catch (PsiInvalidElementAccessException ignored) {
                    result2.set((Object)Boolean.FALSE);
                    LOG.debug("Constant search task: PIEAE thrown while searching of usages of removed constant");
                    return false;
                }
            }
        }, fieldName, this.getSearchScope(aClass, fieldAccessFlags), (short)1);
        return (Boolean)result2.get();
    }

    private SearchScope getSearchScope(PsiClass aClass, int fieldAccessFlags) {
        PsiFile containingFile;
        GlobalSearchScope searchScope = GlobalSearchScope.projectScope((Project)this.myProject);
        if (aClass != null && DefaultMessageHandler.isPackageLocal(fieldAccessFlags) && (containingFile = aClass.getContainingFile()) instanceof PsiJavaFile) {
            String packageName = ((PsiJavaFile)containingFile).getPackageName();
            PsiPackage aPackage = JavaPsiFacade.getInstance((Project)this.myProject).findPackage(packageName);
            if (aPackage != null) {
                searchScope = PackageScope.packageScope((PsiPackage)aPackage, (boolean)false);
                searchScope = searchScope.intersectWith(aClass.getUseScope());
            }
        }
        return searchScope;
    }

    private static boolean processIdentifiers(PsiSearchHelper helper, final @NotNull PsiElementProcessor<PsiIdentifier> processor2, @NotNull String identifier, @NotNull SearchScope searchScope, short searchContext) {
        TextOccurenceProcessor processor1 = new TextOccurenceProcessor(){

            public boolean execute(@NotNull PsiElement element, int offsetInElement) {
                return !(element instanceof PsiIdentifier) || processor2.execute((PsiElement)((PsiIdentifier)element));
            }
        };
        SearchScope javaScope = searchScope instanceof GlobalSearchScope ? GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)searchScope), (FileType[])new FileType[]{JavaFileType.INSTANCE}) : searchScope;
        return helper.processElementsWithWord(processor1, javaScope, identifier, searchContext, true, false);
    }

    private void affectDirectUsages(PsiField psiField, boolean ignoreAccessScope, Set<String> affectedPaths) throws ProcessCanceledException {
        ApplicationManager.getApplication().runReadAction(() -> {
            if (psiField.isValid()) {
                PsiFile fieldContainingFile = psiField.getContainingFile();
                HashSet<PsiFile> processedFiles = new HashSet<PsiFile>();
                if (fieldContainingFile != null) {
                    processedFiles.add(fieldContainingFile);
                }
                Collection<PsiReferenceExpression> references = this.doFindReferences(psiField, ignoreAccessScope);
                for (PsiReferenceExpression ref : references) {
                    VirtualFile vFile;
                    PsiElement usage = ref.getElement();
                    PsiFile containingPsi = usage.getContainingFile();
                    if (containingPsi == null || !processedFiles.add(containingPsi) || (vFile = containingPsi.getOriginalFile().getVirtualFile()) == null) continue;
                    affectedPaths.add(vFile.getPath());
                }
            }
        });
    }

    private Collection<PsiReferenceExpression> doFindReferences(final PsiField psiField, boolean ignoreAccessScope) {
        final SmartList result2 = new SmartList();
        SearchScope searchScope = (ignoreAccessScope ? psiField.getContainingFile() : psiField).getUseScope();
        DefaultMessageHandler.processIdentifiers(PsiSearchHelper.SERVICE.getInstance((Project)this.myProject), new PsiElementProcessor<PsiIdentifier>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean execute(@NotNull PsiIdentifier identifier) {
                PsiReferenceExpression refExpression;
                PsiElement parent = identifier.getParent();
                if (parent instanceof PsiReferenceExpression && (refExpression = (PsiReferenceExpression)parent).isReferenceTo((PsiElement)psiField)) {
                    SmartList smartList = result2;
                    synchronized (smartList) {
                        result2.add((Object)refExpression);
                    }
                }
                return true;
            }
        }, psiField.getName(), searchScope, (short)1);
        return result2;
    }

    @Nullable
    private static PsiClass getOwnerClass(PsiElement element) {
        while (!(element instanceof PsiFile)) {
            if (element instanceof PsiClass && element.getParent() instanceof PsiJavaFile) {
                PsiClass psiClass = (PsiClass)element;
                if (JspPsiUtil.isInJspFile((PsiElement)psiClass)) {
                    return null;
                }
                PsiFile containingFile = psiClass.getContainingFile();
                if (containingFile == null) {
                    return null;
                }
                return JavaLanguage.INSTANCE.equals(containingFile.getLanguage()) ? psiClass : null;
            }
            element = element.getParent();
        }
        return null;
    }

    private static boolean isPackageLocal(int flags) {
        return (1 & flags) == 0 && (4 & flags) == 0 && (2 & flags) == 0;
    }

    private static boolean isPrivate(int flags) {
        return (2 & flags) != 0;
    }
}

