/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.ReadOnlyModificationException;
import com.intellij.configurationStore.StorageUtilKt;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.UnknownMacroNotification;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.UtilKt;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001aB\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0018\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00110\u00100\u000b2\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0000\u001a\u001b\u0010\u0013\u001a\u00020\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016\u001a \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u001a\u001f\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0015*\b\u0012\u0004\u0012\u00020\u00070\u0015H\u0000\u00a2\u0006\u0002\u0010 \"\u0019\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006!"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "deprecatedComparator", "Ljava/util/Comparator;", "Lcom/intellij/openapi/components/Storage;", "getDeprecatedComparator", "()Ljava/util/Comparator;", "executeSave", "", "", "session", "Lcom/intellij/openapi/components/StateStorage$SaveSession;", "readonlyFiles", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/openapi/vfs/VirtualFile;", "previousErrors", "findNonDeprecated", "storages", "", "([Lcom/intellij/openapi/components/Storage;)Lcom/intellij/openapi/components/Storage;", "notifyUnknownMacros", "", "store", "Lcom/intellij/openapi/components/impl/stores/IComponentStore;", "project", "Lcom/intellij/openapi/project/Project;", "componentName", "", "sortByDeprecated", "([Lcom/intellij/openapi/components/Storage;)[Lcom/intellij/openapi/components/Storage;", "configuration-store-impl"})
public final class ComponentStoreImplKt {
    @NotNull
    private static final Logger LOG = Logger.getInstance(ComponentStoreImpl.class);
    @NotNull
    private static final Comparator<Storage> deprecatedComparator = deprecatedComparator.1.INSTANCE;

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    @NotNull
    public static final Comparator<Storage> getDeprecatedComparator() {
        return deprecatedComparator;
    }

    @Nullable
    public static final List<Throwable> executeSave(@NotNull StateStorage.SaveSession session2, @NotNull List<Pair<StateStorage.SaveSession, VirtualFile>> readonlyFiles, @Nullable List<Throwable> previousErrors) {
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        Intrinsics.checkParameterIsNotNull(readonlyFiles, (String)"readonlyFiles");
        List errors = previousErrors;
        try {
            session2.save();
        }
        catch (ReadOnlyModificationException e) {
            LOG.warn((Throwable)e);
            StateStorage.SaveSession saveSession = e.getSession();
            if (saveSession == null) {
                saveSession = session2;
            }
            Pair pair = Pair.create((Object)saveSession, (Object)e.getFile());
            Intrinsics.checkExpressionValueIsNotNull((Object)pair, (String)"JBPair.create<SaveSessio\u2026ssion ?: session, e.file)");
            readonlyFiles.add((Pair<StateStorage.SaveSession, VirtualFile>)pair);
        }
        catch (Exception e) {
            if (errors == null) {
                errors = (List)new SmartList();
            }
            errors.add((Throwable)e);
        }
        return errors;
    }

    private static final Storage findNonDeprecated(Storage[] storages) {
        for (int j = 0; j < storages.length; ++j) {
            Storage storage2 = storages[j];
            if (storage2.deprecated()) continue;
            return storage2;
        }
        throw (Throwable)((Object)new AssertionError((Object)"All storages are deprecated"));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Storage[] sortByDeprecated(@NotNull Storage[] $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Object[] objectArray = $receiver;
        if (objectArray.length == 0) {
            return $receiver;
        }
        if (!$receiver[0].deprecated()) {
            boolean othersAreDeprecated = true;
            int n = 1;
            int n2 = ((Object[])$receiver).length - 1;
            if (n <= n2) {
                while (true) {
                    void i2;
                    if (!$receiver[i2].deprecated()) {
                        othersAreDeprecated = false;
                        break;
                    }
                    if (i2 == n2) break;
                    ++i2;
                }
            }
            if (othersAreDeprecated) {
                return $receiver;
            }
        }
        return (Storage[])ArraysKt.sortedArrayWith((Object[])$receiver, deprecatedComparator);
    }

    private static final void notifyUnknownMacros(IComponentStore store, Project project2, String componentName) {
        TrackingPathMacroSubstitutor trackingPathMacroSubstitutor = store.getStateStorageManager().getMacroSubstitutor();
        if (trackingPathMacroSubstitutor == null) {
            return;
        }
        TrackingPathMacroSubstitutor substitutor = trackingPathMacroSubstitutor;
        Set<String> immutableMacros = substitutor.getUnknownMacros(componentName);
        if (immutableMacros.isEmpty()) {
            return;
        }
        LinkedHashSet macros = new LinkedHashSet(immutableMacros);
        AppUIUtil.invokeOnEdt(new Runnable(project2, macros, componentName, substitutor, store){
            final /* synthetic */ Project $project;
            final /* synthetic */ LinkedHashSet $macros;
            final /* synthetic */ String $componentName;
            final /* synthetic */ TrackingPathMacroSubstitutor $substitutor;
            final /* synthetic */ IComponentStore $store;

            public final void run() {
                List notified = null;
                NotificationsManager manager = NotificationsManager.getNotificationsManager();
                UnknownMacroNotification[] unknownMacroNotificationArray = (UnknownMacroNotification[])manager.getNotificationsOfType(UnknownMacroNotification.class, this.$project);
                for (int j = 0; j < unknownMacroNotificationArray.length; ++j) {
                    UnknownMacroNotification notification = unknownMacroNotificationArray[j];
                    if (notified == null) {
                        notified = (List)new SmartList();
                    }
                    Collection<String> collection = notification.getMacros();
                    Intrinsics.checkExpressionValueIsNotNull(collection, (String)"notification.macros");
                    notified.addAll(collection);
                }
                if (!UtilKt.isNullOrEmpty(notified)) {
                    List list = notified;
                    if (list == null) {
                        Intrinsics.throwNpe();
                    }
                    this.$macros.removeAll(list);
                }
                if (this.$macros.isEmpty()) {
                    return;
                }
                ComponentStoreImplKt.getLOG().debug("Reporting unknown path macros " + this.$macros + " in component " + this.$componentName);
                Set set2 = this.$macros;
                Map<TrackingPathMacroSubstitutor, IComponentStore> map2 = Collections.singletonMap(this.$substitutor, this.$store);
                Intrinsics.checkExpressionValueIsNotNull(map2, (String)"Collections.singletonMap(substitutor, store)");
                StorageUtilKt.doNotify(set2, this.$project, map2);
            }
            {
                this.$project = project2;
                this.$macros = linkedHashSet;
                this.$componentName = string;
                this.$substitutor = trackingPathMacroSubstitutor;
                this.$store = iComponentStore;
            }
        }, project2.getDisposed());
    }

    public static final /* synthetic */ void access$notifyUnknownMacros(@NotNull IComponentStore store, @NotNull Project project2, @NotNull String componentName) {
        ComponentStoreImplKt.notifyUnknownMacros(store, project2, componentName);
    }

    @NotNull
    public static final /* synthetic */ Storage access$findNonDeprecated(@NotNull Storage[] storages) {
        return ComponentStoreImplKt.findNonDeprecated(storages);
    }
}

