/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.StreamProvider;
import com.intellij.openapi.components.RoamingType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.JdomKt;
import com.intellij.util.PathUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012JL\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\u00162\u001e\u0010\u0017\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0018H\u0016J.\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0014\u0010\u001b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0004\u0012\u00020\u00100\u0016H\u0016J(\u0010\u001c\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R/\u0010\u0005\u001a#\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00030\u0003\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\b0\b0\u0006\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/configurationStore/SchemeManagerIprProvider;", "Lcom/intellij/configurationStore/StreamProvider;", "subStateTagName", "", "(Ljava/lang/String;)V", "nameToData", "Ljava/util/concurrent/ConcurrentMap;", "kotlin.jvm.PlatformType", "", "Lorg/jetbrains/annotations/NotNull;", "delete", "", "fileSpec", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "load", "", "state", "Lorg/jdom/Element;", "processChildren", "path", "filter", "Lkotlin/Function1;", "processor", "Lkotlin/Function3;", "Ljava/io/InputStream;", "read", "consumer", "write", "content", "size", "", "writeState", "projectModel-impl"})
public final class SchemeManagerIprProvider
implements StreamProvider {
    private final ConcurrentMap<String, byte[]> nameToData;
    private final String subStateTagName;

    public boolean read(@NotNull String fileSpec, @NotNull RoamingType roamingType, @NotNull Function1<? super InputStream, Unit> consumer2) {
        ByteArrayInputStream byteArrayInputStream;
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        Intrinsics.checkParameterIsNotNull(consumer2, (String)"consumer");
        byte[] byArray2 = (byte[])this.nameToData.get(PathUtilRt.getFileName((String)fileSpec));
        if (byArray2 != null) {
            byte[] p1;
            byte[] byArray3 = p1 = (byArray = byArray2);
            byteArrayInputStream = new ByteArrayInputStream(byArray3);
        } else {
            byteArrayInputStream = null;
        }
        byArray = byteArrayInputStream;
        ByteArrayInputStream it = (ByteArrayInputStream)byArray;
        consumer2.invoke((Object)it);
        return true;
    }

    public boolean delete(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        this.nameToData.remove(PathUtilRt.getFileName((String)fileSpec));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processChildren(@NotNull String path, @NotNull RoamingType roamingType, @NotNull Function1<? super String, Boolean> filter, @NotNull Function3<? super String, ? super InputStream, ? super Boolean, Boolean> processor2) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        Map map2 = this.nameToData;
        for (Map.Entry entry : map2.entrySet()) {
            boolean bl;
            Object object = entry;
            String name = (String)object.getKey();
            object = entry;
            byte[] data = (byte[])object.getValue();
            String string = name;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
            if (!((Boolean)filter.invoke((Object)string)).booleanValue()) continue;
            object = data;
            object = new ByteArrayInputStream((byte[])object);
            boolean bl2 = false;
            try {
                ByteArrayInputStream it = (ByteArrayInputStream)object;
                String string2 = name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
                bl = (Boolean)processor2.invoke((Object)string2, (Object)it, (Object)false);
            }
            catch (Exception exception) {
                bl2 = true;
                try {
                    object.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            finally {
                if (!bl2) {
                    object.close();
                }
            }
            if (bl) continue;
            break;
        }
        return true;
    }

    public void write(@NotNull String fileSpec, @NotNull byte[] content, int size, @NotNull RoamingType roamingType) {
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        String name = PathUtilRt.getFileName((String)fileSpec);
        this.nameToData.put(name, ArrayUtil.realloc((byte[])content, (int)size));
    }

    public final void load(@Nullable Element state) {
        this.nameToData.clear();
        if (state == null) {
            return;
        }
        for (Element profileElement : state.getChildren(this.subStateTagName)) {
            String name = null;
            for (Element optionElement : profileElement.getChildren("option")) {
                if (!Intrinsics.areEqual((Object)optionElement.getAttributeValue("name"), (Object)"myName")) continue;
                name = optionElement.getAttributeValue("value");
            }
            CharSequence charSequence = name;
            if (charSequence == null || charSequence.length() == 0) continue;
            this.nameToData.put(name + ".xml", JdomKt.toByteArray((Element)profileElement));
        }
    }

    public final void writeState(@NotNull Element state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Comparable[] $receiver$iv = (Comparable[])this.nameToData.keySet();
        if ($receiver$iv == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Comparable[] thisCollection$iv = $receiver$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] names = (String[])((Object[])stringArray);
        $receiver$iv = (Comparable[])names;
        if ($receiver$iv == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
        }
        ArraysKt.sort((Object[])$receiver$iv);
        for (int j = 0; j < names.length; ++j) {
            byte[] byArray;
            byte[] it;
            String name = names[j];
            if ((byte[])this.nameToData.get(name) == null) continue;
            byte[] byArray2 = it = byArray;
            Element element = state;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            element.addContent(JdomKt.loadElement((InputStream)byteArrayInputStream));
        }
    }

    public SchemeManagerIprProvider(@NotNull String subStateTagName) {
        Intrinsics.checkParameterIsNotNull((Object)subStateTagName, (String)"subStateTagName");
        this.subStateTagName = subStateTagName;
        this.nameToData = ContainerUtil.newConcurrentMap();
    }

    public boolean getEnabled() {
        return StreamProvider.DefaultImpls.getEnabled((StreamProvider)this);
    }

    public boolean isApplicable(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        return StreamProvider.DefaultImpls.isApplicable((StreamProvider)this, (String)fileSpec, (RoamingType)roamingType);
    }
}

