/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ModuleSettings;
import java.util.Collection;
import org.jdom.Element;

public class DetachFacetConversionProcessor
extends ConversionProcessor<ModuleSettings> {
    private final String[] myFacetNames;

    public DetachFacetConversionProcessor(String ... names) {
        this.myFacetNames = names;
    }

    @Override
    public boolean isConversionNeeded(ModuleSettings moduleSettings) {
        for (String facetName : this.myFacetNames) {
            if (facetName == null || moduleSettings.getFacetElements(facetName).isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void process(ModuleSettings moduleSettings) throws CannotConvertException {
        Element facetManagerElement = moduleSettings.getComponentElement("FacetManager");
        if (facetManagerElement == null) {
            return;
        }
        for (String facetName : this.myFacetNames) {
            for (Element element : DetachFacetConversionProcessor.getElements(moduleSettings, facetName)) {
                element.detach();
            }
        }
    }

    private static Element[] getElements(ModuleSettings moduleSettings, String facetName) {
        Collection<? extends Element> elements = moduleSettings.getFacetElements(facetName);
        return elements.toArray(new Element[elements.size()]);
    }
}

