/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion.impl;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ComponentManagerSettings;
import com.intellij.conversion.ModuleSettings;
import com.intellij.conversion.impl.ComponentManagerSettingsImpl;
import com.intellij.conversion.impl.ConversionContextImpl;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

public class ModuleSettingsImpl
extends ComponentManagerSettingsImpl
implements ModuleSettings {
    private final String myModuleName;

    public ModuleSettingsImpl(File moduleFile, ConversionContextImpl context) throws CannotConvertException {
        super(moduleFile, context);
        this.myModuleName = ModuleSettingsImpl.getModuleName(moduleFile);
    }

    public static String getModuleName(File moduleFile) {
        return StringUtil.trimEnd((String)moduleFile.getName(), (String)".iml");
    }

    @Override
    @NotNull
    public String getModuleName() {
        return this.myModuleName;
    }

    @Override
    @Nullable
    public String getModuleType() {
        return this.getRootElement().getAttributeValue("type");
    }

    @Override
    @NotNull
    public File getModuleFile() {
        return this.mySettingsFile.getFile();
    }

    @Override
    @NotNull
    public Collection<? extends Element> getFacetElements(@NotNull String facetTypeId) {
        Element facetManager = this.getComponentElement("FacetManager");
        ArrayList<Element> elements = new ArrayList<Element>();
        ModuleSettingsImpl.addFacetTypes(facetTypeId, facetManager, elements);
        return elements;
    }

    private static void addFacetTypes(@NotNull String facetTypeId, @Nullable Element parent, @NotNull ArrayList<Element> elements) {
        for (Element child : JDOMUtil.getChildren((Element)parent, (String)"facet")) {
            if (facetTypeId.equals(child.getAttributeValue("type"))) {
                elements.add(child);
                continue;
            }
            ModuleSettingsImpl.addFacetTypes(facetTypeId, child, elements);
        }
    }

    @Override
    public Element getFacetElement(@NotNull String facetTypeId) {
        return (Element)ContainerUtil.getFirstItem(this.getFacetElements(facetTypeId), null);
    }

    @Override
    public void addFacetElement(@NotNull String facetTypeId, @NotNull String facetName, Element configuration) {
        Element componentElement = JDomSerializationUtil.findOrCreateComponentElement((Element)this.getRootElement(), (String)"FacetManager");
        Element facetElement = new Element("facet");
        facetElement.setAttribute("type", facetTypeId);
        facetElement.setAttribute("name", facetName);
        configuration.setName("configuration");
        facetElement.addContent(configuration);
        componentElement.addContent(facetElement);
    }

    @Override
    public void setModuleType(@NotNull String moduleType) {
        this.getRootElement().setAttribute("type", moduleType);
    }

    @Override
    @NotNull
    public String expandPath(@NotNull String path) {
        return this.myContext.expandPath(path, this);
    }

    @Override
    @NotNull
    public String collapsePath(@NotNull String path) {
        return ConversionContextImpl.collapsePath(path, this);
    }

    @Override
    @NotNull
    public Collection<File> getSourceRoots(boolean includeTests) {
        ArrayList<File> result2 = new ArrayList<File>();
        for (Element contentRoot : this.getContentRootElements()) {
            for (Element sourceFolder : JDOMUtil.getChildren((Element)contentRoot, (String)"sourceFolder")) {
                boolean isTestFolder = Boolean.parseBoolean(sourceFolder.getAttributeValue("isTestSource"));
                if (!includeTests && isTestFolder) continue;
                result2.add(this.getFile(sourceFolder.getAttributeValue("url")));
            }
        }
        return result2;
    }

    private List<Element> getContentRootElements() {
        return JDOMUtil.getChildren((Element)this.getComponentElement("NewModuleRootManager"), (String)"content");
    }

    @Override
    @NotNull
    public Collection<File> getContentRoots() {
        ArrayList<File> result2 = new ArrayList<File>();
        for (Element contentRoot : this.getContentRootElements()) {
            String path = VfsUtil.urlToPath((String)contentRoot.getAttributeValue("url"));
            result2.add(new File(FileUtil.toSystemDependentName((String)this.expandPath(path))));
        }
        return result2;
    }

    @Override
    @Nullable
    public String getProjectOutputUrl() {
        ComponentManagerSettings rootManagerSettings = this.myContext.getProjectRootManagerSettings();
        Element projectRootManager = rootManagerSettings == null ? null : rootManagerSettings.getComponentElement("ProjectRootManager");
        Element outputElement = projectRootManager == null ? null : projectRootManager.getChild("output");
        return outputElement == null ? null : outputElement.getAttributeValue("url");
    }

    @Override
    public void addExcludedFolder(@NotNull File directory) {
        File outputFile;
        String outputUrl;
        Element outputElement;
        Element projectRootManager;
        ComponentManagerSettings rootManagerSettings = this.myContext.getProjectRootManagerSettings();
        if (rootManagerSettings != null && (projectRootManager = rootManagerSettings.getComponentElement("ProjectRootManager")) != null && (outputElement = projectRootManager.getChild("output")) != null && (outputUrl = outputElement.getAttributeValue("url")) != null && FileUtil.isAncestor((File)(outputFile = this.getFile(outputUrl)), (File)directory, (boolean)false)) {
            return;
        }
        for (Element contentRoot : this.getContentRootElements()) {
            File root = this.getFile(contentRoot.getAttributeValue("url"));
            if (!FileUtil.isAncestor((File)root, (File)directory, (boolean)true)) continue;
            this.addExcludedFolder(directory, contentRoot);
        }
    }

    @Override
    @NotNull
    public List<File> getModuleLibraryRoots(String libraryName) {
        Element library = this.findModuleLibraryElement(libraryName);
        return library != null ? this.myContext.getClassRoots(library, this) : Collections.emptyList();
    }

    @Override
    public boolean hasModuleLibrary(String libraryName) {
        return this.findModuleLibraryElement(libraryName) != null;
    }

    @Nullable
    private Element findModuleLibraryElement(String libraryName) {
        for (Element element : this.getOrderEntries()) {
            Element library;
            if (!"module-library".equals(element.getAttributeValue("type")) || (library = element.getChild("library")) == null || !libraryName.equals(library.getAttributeValue("name"))) continue;
            return library;
        }
        return null;
    }

    @Override
    public List<Element> getOrderEntries() {
        Element component = this.getComponentElement("NewModuleRootManager");
        return JDOMUtil.getChildren((Element)component, (String)"orderEntry");
    }

    @Override
    @NotNull
    public Collection<ModuleSettings> getAllModuleDependencies() {
        HashSet<ModuleSettings> dependencies = new HashSet<ModuleSettings>();
        this.collectDependencies(dependencies);
        return dependencies;
    }

    private void collectDependencies(Set<ModuleSettings> dependencies) {
        if (!dependencies.add(this)) {
            return;
        }
        for (Element element : this.getOrderEntries()) {
            ModuleSettings moduleSettings;
            String moduleName;
            if (!"module".equals(element.getAttributeValue("type")) || (moduleName = element.getAttributeValue("module-name")) == null || (moduleSettings = this.myContext.getModuleSettings(moduleName)) == null) continue;
            ((ModuleSettingsImpl)moduleSettings).collectDependencies(dependencies);
        }
    }

    private void addExcludedFolder(File directory, Element contentRoot) {
        for (Element excludedFolder : JDOMUtil.getChildren((Element)contentRoot, (String)"excludeFolder")) {
            File excludedDir = this.getFile(excludedFolder.getAttributeValue("url"));
            if (!FileUtil.isAncestor((File)excludedDir, (File)directory, (boolean)false)) continue;
            return;
        }
        String path = ConversionContextImpl.collapsePath(FileUtil.toSystemIndependentName((String)directory.getAbsolutePath()), this);
        contentRoot.addContent(new Element("excludeFolder").setAttribute("url", VfsUtil.pathToUrl((String)path)));
    }

    private File getFile(String url) {
        return new File(FileUtil.toSystemDependentName((String)this.expandPath(VfsUtil.urlToPath((String)url))));
    }
}

