/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.DefaultASTFactory;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.PsiCoreCommentImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import org.jetbrains.annotations.NotNull;

public class CoreASTFactory
extends ASTFactory
implements DefaultASTFactory {
    @Override
    @NotNull
    public LazyParseableElement createLazy(ILazyParseableElementType type2, CharSequence text) {
        if (type2 instanceof IFileElementType) {
            return new FileElement((IElementType)type2, text);
        }
        return new LazyParseableElement((IElementType)type2, text);
    }

    @Override
    @NotNull
    public CompositeElement createComposite(IElementType type2) {
        if (type2 instanceof IFileElementType) {
            return new FileElement(type2, null);
        }
        return new CompositeElement(type2);
    }

    @Override
    @NotNull
    public LeafElement createLeaf(@NotNull IElementType type2, @NotNull CharSequence text) {
        Language lang = type2.getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (parserDefinition != null && parserDefinition.getCommentTokens().contains(type2)) {
            return this.createComment(type2, text);
        }
        return new LeafPsiElement(type2, text);
    }

    @Override
    @NotNull
    public LeafElement createComment(@NotNull IElementType type2, @NotNull CharSequence text) {
        return new PsiCoreCommentImpl(type2, text);
    }
}

