/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.core.CoreJavaFileManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CoreJavaDirectoryService
extends JavaDirectoryService {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.core.CoreJavaDirectoryService");

    public PsiPackage getPackage(@NotNull PsiDirectory dir) {
        return ((CoreJavaFileManager)ServiceManager.getService((Project)dir.getProject(), CoreJavaFileManager.class)).getPackage(dir);
    }

    @NotNull
    public PsiClass[] getClasses(@NotNull PsiDirectory dir) {
        LOG.assertTrue(dir.isValid());
        return CoreJavaDirectoryService.getPsiClasses(dir, dir.getFiles());
    }

    @NotNull
    public static PsiClass[] getPsiClasses(@NotNull PsiDirectory dir, PsiFile[] psiFiles2) {
        VirtualFile virtualDir;
        FileIndexFacade index = FileIndexFacade.getInstance((Project)dir.getProject());
        boolean onlyCompiled = index.isInLibraryClasses(virtualDir = dir.getVirtualFile()) && !index.isInSourceContent(virtualDir);
        ArrayList classes2 = null;
        for (PsiFile file2 : psiFiles2) {
            Object[] psiClasses;
            if (onlyCompiled && !(file2 instanceof ClsFileImpl) || !(file2 instanceof PsiClassOwner) || file2.getViewProvider().getLanguages().size() != 1 || (psiClasses = ((PsiClassOwner)file2).getClasses()).length == 0) continue;
            if (classes2 == null) {
                classes2 = new ArrayList();
            }
            ContainerUtil.addAll((Collection)classes2, (Object[])psiClasses);
        }
        return classes2 == null ? PsiClass.EMPTY_ARRAY : classes2.toArray(new PsiClass[classes2.size()]);
    }

    @NotNull
    public PsiClass createClass(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public PsiClass createClass(@NotNull PsiDirectory dir, @NotNull String name, @NotNull String templateName) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    public PsiClass createClass(@NotNull PsiDirectory dir, @NotNull String name, @NotNull String templateName, boolean askForUndefinedVariables) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    public PsiClass createClass(@NotNull PsiDirectory dir, @NotNull String name, @NotNull String templateName, boolean askForUndefinedVariables, @NotNull Map<String, String> additionalProperties) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    public void checkCreateClass(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public PsiClass createInterface(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public PsiClass createEnum(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public PsiClass createAnnotationType(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean isSourceRoot(@NotNull PsiDirectory dir) {
        return false;
    }

    public LanguageLevel getLanguageLevel(@NotNull PsiDirectory dir) {
        return LanguageLevel.HIGHEST;
    }
}

