/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.core.CoreEncodingProjectManager;
import com.intellij.core.CoreProjectScopeBuilder;
import com.intellij.core.CorePsiDocumentManager;
import com.intellij.core.MockDocumentCommitProcessor;
import com.intellij.mock.MockDumbService;
import com.intellij.mock.MockFileIndexFacade;
import com.intellij.mock.MockProject;
import com.intellij.mock.MockResolveScopeManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.impl.PsiCachedValuesFactory;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.impl.file.PsiDirectoryFactoryImpl;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.ProjectScopeBuilder;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.CachedValuesManagerImpl;
import com.intellij.util.messages.MessageBus;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.PicoContainer;

public class CoreProjectEnvironment {
    private final Disposable myParentDisposable;
    private final CoreApplicationEnvironment myEnvironment;
    protected final FileIndexFacade myFileIndexFacade;
    protected final PsiManagerImpl myPsiManager;
    protected final MockProject myProject;
    protected final MessageBus myMessageBus;

    public CoreProjectEnvironment(@NotNull Disposable parentDisposable, @NotNull CoreApplicationEnvironment applicationEnvironment) {
        this.myParentDisposable = parentDisposable;
        this.myEnvironment = applicationEnvironment;
        this.myProject = this.createProject((PicoContainer)this.myEnvironment.getApplication().getPicoContainer(), this.myParentDisposable);
        this.preregisterServices();
        this.myFileIndexFacade = this.createFileIndexFacade();
        this.myMessageBus = this.myProject.getMessageBus();
        PsiModificationTrackerImpl modificationTracker = new PsiModificationTrackerImpl(this.myProject);
        this.myProject.registerService(PsiModificationTracker.class, modificationTracker);
        this.myProject.registerService(FileIndexFacade.class, this.myFileIndexFacade);
        this.myProject.registerService(ResolveCache.class, new ResolveCache(this.myMessageBus));
        this.myPsiManager = new PsiManagerImpl(this.myProject, null, null, this.myFileIndexFacade, this.myMessageBus, modificationTracker);
        ((FileManagerImpl)this.myPsiManager.getFileManager()).markInitialized();
        this.registerProjectComponent(PsiManager.class, this.myPsiManager);
        this.myProject.registerService(SmartPointerManager.class, SmartPointerManagerImpl.class);
        this.registerProjectComponent(PsiDocumentManager.class, new CorePsiDocumentManager(this.myProject, this.myPsiManager, this.myMessageBus, new MockDocumentCommitProcessor()));
        this.myProject.registerService(ResolveScopeManager.class, this.createResolveScopeManager(this.myPsiManager));
        this.myProject.registerService(PsiFileFactory.class, new PsiFileFactoryImpl(this.myPsiManager));
        this.myProject.registerService(CachedValuesManager.class, new CachedValuesManagerImpl(this.myProject, new PsiCachedValuesFactory(this.myPsiManager)));
        this.myProject.registerService(PsiDirectoryFactory.class, new PsiDirectoryFactoryImpl(this.myPsiManager));
        this.myProject.registerService(ProjectScopeBuilder.class, this.createProjectScopeBuilder());
        this.myProject.registerService(DumbService.class, new MockDumbService(this.myProject));
        this.myProject.registerService(CoreEncodingProjectManager.class, CoreEncodingProjectManager.class);
    }

    @NotNull
    protected MockProject createProject(@NotNull PicoContainer parent, @NotNull Disposable parentDisposable) {
        return new MockProject(parent, parentDisposable);
    }

    @NotNull
    protected ProjectScopeBuilder createProjectScopeBuilder() {
        return new CoreProjectScopeBuilder(this.myProject, this.myFileIndexFacade);
    }

    protected void preregisterServices() {
    }

    @NotNull
    protected FileIndexFacade createFileIndexFacade() {
        return new MockFileIndexFacade(this.myProject);
    }

    @NotNull
    protected ResolveScopeManager createResolveScopeManager(@NotNull PsiManager psiManager) {
        return new MockResolveScopeManager(psiManager.getProject());
    }

    public <T> void registerProjectExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName, @NotNull Class<? extends T> aClass) {
        CoreApplicationEnvironment.registerExtensionPoint(Extensions.getArea((AreaInstance)this.myProject), extensionPointName, aClass);
    }

    public <T> void addProjectExtension(@NotNull ExtensionPointName<T> name, final @NotNull T extension) {
        final ExtensionPoint extensionPoint = Extensions.getArea((AreaInstance)this.myProject).getExtensionPoint(name);
        extensionPoint.registerExtension(extension);
        Disposer.register((Disposable)this.myParentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                extensionPoint.unregisterExtension(extension);
            }
        });
    }

    public <T> void registerProjectComponent(@NotNull Class<T> interfaceClass, @NotNull T implementation) {
        CoreApplicationEnvironment.registerComponentInstance(this.myProject.getPicoContainer(), interfaceClass, implementation);
    }

    @NotNull
    public Disposable getParentDisposable() {
        return this.myParentDisposable;
    }

    @NotNull
    public CoreApplicationEnvironment getEnvironment() {
        return this.myEnvironment;
    }

    @NotNull
    public MockProject getProject() {
        return this.myProject;
    }
}

