/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialStoreFactory;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.DbV1ConvertorKt;
import com.intellij.credentialStore.KeePassCredentialStore;
import com.intellij.credentialStore.KeePassCredentialStoreKt;
import com.intellij.credentialStore.PasswordDatabase;
import com.intellij.credentialStore.PasswordSafeSettings;
import com.intellij.credentialStore.ProviderType;
import com.intellij.ide.ApplicationLoadListener;
import com.intellij.ide.passwordSafe.PasswordStorage;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/credentialStore/PasswordDatabaseConvertor;", "Lcom/intellij/ide/ApplicationLoadListener;", "()V", "beforeComponentsCreated", "", "credential-store"})
public final class PasswordDatabaseConvertor
implements ApplicationLoadListener {
    @Override
    public void beforeComponentsCreated() {
        block8: {
            try {
                Map<CredentialAttributes, Credentials> map2;
                Path oldDbFile = Paths.get(PathManager.getConfigPath(), "options", "security.xml");
                if (!PathKt.exists((Path)oldDbFile)) break block8;
                PasswordSafeSettings settings = (PasswordSafeSettings)ServiceManager.getService(PasswordSafeSettings.class);
                if (Intrinsics.areEqual((Object)((Object)settings.getProviderType()), (Object)((Object)ProviderType.MEMORY_ONLY))) {
                    return;
                }
                PasswordDatabase oldDb = (PasswordDatabase)ServiceManager.getService(PasswordDatabase.class);
                if (oldDb.myDatabase.size() <= 1) break block8;
                Object object = ServiceManager.getService(PasswordDatabase.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getServic\u2026wordDatabase::class.java)");
                Map<CredentialAttributes, Credentials> newDb = DbV1ConvertorKt.convertOldDb((PasswordDatabase)object);
                if (newDb == null || !(!(map2 = newDb).isEmpty())) break block8;
                Logger $receiver$iv = CredentialStoreKt.getLOG();
                try {
                    CredentialStoreFactory[] credentialStoreFactoryArray = (CredentialStoreFactory[])CredentialStoreFactory.CREDENTIAL_STORE_FACTORY.getExtensions();
                    for (int j = 0; j < credentialStoreFactoryArray.length; ++j) {
                        PasswordStorage store;
                        CredentialStoreFactory factory = credentialStoreFactoryArray[j];
                        PasswordStorage passwordStorage = factory.create();
                        if (passwordStorage == null) {
                            continue;
                        }
                        PasswordStorage passwordStorage2 = store = passwordStorage;
                        Intrinsics.checkExpressionValueIsNotNull((Object)passwordStorage2, (String)"store");
                        KeePassCredentialStoreKt.copyTo(newDb, passwordStorage2);
                        return;
                    }
                }
                catch (ProcessCanceledException e$iv) {
                }
                catch (Throwable e$iv) {
                    $receiver$iv.error(e$iv);
                }
                new KeePassCredentialStore(newDb, null, false, null, null, 30, null).save();
            }
            catch (Throwable e) {
                CredentialStoreKt.getLOG().warn("Cannot check old password safe DB", e);
            }
        }
    }
}

