/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.PasswordSafeConfigurableKt;
import com.intellij.credentialStore.PasswordSafeSettingsListener;
import com.intellij.credentialStore.ProviderType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="PasswordSafe", storages={@Storage(value="security.xml", roamingType=RoamingType.DISABLED)})
public class PasswordSafeSettings
implements PersistentStateComponent<State> {
    public static final Topic<PasswordSafeSettingsListener> TOPIC = Topic.create((String)"PasswordSafeSettingsListener", PasswordSafeSettingsListener.class);
    private ProviderType myProviderType = PasswordSafeSettings.getDefaultProviderType();
    String keepassDb;

    private static ProviderType getDefaultProviderType() {
        return SystemInfo.isWindows ? ProviderType.KEEPASS : ProviderType.KEYCHAIN;
    }

    @NotNull
    public ProviderType getProviderType() {
        return SystemInfo.isWindows && this.myProviderType == ProviderType.KEYCHAIN ? ProviderType.KEEPASS : this.myProviderType;
    }

    public void setProviderType(@NotNull ProviderType value2) {
        ProviderType oldValue;
        if (value2 == ProviderType.DO_NOT_STORE) {
            value2 = ProviderType.MEMORY_ONLY;
        }
        if (value2 != (oldValue = this.myProviderType)) {
            this.myProviderType = value2;
            Application app = ApplicationManager.getApplication();
            if (app != null) {
                ((PasswordSafeSettingsListener)app.getMessageBus().syncPublisher(TOPIC)).typeChanged(oldValue, value2);
            }
        }
    }

    @NotNull
    public State getState() {
        State s = new State();
        s.PROVIDER = this.myProviderType;
        if (this.keepassDb != null && !this.keepassDb.equals(PasswordSafeConfigurableKt.getDefaultKeePassDbFilePath())) {
            s.keepassDb = this.keepassDb;
        }
        return s;
    }

    public void loadState(@NotNull State state) {
        this.setProviderType((ProviderType)((Object)ObjectUtils.chooseNotNull((Object)((Object)state.PROVIDER), (Object)((Object)PasswordSafeSettings.getDefaultProviderType()))));
        this.keepassDb = StringUtil.nullize((String)state.keepassDb, (boolean)true);
    }

    static /* synthetic */ ProviderType access$000() {
        return PasswordSafeSettings.getDefaultProviderType();
    }

    public static class State {
        public ProviderType PROVIDER = PasswordSafeSettings.access$000();
        public String keepassDb;
    }
}

