/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.intellij.credentialStore.kdbx.KeePassCredentials;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/credentialStore/kdbx/KdbxPassword;", "Lcom/intellij/credentialStore/kdbx/KeePassCredentials;", "password", "", "([B)V", "key", "getKey", "()[B", "credential-store"})
public final class KdbxPassword
implements KeePassCredentials {
    @NotNull
    private final byte[] key;

    @Override
    @NotNull
    public byte[] getKey() {
        return this.key;
    }

    public KdbxPassword(@NotNull byte[] password) {
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] byArray = md.digest(md.digest(password));
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"md.digest(md.digest(password))");
        this.key = byArray;
    }
}

