/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cyclicDependencies.ui;

import com.intellij.CommonBundle;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.cyclicDependencies.CyclicDependenciesBuilder;
import com.intellij.cyclicDependencies.actions.CyclicDependenciesHandler;
import com.intellij.cyclicDependencies.ui.CycleNode;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependenciesToolWindow;
import com.intellij.packageDependencies.DependencyUISettings;
import com.intellij.packageDependencies.ui.DependenciesPanel;
import com.intellij.packageDependencies.ui.DependenciesUsagesPanel;
import com.intellij.packageDependencies.ui.FileNode;
import com.intellij.packageDependencies.ui.Marker;
import com.intellij.packageDependencies.ui.ModuleNode;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.packageDependencies.ui.PackageNode;
import com.intellij.packageDependencies.ui.PackageTreeExpansionMonitor;
import com.intellij.packageDependencies.ui.RootNode;
import com.intellij.packageDependencies.ui.TreeExpansionMonitor;
import com.intellij.packageDependencies.ui.TreeModel;
import com.intellij.packageDependencies.ui.TreeModelBuilder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.content.Content;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class CyclicDependenciesPanel
extends JPanel
implements Disposable,
DataProvider {
    private static final HashSet<PsiFile> EMPTY_FILE_SET = new HashSet(0);
    private final HashMap<PsiPackage, Set<List<PsiPackage>>> myDependencies;
    private final MyTree myLeftTree = new MyTree();
    private final MyTree myRightTree = new MyTree();
    private final DependenciesUsagesPanel myUsagesPanel;
    private final TreeExpansionMonitor myRightTreeExpansionMonitor;
    private final TreeExpansionMonitor myLeftTreeExpansionMonitor;
    private final Project myProject;
    private final CyclicDependenciesBuilder myBuilder;
    private Content myContent;
    private final DependenciesPanel.DependencyPanelSettings mySettings = new DependenciesPanel.DependencyPanelSettings();
    public static final String DEFAULT_PACKAGE_ABBREVIATION = AnalysisScopeBundle.message((String)"dependencies.tree.node.default.package.abbreviation", (Object[])new Object[0]);

    public CyclicDependenciesPanel(Project project2, CyclicDependenciesBuilder builder) {
        super(new BorderLayout());
        this.myDependencies = builder.getCyclicDependencies();
        this.myBuilder = builder;
        this.myProject = project2;
        this.myUsagesPanel = new DependenciesUsagesPanel(this.myProject, Collections.singletonList(builder.getForwardBuilder()));
        Disposer.register((Disposable)this, (Disposable)this.myUsagesPanel);
        this.mySettings.UI_SHOW_MODULES = false;
        final Splitter treeSplitter = new Splitter();
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                treeSplitter.dispose();
            }
        });
        treeSplitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)((Object)this.myLeftTree)));
        treeSplitter.setSecondComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)((Object)this.myRightTree)));
        final Splitter splitter = new Splitter(true);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                splitter.dispose();
            }
        });
        splitter.setFirstComponent((JComponent)treeSplitter);
        splitter.setSecondComponent((JComponent)this.myUsagesPanel);
        this.add((Component)splitter, "Center");
        this.add((Component)this.createToolbar(), "North");
        this.myRightTreeExpansionMonitor = PackageTreeExpansionMonitor.install((JTree)((Object)this.myRightTree), this.myProject);
        this.myLeftTreeExpansionMonitor = PackageTreeExpansionMonitor.install((JTree)((Object)this.myLeftTree), this.myProject);
        this.updateLeftTreeModel();
        this.updateRightTreeModel();
        this.myLeftTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                CyclicDependenciesPanel.this.updateRightTreeModel();
                CyclicDependenciesPanel.this.myUsagesPanel.setToInitialPosition();
            }
        });
        this.myRightTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                SwingUtilities.invokeLater(() -> {
                    Set searchIn = CyclicDependenciesPanel.getSelectedScope(CyclicDependenciesPanel.this.myRightTree);
                    PackageNode selectedPackageNode = CyclicDependenciesPanel.getSelectedPackage(CyclicDependenciesPanel.this.myRightTree);
                    if (selectedPackageNode == null) {
                        return;
                    }
                    PackageDependenciesNode nextPackageNode = CyclicDependenciesPanel.getNextPackageNode(selectedPackageNode);
                    HashSet<PsiFile> searchFor = new HashSet<PsiFile>();
                    HashSet packNodes = new HashSet();
                    CyclicDependenciesPanel.getPackageNodesHierarchy(selectedPackageNode, packNodes);
                    for (PackageNode packageNode : packNodes) {
                        searchFor.addAll(CyclicDependenciesPanel.this.myBuilder.getDependentFilesInPackage((PsiPackage)packageNode.getPsiElement(), (PsiPackage)nextPackageNode.getPsiElement()));
                    }
                    if (searchIn.isEmpty() || searchFor.isEmpty()) {
                        CyclicDependenciesPanel.this.myUsagesPanel.setToInitialPosition();
                    } else {
                        CyclicDependenciesPanel.this.myBuilder.setRootNodeNameInUsageView(AnalysisScopeBundle.message((String)"cyclic.dependencies.usage.view.root.node.text", (Object[])new Object[]{((PsiPackage)nextPackageNode.getPsiElement()).getQualifiedName(), ((PsiPackage)selectedPackageNode.getPsiElement()).getQualifiedName()}));
                        CyclicDependenciesPanel.this.myUsagesPanel.findUsages(searchIn, searchFor);
                    }
                });
            }
        });
        this.initTree(this.myLeftTree);
        this.initTree(this.myRightTree);
        this.mySettings.UI_FILTER_LEGALS = false;
        this.mySettings.UI_FLATTEN_PACKAGES = false;
        TreeUtil.selectFirstNode((JTree)((Object)this.myLeftTree));
    }

    private static void getPackageNodesHierarchy(PackageNode node, Set<PackageNode> result2) {
        result2.add(node);
        for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
            PackageNode packNode;
            TreeNode child = node.getChildAt(i2);
            if (!(child instanceof PackageNode) || result2.contains(packNode = (PackageNode)child)) continue;
            CyclicDependenciesPanel.getPackageNodesHierarchy(packNode, result2);
        }
    }

    @Nullable
    private static PackageDependenciesNode getNextPackageNode(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode child = node;
        while (node != null) {
            if (node instanceof CycleNode) {
                TreeNode packageDependenciesNode;
                TreeNode treeNode = packageDependenciesNode = child.getNextSibling() != null ? child.getNextSibling() : node.getChildAt(0);
                if (packageDependenciesNode instanceof PackageNode) {
                    return (PackageNode)packageDependenciesNode;
                }
                if (packageDependenciesNode instanceof ModuleNode) {
                    return (PackageNode)packageDependenciesNode.getChildAt(0);
                }
            }
            child = node;
            node = (DefaultMutableTreeNode)node.getParent();
        }
        return null;
    }

    private static PackageDependenciesNode hideEmptyMiddlePackages(PackageDependenciesNode node, StringBuffer result2) {
        if (node.getChildCount() == 0 || node.getChildCount() > 1 || node.getChildCount() == 1 && node.getChildAt(0) instanceof FileNode) {
            result2.append(result2.length() != 0 ? "." : "").append(node.toString().equals(DEFAULT_PACKAGE_ABBREVIATION) ? "" : node.toString());
        } else if (node.getChildCount() == 1) {
            PackageDependenciesNode child = (PackageDependenciesNode)node.getChildAt(0);
            if (!(node instanceof PackageNode)) {
                node.removeAllChildren();
                child = CyclicDependenciesPanel.hideEmptyMiddlePackages(child, result2);
                node.add(child);
            } else if (child instanceof PackageNode) {
                node.removeAllChildren();
                result2.append(result2.length() != 0 ? "." : "").append(node.toString().equals(DEFAULT_PACKAGE_ABBREVIATION) ? "" : node.toString());
                node = CyclicDependenciesPanel.hideEmptyMiddlePackages(child, result2);
                ((PackageNode)node).setPackageName(result2.toString());
            }
        }
        return node;
    }

    private JComponent createToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new CloseAction());
        group.add((AnAction)new RerunAction(this));
        group.add((AnAction)new ShowFilesAction());
        group.add((AnAction)new HideOutOfCyclePackagesAction());
        group.add((AnAction)new GroupByScopeTypeAction());
        group.add((AnAction)new ContextHelpAction("dependency.viewer.tool.window"));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true);
        return toolbar.getComponent();
    }

    private void rebuild() {
        this.updateLeftTreeModel();
        this.updateRightTreeModel();
    }

    private void initTree(MyTree tree) {
        tree.getSelectionModel().setSelectionMode(1);
        tree.setCellRenderer((TreeCellRenderer)((Object)new MyTreeCellRenderer(tree == this.myLeftTree)));
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        UIUtil.setLineStyleAngled((JTree)((Object)tree));
        TreeUtil.installActions((JTree)((Object)tree));
        SmartExpander.installOn((JTree)((Object)tree));
        EditSourceOnDoubleClickHandler.install((JTree)((Object)tree));
        new TreeSpeedSearch((JTree)((Object)tree));
        PopupHandler.installUnknownPopupHandler((JComponent)((Object)tree), (ActionGroup)CyclicDependenciesPanel.createTreePopupActions(), (ActionManager)ActionManager.getInstance());
    }

    private void updateLeftTreeModel() {
        Set<PsiPackage> psiPackages = this.myDependencies.keySet();
        HashSet<PsiFile> psiFiles2 = new HashSet<PsiFile>();
        for (PsiPackage psiPackage : psiPackages) {
            Set<List<PsiPackage>> cycles = this.myDependencies.get(psiPackage);
            if (this.mySettings.UI_FILTER_OUT_OF_CYCLE_PACKAGES && (cycles == null || cycles.isEmpty())) continue;
            psiFiles2.addAll(this.getPackageFiles(psiPackage));
        }
        boolean showFiles = this.mySettings.UI_SHOW_FILES;
        this.mySettings.UI_FLATTEN_PACKAGES = true;
        this.mySettings.UI_SHOW_FILES = false;
        this.myLeftTreeExpansionMonitor.freeze();
        this.myLeftTree.setModel(TreeModelBuilder.createTreeModel(this.myProject, false, psiFiles2, new Marker(){

            @Override
            public boolean isMarked(VirtualFile file2) {
                return false;
            }
        }, this.mySettings));
        this.myLeftTreeExpansionMonitor.restore();
        CyclicDependenciesPanel.expandFirstLevel(this.myLeftTree);
        this.mySettings.UI_SHOW_FILES = showFiles;
        this.mySettings.UI_FLATTEN_PACKAGES = false;
    }

    private static ActionGroup createTreePopupActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(ActionManager.getInstance().getAction("EditSource"));
        group.add(ActionManager.getInstance().getAction("VersionControlsGroup"));
        return group;
    }

    private void updateRightTreeModel() {
        RootNode root = new RootNode(this.myProject);
        PackageNode packageNode = CyclicDependenciesPanel.getSelectedPackage(this.myLeftTree);
        if (packageNode != null) {
            boolean group = this.mySettings.UI_GROUP_BY_SCOPE_TYPE;
            this.mySettings.UI_GROUP_BY_SCOPE_TYPE = false;
            PsiPackage aPackage = (PsiPackage)packageNode.getPsiElement();
            Set<List<PsiPackage>> cyclesOfPackages = this.myDependencies.get(aPackage);
            for (List<PsiPackage> packCycle : cyclesOfPackages) {
                PackageDependenciesNode[] nodes = new PackageDependenciesNode[packCycle.size()];
                for (int i2 = packCycle.size() - 1; i2 >= 0; --i2) {
                    PsiPackage psiPackage = packCycle.get(i2);
                    PsiPackage nextPackage = packCycle.get(i2 == 0 ? packCycle.size() - 1 : i2 - 1);
                    PsiPackage prevPackage = packCycle.get(i2 == packCycle.size() - 1 ? 0 : i2 + 1);
                    Set<PsiFile> dependentFilesInPackage = this.myBuilder.getDependentFilesInPackage(prevPackage, psiPackage, nextPackage);
                    PackageDependenciesNode pack = (PackageDependenciesNode)TreeModelBuilder.createTreeModel(this.myProject, false, dependentFilesInPackage, new Marker(){

                        @Override
                        public boolean isMarked(VirtualFile file2) {
                            return false;
                        }
                    }, this.mySettings).getRoot();
                    nodes[i2] = CyclicDependenciesPanel.hideEmptyMiddlePackages((PackageDependenciesNode)pack.getChildAt(0), new StringBuffer());
                }
                CycleNode cycleNode = new CycleNode(this.myProject);
                for (PackageDependenciesNode node : nodes) {
                    node.setEquals(true);
                    cycleNode.insert(node, 0);
                }
                root.add(cycleNode);
            }
            this.mySettings.UI_GROUP_BY_SCOPE_TYPE = group;
        }
        this.myRightTreeExpansionMonitor.freeze();
        this.myRightTree.setModel(new TreeModel(root, -1, -1));
        this.myRightTreeExpansionMonitor.restore();
        CyclicDependenciesPanel.expandFirstLevel(this.myRightTree);
    }

    private HashSet<PsiFile> getPackageFiles(PsiPackage psiPackage) {
        PsiClass[] classes2;
        HashSet<PsiFile> psiFiles2 = new HashSet<PsiFile>();
        for (PsiClass aClass : classes2 = psiPackage.getClasses()) {
            PsiFile file2 = aClass.getContainingFile();
            if (!this.myBuilder.getScope().contains((PsiElement)file2)) continue;
            psiFiles2.add(file2);
        }
        return psiFiles2;
    }

    private static void expandFirstLevel(Tree tree) {
        PackageDependenciesNode root = (PackageDependenciesNode)tree.getModel().getRoot();
        int count = root.getChildCount();
        if (count < 10) {
            for (int i2 = 0; i2 < count; ++i2) {
                PackageDependenciesNode child = (PackageDependenciesNode)root.getChildAt(i2);
                CyclicDependenciesPanel.expandNodeIfNotTooWide(tree, child);
            }
        }
    }

    private static void expandNodeIfNotTooWide(Tree tree, PackageDependenciesNode node) {
        int count = node.getChildCount();
        if (count > 5) {
            return;
        }
        tree.expandPath(new TreePath(node.getPath()));
    }

    @Nullable
    private static PackageNode getSelectedPackage(Tree tree) {
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null || paths.length != 1) {
            return null;
        }
        PackageDependenciesNode node = (PackageDependenciesNode)paths[0].getLastPathComponent();
        if (node.isRoot()) {
            return null;
        }
        if (node instanceof PackageNode) {
            return (PackageNode)node;
        }
        if (node instanceof FileNode) {
            return (PackageNode)node.getParent();
        }
        if (node instanceof ModuleNode) {
            return (PackageNode)node.getChildAt(0);
        }
        return null;
    }

    private static Set<PsiFile> getSelectedScope(Tree tree) {
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null || paths.length != 1) {
            return EMPTY_FILE_SET;
        }
        PackageDependenciesNode node = (PackageDependenciesNode)paths[0].getLastPathComponent();
        if (node.isRoot()) {
            return EMPTY_FILE_SET;
        }
        HashSet<PsiFile> result2 = new HashSet<PsiFile>();
        node.fillFiles(result2, true);
        return result2;
    }

    public void setContent(Content content) {
        this.myContent = content;
    }

    public void dispose() {
        TreeModelBuilder.clearCaches(this.myProject);
    }

    @Nullable
    @NonNls
    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "dependency.viewer.tool.window";
        }
        return null;
    }

    private static class MyTree
    extends Tree
    implements DataProvider {
        private MyTree() {
        }

        public Object getData(String dataId) {
            PackageDependenciesNode node = this.getSelectedNode();
            if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
                return node;
            }
            return null;
        }

        @Nullable
        public PackageDependenciesNode getSelectedNode() {
            TreePath[] paths = this.getSelectionPaths();
            if (paths == null || paths.length != 1) {
                return null;
            }
            Object lastPathComponent = paths[0].getLastPathComponent();
            if (lastPathComponent instanceof PackageDependenciesNode) {
                return (PackageDependenciesNode)lastPathComponent;
            }
            return (PackageDependenciesNode)((DefaultMutableTreeNode)lastPathComponent).getUserObject();
        }
    }

    private class RerunAction
    extends AnAction {
        public RerunAction(JComponent comp) {
            super(CommonBundle.message((String)"action.rerun", (Object[])new Object[0]), AnalysisScopeBundle.message((String)"action.rerun.dependency", (Object[])new Object[0]), AllIcons.Actions.Rerun);
            this.registerCustomShortcutSet(CommonShortcuts.getRerun(), comp);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(CyclicDependenciesPanel.this.myBuilder.getScope().isValid());
        }

        public void actionPerformed(AnActionEvent e) {
            DependenciesToolWindow.getInstance(CyclicDependenciesPanel.this.myProject).closeContent(CyclicDependenciesPanel.this.myContent);
            CyclicDependenciesPanel.this.mySettings.copyToApplicationDependencySettings();
            SwingUtilities.invokeLater(() -> new CyclicDependenciesHandler(CyclicDependenciesPanel.this.myProject, CyclicDependenciesPanel.this.myBuilder.getScope()).analyze());
        }
    }

    private final class GroupByScopeTypeAction
    extends ToggleAction {
        GroupByScopeTypeAction() {
            super(AnalysisScopeBundle.message((String)"action.group.by.scope.type", (Object[])new Object[0]), AnalysisScopeBundle.message((String)"action.group.by.scope.type.description", (Object[])new Object[0]), AllIcons.Actions.GroupByTestProduction);
        }

        public boolean isSelected(AnActionEvent event) {
            return ((CyclicDependenciesPanel)CyclicDependenciesPanel.this).mySettings.UI_GROUP_BY_SCOPE_TYPE;
        }

        public void setSelected(AnActionEvent event, boolean flag) {
            DependencyUISettings.getInstance().UI_GROUP_BY_SCOPE_TYPE = flag;
            ((CyclicDependenciesPanel)CyclicDependenciesPanel.this).mySettings.UI_GROUP_BY_SCOPE_TYPE = flag;
            CyclicDependenciesPanel.this.rebuild();
        }
    }

    private final class HideOutOfCyclePackagesAction
    extends ToggleAction {
        @NonNls
        public static final String SHOW_PACKAGES_FROM_CYCLES_ONLY = "Hide packages without cyclic dependencies";

        HideOutOfCyclePackagesAction() {
            super(SHOW_PACKAGES_FROM_CYCLES_ONLY, SHOW_PACKAGES_FROM_CYCLES_ONLY, AllIcons.General.Filter);
        }

        public boolean isSelected(AnActionEvent e) {
            return ((CyclicDependenciesPanel)CyclicDependenciesPanel.this).mySettings.UI_FILTER_OUT_OF_CYCLE_PACKAGES;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            DependencyUISettings.getInstance().UI_FILTER_OUT_OF_CYCLE_PACKAGES = state;
            ((CyclicDependenciesPanel)CyclicDependenciesPanel.this).mySettings.UI_FILTER_OUT_OF_CYCLE_PACKAGES = state;
            CyclicDependenciesPanel.this.rebuild();
        }
    }

    private final class ShowFilesAction
    extends ToggleAction {
        ShowFilesAction() {
            super(AnalysisScopeBundle.message((String)"action.show.files", (Object[])new Object[0]), AnalysisScopeBundle.message((String)"action.show.files.description", (Object[])new Object[0]), AllIcons.FileTypes.Java);
        }

        public boolean isSelected(AnActionEvent event) {
            return ((CyclicDependenciesPanel)CyclicDependenciesPanel.this).mySettings.UI_SHOW_FILES;
        }

        public void setSelected(AnActionEvent event, boolean flag) {
            DependencyUISettings.getInstance().UI_SHOW_FILES = flag;
            ((CyclicDependenciesPanel)CyclicDependenciesPanel.this).mySettings.UI_SHOW_FILES = flag;
            CyclicDependenciesPanel.this.rebuild();
        }
    }

    private final class CloseAction
    extends AnAction
    implements DumbAware {
        public CloseAction() {
            super(CommonBundle.message((String)"action.close", (Object[])new Object[0]), AnalysisScopeBundle.message((String)"action.close.dependency.description", (Object[])new Object[0]), AllIcons.Actions.Cancel);
        }

        public void actionPerformed(AnActionEvent e) {
            Disposer.dispose((Disposable)CyclicDependenciesPanel.this.myUsagesPanel);
            DependenciesToolWindow.getInstance(CyclicDependenciesPanel.this.myProject).closeContent(CyclicDependenciesPanel.this.myContent);
            CyclicDependenciesPanel.this.mySettings.copyToApplicationDependencySettings();
        }
    }

    private class MyTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final boolean myLeftTree;

        public MyTreeCellRenderer(boolean isLeftTree) {
            this.myLeftTree = isLeftTree;
        }

        public void customizeCellRenderer(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            PackageDependenciesNode node;
            SimpleTextAttributes attributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            if (value2 instanceof PackageDependenciesNode) {
                PsiElement element;
                node = (PackageDependenciesNode)value2;
                if (this.myLeftTree && !((CyclicDependenciesPanel)CyclicDependenciesPanel.this).mySettings.UI_FILTER_OUT_OF_CYCLE_PACKAGES && (element = node.getPsiElement()) instanceof PsiPackage) {
                    PsiPackage aPackage = (PsiPackage)element;
                    Set packageDependencies = (Set)CyclicDependenciesPanel.this.myDependencies.get(aPackage);
                    if (packageDependencies != null && !packageDependencies.isEmpty()) {
                        attributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                    }
                }
            } else {
                node = (PackageDependenciesNode)((DefaultMutableTreeNode)value2).getUserObject();
            }
            this.append(node.toString(), attributes);
            this.setIcon(node.getIcon());
        }
    }
}

