/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.JvmSmartStepIntoHandler;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JvmSmartStepIntoActionHandler
extends DebuggerActionHandler {
    @Override
    public void perform(@NotNull Project project2, AnActionEvent event) {
        DebuggerContextImpl debuggerContext = DebuggerManagerEx.getInstanceEx(project2).getContext();
        DebuggerSession session2 = debuggerContext.getDebuggerSession();
        if (session2 != null) {
            JvmSmartStepIntoActionHandler.doStep(project2, debuggerContext.getSourcePosition(), session2);
        }
    }

    private static void doStep(@NotNull Project project2, @Nullable SourcePosition position, @NotNull DebuggerSession session2) {
        FileEditor fileEditor;
        VirtualFile file2 = position != null ? position.getFile().getVirtualFile() : null;
        FileEditor fileEditor2 = fileEditor = file2 != null ? FileEditorManager.getInstance((Project)project2).getSelectedEditor(file2) : null;
        if (fileEditor instanceof TextEditor) {
            for (JvmSmartStepIntoHandler handler2 : (JvmSmartStepIntoHandler[])Extensions.getExtensions(JvmSmartStepIntoHandler.EP_NAME)) {
                if (!handler2.isAvailable(position) || !handler2.doSmartStep(position, session2, (TextEditor)fileEditor)) continue;
                return;
            }
        }
        JvmSmartStepIntoActionHandler.doStepInto(session2, Registry.is((String)"debugger.single.smart.step.force"), null);
    }

    static void doStepInto(DebuggerSession session2, boolean force, MethodFilter filter) {
        session2.sessionResumed();
        session2.stepInto(force, filter);
    }

    @Override
    public boolean isEnabled(@NotNull Project project2, AnActionEvent event) {
        DebuggerContextImpl context = DebuggerManagerEx.getInstanceEx(project2).getContext();
        DebuggerSession debuggerSession = context.getDebuggerSession();
        boolean isPaused = debuggerSession != null && debuggerSession.isPaused();
        SuspendContextImpl suspendContext = context.getSuspendContext();
        boolean hasCurrentThread = suspendContext != null && suspendContext.getThread() != null;
        return isPaused && hasCurrentThread;
    }
}

