/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.MultiRequestPositionManager;
import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.RemappedSourcePosition;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.AlternativeJreClassFinder;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.EmptyIterable;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PositionManagerImpl
implements PositionManager,
MultiRequestPositionManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.PositionManagerImpl");
    private final DebugProcessImpl myDebugProcess;

    public PositionManagerImpl(DebugProcessImpl debugProcess) {
        this.myDebugProcess = debugProcess;
    }

    public DebugProcess getDebugProcess() {
        return this.myDebugProcess;
    }

    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType type2, @NotNull SourcePosition position) throws NoDataException {
        try {
            int line = position.getLine() + 1;
            return type2.locationsOfLine("Java", null, line);
        }
        catch (AbsentInformationException absentInformationException) {
            return Collections.emptyList();
        }
    }

    public ClassPrepareRequest createPrepareRequest(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) throws NoDataException {
        throw new IllegalStateException("This class implements MultiRequestPositionManager, corresponding createPrepareRequests version should be used");
    }

    @NotNull
    public List<ClassPrepareRequest> createPrepareRequests(final @NotNull ClassPrepareRequestor requestor, final @NotNull SourcePosition position) throws NoDataException {
        return (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<ClassPrepareRequest>>(){

            public List<ClassPrepareRequest> compute() {
                ArrayList<ClassPrepareRequest> res = new ArrayList<ClassPrepareRequest>();
                for (PsiClass psiClass : PositionManagerImpl.getLineClasses(position.getFile(), position.getLine())) {
                    ClassPrepareRequest request;
                    ClassPrepareRequestor prepareRequestor = requestor;
                    String classPattern = JVMNameUtil.getNonAnonymousClassName(psiClass);
                    if (classPattern == null) {
                        String parentQName;
                        PsiClass parent = JVMNameUtil.getTopLevelParentClass(psiClass);
                        if (parent == null || (parentQName = JVMNameUtil.getNonAnonymousClassName(parent)) == null) continue;
                        classPattern = parentQName + "*";
                        prepareRequestor = new ClassPrepareRequestor(){

                            public void processClassPrepare(DebugProcess debuggerProcess, ReferenceType referenceType) {
                                if (((DebugProcessImpl)debuggerProcess).getPositionManager().getAllClasses(position).contains(referenceType)) {
                                    requestor.processClassPrepare(debuggerProcess, referenceType);
                                }
                            }
                        };
                    }
                    if ((request = PositionManagerImpl.this.myDebugProcess.getRequestsManager().createClassPrepareRequest(prepareRequestor, classPattern)) == null) continue;
                    res.add(request);
                }
                return res;
            }
        });
    }

    @Nullable
    public SourcePosition getSourcePosition(Location location) throws NoDataException {
        Set lambdas;
        PsiFile altPsiFile;
        VirtualFile altFile;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (location == null) {
            return null;
        }
        Project project2 = this.getDebugProcess().getProject();
        PsiFile psiFile = this.getPsiFileByLocation(project2, location);
        if (psiFile == null) {
            return null;
        }
        LOG.assertTrue(this.myDebugProcess != null);
        int lineNumber = DebuggerUtilsEx.getLineNumber(location, true);
        String qName = location.declaringType().name();
        String altFileUrl = DebuggerUtilsEx.getAlternativeSourceUrl(qName, project2);
        if (altFileUrl != null && (altFile = VirtualFileManager.getInstance().findFileByUrl(altFileUrl)) != null && (altPsiFile = psiFile.getManager().findFile(altFile)) != null) {
            psiFile = altPsiFile;
        }
        SourcePosition sourcePosition = null;
        if (lineNumber > -1) {
            sourcePosition = PositionManagerImpl.calcLineMappedSourcePosition(psiFile, lineNumber);
        }
        Method method2 = DebuggerUtilsEx.getMethod(location);
        if (sourcePosition == null && (psiFile instanceof PsiCompiledElement || lineNumber < 0)) {
            if (method2 != null && method2.name() != null && method2.signature() != null) {
                PsiClass psiClass = this.findPsiClassByName(qName, null);
                PsiMethod compiledMethod = this.findMethod((PsiElement)(psiClass != null ? psiClass : psiFile), qName, method2.name(), method2.signature());
                if (compiledMethod != null) {
                    sourcePosition = SourcePosition.createFromElement((PsiElement)compiledMethod);
                    if (lineNumber >= 0) {
                        sourcePosition = new ClsSourcePosition(sourcePosition, lineNumber);
                    }
                }
            } else {
                return SourcePosition.createFromLine((PsiFile)psiFile, (int)-1);
            }
        }
        if (sourcePosition == null) {
            sourcePosition = SourcePosition.createFromLine((PsiFile)psiFile, (int)lineNumber);
        }
        int lambdaOrdinal = -1;
        if (DebuggerUtilsEx.isLambda(method2) && (lambdas = ContainerUtil.map2SetNotNull(this.locationsOfLine(location.declaringType(), sourcePosition), location1 -> {
            Method method1 = location1.method();
            if (DebuggerUtilsEx.isLambda(method1)) {
                return method1;
            }
            return null;
        })).size() > 1) {
            ArrayList<Method> lambdasList = new ArrayList<Method>(lambdas);
            lambdasList.sort(DebuggerUtilsEx.LAMBDA_ORDINAL_COMPARATOR);
            lambdaOrdinal = lambdasList.indexOf(method2);
        }
        return new JavaSourcePosition(sourcePosition, location.declaringType(), method2, lambdaOrdinal);
    }

    private static Iterable<PsiElement> getLineElements(final PsiFile file2, int lineNumber) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
        if (document == null || lineNumber < 0 || lineNumber >= document.getLineCount()) {
            return EmptyIterable.getInstance();
        }
        final TextRange lineRange = DocumentUtil.getLineTextRange(document, lineNumber);
        return new Iterable<PsiElement>(){

            @Override
            public Iterator<PsiElement> iterator() {
                return new Iterator<PsiElement>(){
                    PsiElement myElement;
                    {
                        this.myElement = DebuggerUtilsEx.findElementAt(file2, lineRange.getStartOffset());
                    }

                    @Override
                    public boolean hasNext() {
                        return this.myElement != null;
                    }

                    @Override
                    public PsiElement next() {
                        PsiElement res = this.myElement;
                        do {
                            this.myElement = PsiTreeUtil.nextLeaf((PsiElement)this.myElement);
                            if (this.myElement != null && this.myElement.getTextOffset() <= lineRange.getEndOffset()) continue;
                            this.myElement = null;
                            break;
                        } while (this.myElement.getTextLength() == 0);
                        return res;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    private static Set<PsiClass> getLineClasses(PsiFile file2, int lineNumber) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        HashSet<PsiClass> res = new HashSet<PsiClass>();
        for (PsiElement element : PositionManagerImpl.getLineElements(file2, lineNumber)) {
            PsiClass aClass = PositionManagerImpl.getEnclosingClass(element);
            if (aClass == null) continue;
            res.add(aClass);
        }
        return res;
    }

    @Nullable
    protected PsiFile getPsiFileByLocation(Project project2, Location location) {
        if (location == null) {
            return null;
        }
        ReferenceType refType = location.declaringType();
        if (refType == null) {
            return null;
        }
        String originalQName = refType.name();
        Ref altSource = new Ref();
        PsiClass psiClass = this.findPsiClassByName(originalQName, c -> altSource.set((Object)this.findAlternativeJreSourceFile((ClsClassImpl)c)));
        if (!altSource.isNull()) {
            return (PsiFile)altSource.get();
        }
        if (psiClass != null) {
            PsiElement fileElement;
            PsiElement element = psiClass.getNavigationElement();
            if (element instanceof PsiCompiledElement && !((fileElement = psiClass.getContainingFile().getNavigationElement()) instanceof PsiCompiledElement)) {
                element = fileElement;
            }
            return element.getContainingFile();
        }
        try {
            PsiFile[] files;
            for (PsiFile file2 : files = FilenameIndex.getFilesByName(project2, refType.sourceName(), GlobalSearchScope.allScope((Project)project2))) {
                if (!(file2 instanceof PsiJavaFile)) continue;
                for (PsiClass cls : ((PsiJavaFile)file2).getClasses()) {
                    if (!StringUtil.equals((CharSequence)originalQName, (CharSequence)cls.getQualifiedName())) continue;
                    return file2;
                }
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return null;
    }

    private PsiClass findPsiClassByName(String originalQName, @Nullable Consumer<ClsClassImpl> altClsProcessor) {
        PsiClass psiClass = null;
        Sdk alternativeJre = this.myDebugProcess.getSession().getAlternativeJre();
        if (alternativeJre != null && (psiClass = PositionManagerImpl.findClass(this.myDebugProcess.getProject(), originalQName, AlternativeJreClassFinder.getSearchScope(alternativeJre))) instanceof ClsClassImpl && altClsProcessor != null) {
            altClsProcessor.accept((ClsClassImpl)psiClass);
        }
        if (psiClass == null) {
            psiClass = PositionManagerImpl.findClass(this.myDebugProcess.getProject(), originalQName, this.myDebugProcess.getSearchScope());
        }
        return psiClass;
    }

    @Nullable
    public static PsiClass findClass(Project project2, String originalQName, GlobalSearchScope searchScope) {
        int dollar;
        PsiClass psiClass = DebuggerUtils.findClass((String)originalQName, (Project)project2, (GlobalSearchScope)searchScope);
        if (psiClass == null && (dollar = originalQName.indexOf(36)) > 0) {
            psiClass = DebuggerUtils.findClass((String)originalQName.substring(0, dollar), (Project)project2, (GlobalSearchScope)searchScope);
        }
        return psiClass;
    }

    @Nullable
    private PsiFile findAlternativeJreSourceFile(ClsClassImpl psiClass) {
        String sourceFileName = psiClass.getSourceFileName();
        String packageName = ((PsiClassOwner)psiClass.getContainingFile()).getPackageName();
        String relativePath = packageName.isEmpty() ? sourceFileName : packageName.replace('.', '/') + '/' + sourceFileName;
        Sdk alternativeJre = this.myDebugProcess.getSession().getAlternativeJre();
        if (alternativeJre != null) {
            for (VirtualFile file2 : AlternativeJreClassFinder.getSourceRoots(alternativeJre)) {
                PsiFile psiSource;
                VirtualFile source = file2.findFileByRelativePath(relativePath);
                if (source == null || !source.isValid() || !((psiSource = psiClass.getManager().findFile(source)) instanceof PsiClassOwner)) continue;
                return psiSource;
            }
        }
        return null;
    }

    @NotNull
    public List<ReferenceType> getAllClasses(final @NotNull SourcePosition position) throws NoDataException {
        return (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<ReferenceType>>(){

            public List<ReferenceType> compute() {
                ArrayList<ReferenceType> res = new ArrayList<ReferenceType>();
                for (PsiClass aClass : PositionManagerImpl.getLineClasses(position.getFile(), position.getLine())) {
                    res.addAll(PositionManagerImpl.this.getClassReferences(aClass, position));
                }
                return res;
            }
        });
    }

    private List<ReferenceType> getClassReferences(@NotNull PsiClass psiClass, SourcePosition position) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        boolean isLocalOrAnonymous = false;
        int requiredDepth = 0;
        String className = JVMNameUtil.getNonAnonymousClassName(psiClass);
        if (className == null) {
            isLocalOrAnonymous = true;
            Pair<PsiClass, Integer> enclosing = PositionManagerImpl.getTopOrStaticEnclosingClass(psiClass);
            PsiClass topLevelClass = (PsiClass)enclosing.first;
            if (topLevelClass != null) {
                String parentClassName = JVMNameUtil.getNonAnonymousClassName(topLevelClass);
                if (parentClassName != null) {
                    requiredDepth = (Integer)enclosing.second;
                    className = parentClassName;
                }
            } else {
                StringBuilder sb = new StringBuilder();
                PsiTreeUtil.treeWalkUp((PsiElement)psiClass, null, (element, element2) -> {
                    sb.append('\n').append(element);
                    return true;
                });
                LOG.info("Local or anonymous class " + psiClass + " has no non-local parent, parents:" + sb);
            }
        }
        if (className == null) {
            return Collections.emptyList();
        }
        List<ReferenceType> outers = this.myDebugProcess.getVirtualMachineProxy().classesByName(className);
        ArrayList<ReferenceType> result2 = new ArrayList<ReferenceType>(outers.size());
        if (!isLocalOrAnonymous) {
            for (ReferenceType type2 : outers) {
                result2.add(this.mapClass(type2));
            }
            return result2;
        }
        for (ReferenceType outer : outers) {
            ReferenceType nested = this.findNested(outer, 0, psiClass, requiredDepth, position);
            if (nested == null) continue;
            result2.add(nested);
        }
        return result2;
    }

    protected ReferenceType mapClass(ReferenceType type2) {
        return type2;
    }

    private static Pair<PsiClass, Integer> getTopOrStaticEnclosingClass(PsiClass aClass) {
        int depth = 0;
        PsiClass enclosing = PositionManagerImpl.getEnclosingClass((PsiElement)aClass);
        while (enclosing != null) {
            PsiClass next;
            ++depth;
            if (enclosing.hasModifierProperty("static") || (next = PositionManagerImpl.getEnclosingClass((PsiElement)enclosing)) == null) break;
            enclosing = next;
        }
        return Pair.create((Object)enclosing, (Object)depth);
    }

    @Nullable
    private static PsiClass getEnclosingClass(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiElement previous = null;
        for (element = element.getParent(); element != null; element = element.getParent()) {
            if (PsiClass.class.isInstance(element) && !(previous instanceof PsiExpressionList)) {
                return (PsiClass)element;
            }
            if (element instanceof PsiFile) {
                return null;
            }
            previous = element;
        }
        return null;
    }

    @Nullable
    private ReferenceType findNested(ReferenceType fromClass, int currentDepth, PsiClass classToFind, int requiredDepth, SourcePosition position) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        VirtualMachineProxyImpl vmProxy = this.myDebugProcess.getVirtualMachineProxy();
        if (fromClass.isPrepared()) {
            if (currentDepth < requiredDepth) {
                List<ReferenceType> nestedTypes = vmProxy.nestedTypes(fromClass);
                for (ReferenceType nested : nestedTypes) {
                    ReferenceType found = this.findNested(nested, currentDepth + 1, classToFind, requiredDepth, position);
                    if (found == null) continue;
                    return found;
                }
                return null;
            }
            int rangeBegin = Integer.MAX_VALUE;
            int rangeEnd = Integer.MIN_VALUE;
            ReferenceType mapped = this.mapClass(fromClass);
            for (Location location : DebuggerUtilsEx.allLineLocations(mapped)) {
                Method method2;
                int lnumber = DebuggerUtilsEx.getLineNumber(location, false);
                if (lnumber <= 1 || (method2 = DebuggerUtilsEx.getMethod(location)) == null || DebuggerUtils.isSynthetic((TypeComponent)method2) || method2.isBridge()) continue;
                int locationLine = lnumber - 1;
                PsiFile psiFile = position.getFile().getOriginalFile();
                if (psiFile instanceof PsiCompiledFile && (locationLine = DebuggerUtilsEx.bytecodeToSourceLine(psiFile, locationLine)) < 0) continue;
                rangeBegin = Math.min(rangeBegin, locationLine);
                rangeEnd = Math.max(rangeEnd, locationLine);
            }
            int positionLine = position.getLine();
            if (positionLine >= rangeBegin && positionLine <= rangeEnd) {
                if (!classToFind.isValid()) {
                    return null;
                }
                Set<PsiClass> lineClasses = PositionManagerImpl.getLineClasses(position.getFile(), rangeEnd);
                if (lineClasses.size() > 1) {
                    for (PsiClass aClass : lineClasses) {
                        if (!classToFind.equals(aClass)) continue;
                        return mapped;
                    }
                } else if (!lineClasses.isEmpty()) {
                    return classToFind.equals(lineClasses.iterator().next()) ? mapped : null;
                }
                return null;
            }
        }
        return null;
    }

    @Nullable
    public PsiMethod findMethod(PsiElement container, String className, String methodName, String methodSignature) {
        MethodFinder finder = new MethodFinder(className, methodName, methodSignature);
        container.accept((PsiElementVisitor)finder);
        return finder.getCompiledMethod();
    }

    @Nullable
    private static SourcePosition calcLineMappedSourcePosition(PsiFile psiFile, int originalLine) {
        int line = DebuggerUtilsEx.bytecodeToSourceLine(psiFile, originalLine);
        if (line > -1) {
            return SourcePosition.createFromLine((PsiFile)psiFile, (int)line);
        }
        return null;
    }

    public static class ClsSourcePosition
    extends RemappedSourcePosition {
        private final int myOriginalLine;

        public ClsSourcePosition(SourcePosition delegate, int originalLine) {
            super(delegate);
            this.myOriginalLine = originalLine;
        }

        @Override
        public SourcePosition mapDelegate(SourcePosition original) {
            PsiFile file2 = this.getFile();
            if (this.myOriginalLine < 0 || !file2.isValid()) {
                return original;
            }
            PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
            SourcePosition position = PositionManagerImpl.calcLineMappedSourcePosition(file2, this.myOriginalLine);
            return position != null ? position : original;
        }
    }

    private class MethodFinder
    extends JavaRecursiveElementVisitor {
        private final String myClassName;
        private PsiClass myCompiledClass;
        private final String myMethodName;
        private final String myMethodSignature;
        private PsiMethod myCompiledMethod;

        public MethodFinder(String className, String methodName, String methodSignature) {
            this.myClassName = className;
            this.myMethodName = methodName;
            this.myMethodSignature = methodSignature;
        }

        public void visitClass(PsiClass aClass) {
            if (this.myCompiledMethod == null) {
                List allClasses = PositionManagerImpl.this.getClassReferences(aClass, SourcePosition.createFromElement((PsiElement)aClass));
                for (ReferenceType referenceType : allClasses) {
                    if (!referenceType.name().equals(this.myClassName)) continue;
                    this.myCompiledClass = aClass;
                }
                aClass.acceptChildren((PsiElementVisitor)this);
            }
        }

        public void visitMethod(PsiMethod method2) {
            if (this.myCompiledMethod == null) {
                try {
                    String methodName = JVMNameUtil.getJVMMethodName(method2);
                    PsiClass containingClass = method2.getContainingClass();
                    if (containingClass != null && containingClass.equals(this.myCompiledClass) && methodName.equals(this.myMethodName) && JVMNameUtil.getJVMSignature(method2).getName(PositionManagerImpl.this.myDebugProcess).equals(this.myMethodSignature)) {
                        this.myCompiledMethod = method2;
                    }
                }
                catch (EvaluateException e) {
                    LOG.debug((Throwable)e);
                }
            }
        }

        public void visitElement(PsiElement element) {
            if (this.myCompiledMethod == null) {
                super.visitElement(element);
            }
        }

        @Nullable
        public PsiMethod getCompiledMethod() {
            return this.myCompiledMethod;
        }
    }

    private static class JavaSourcePosition
    extends RemappedSourcePosition {
        private final String myExpectedClassName;
        private final String myExpectedMethodName;
        private final int myLambdaOrdinal;

        public JavaSourcePosition(SourcePosition delegate, ReferenceType declaringType, Method method2, int lambdaOrdinal) {
            super(delegate);
            this.myExpectedClassName = declaringType != null ? declaringType.name() : null;
            this.myExpectedMethodName = method2 != null ? method2.name() : null;
            this.myLambdaOrdinal = lambdaOrdinal;
        }

        private PsiElement remapElement(PsiElement element) {
            String name = JVMNameUtil.getClassVMName(PositionManagerImpl.getEnclosingClass(element));
            if (name != null && !name.equals(this.myExpectedClassName)) {
                return null;
            }
            PsiElement method2 = DebuggerUtilsEx.getContainingMethod(element);
            if (!StringUtil.isEmpty((String)this.myExpectedMethodName)) {
                if (method2 == null) {
                    return null;
                }
                if ((method2 instanceof PsiMethod && this.myExpectedMethodName.equals(((PsiMethod)method2).getName()) || method2 instanceof PsiLambdaExpression && DebuggerUtilsEx.isLambdaName(this.myExpectedMethodName)) && JavaSourcePosition.insideBody(element, DebuggerUtilsEx.getBody(method2))) {
                    return element;
                }
            }
            return null;
        }

        private static boolean insideBody(@NotNull PsiElement element, @Nullable PsiElement body2) {
            if (!PsiTreeUtil.isAncestor((PsiElement)body2, (PsiElement)element, (boolean)false)) {
                return false;
            }
            if (body2 instanceof PsiCodeBlock) {
                return !element.equals(((PsiCodeBlock)body2).getRBrace()) && !element.equals(((PsiCodeBlock)body2).getLBrace());
            }
            return true;
        }

        @Override
        public SourcePosition mapDelegate(final SourcePosition original) {
            return (SourcePosition)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SourcePosition>(){

                public SourcePosition compute() {
                    PsiFile file2 = original.getFile();
                    int line = original.getLine();
                    if (DebuggerUtilsEx.isLambdaName(myExpectedMethodName) && myLambdaOrdinal > -1) {
                        PsiElement firstElem;
                        List<PsiLambdaExpression> lambdas = DebuggerUtilsEx.collectLambdas(original, true);
                        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
                        if (document == null || line >= document.getLineCount()) {
                            return original;
                        }
                        if (myLambdaOrdinal < lambdas.size() && (firstElem = DebuggerUtilsEx.getFirstElementOnTheLine(lambdas.get(myLambdaOrdinal), document, line)) != null) {
                            return SourcePosition.createFromElement((PsiElement)firstElem);
                        }
                    } else {
                        for (PsiElement elem : PositionManagerImpl.getLineElements(file2, line)) {
                            PsiElement remappedElement = this.remapElement(elem);
                            if (remappedElement == null) continue;
                            if (remappedElement.getTextOffset() <= original.getOffset()) break;
                            return SourcePosition.createFromElement((PsiElement)remappedElement);
                        }
                    }
                    return original;
                }
            });
        }
    }
}

