/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.ExtraSteppingFilter;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.util.Range;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.VMDisconnectedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequestHint {
    public static final int STOP = 0;
    public static final int RESUME = -100;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.RequestHint");
    private final int mySize;
    private final int myDepth;
    private final SourcePosition myPosition;
    private final int myFrameCount;
    private boolean mySteppedOut = false;
    @Nullable
    private final MethodFilter myMethodFilter;
    private boolean myTargetMethodMatched = false;
    private boolean myIgnoreFilters = false;
    private boolean myResetIgnoreFilters = false;
    private boolean myRestoreBreakpoints = false;

    public RequestHint(ThreadReferenceProxyImpl stepThread, SuspendContextImpl suspendContext, @NotNull MethodFilter methodFilter) {
        this(stepThread, suspendContext, -2, 1, methodFilter);
    }

    public RequestHint(ThreadReferenceProxyImpl stepThread, SuspendContextImpl suspendContext, int depth) {
        this(stepThread, suspendContext, -2, depth, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestHint(final ThreadReferenceProxyImpl stepThread, final SuspendContextImpl suspendContext, int stepSize, int depth, @Nullable MethodFilter methodFilter) {
        this.mySize = stepSize;
        this.myDepth = depth;
        this.myMethodFilter = methodFilter;
        int frameCount = 0;
        SourcePosition position = null;
        try {
            frameCount = stepThread.frameCount();
            position = ContextUtil.getSourcePosition(new StackFrameContext(){

                public StackFrameProxy getFrameProxy() {
                    try {
                        return stepThread.frame(0);
                    }
                    catch (EvaluateException e) {
                        LOG.debug((Throwable)e);
                        return null;
                    }
                }

                @NotNull
                public DebugProcess getDebugProcess() {
                    return suspendContext.getDebugProcess();
                }
            });
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
        finally {
            this.myFrameCount = frameCount;
            this.myPosition = position;
        }
    }

    public void setIgnoreFilters(boolean ignoreFilters) {
        this.myIgnoreFilters = ignoreFilters;
    }

    public void setResetIgnoreFilters(boolean resetIgnoreFilters) {
        this.myResetIgnoreFilters = resetIgnoreFilters;
    }

    public boolean isResetIgnoreFilters() {
        return this.myResetIgnoreFilters;
    }

    public void setRestoreBreakpoints(boolean restoreBreakpoints) {
        this.myRestoreBreakpoints = restoreBreakpoints;
    }

    public boolean isRestoreBreakpoints() {
        return this.myRestoreBreakpoints;
    }

    public boolean isIgnoreFilters() {
        return this.myIgnoreFilters;
    }

    public int getSize() {
        return this.mySize;
    }

    public int getDepth() {
        return this.myDepth;
    }

    @Nullable
    public MethodFilter getMethodFilter() {
        return this.myMethodFilter;
    }

    public boolean wasStepTargetMethodMatched() {
        return this.myMethodFilter instanceof BreakpointStepMethodFilter || this.myTargetMethodMatched;
    }

    protected boolean isTheSameFrame(SuspendContextImpl context) {
        if (this.mySteppedOut) {
            return false;
        }
        ThreadReferenceProxyImpl contextThread = context.getThread();
        if (contextThread != null) {
            try {
                int currentDepth = contextThread.frameCount();
                if (currentDepth < this.myFrameCount) {
                    this.mySteppedOut = true;
                }
                return currentDepth == this.myFrameCount;
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isOnTheSameLine(SourcePosition locationPosition) {
        if (this.myMethodFilter == null) {
            return this.myPosition.getLine() == locationPosition.getLine();
        }
        Range<Integer> exprLines = this.myMethodFilter.getCallingExpressionLines();
        return exprLines != null && exprLines.isWithin((Comparable)Integer.valueOf(locationPosition.getLine()));
    }

    protected boolean isSteppedOut() {
        return this.mySteppedOut;
    }

    public int getNextStepDepth(final SuspendContextImpl context) {
        try {
            Location location;
            Integer resultDepth;
            SourcePosition locationPosition;
            StackFrameProxyImpl frameProxy = context.getFrameProxy();
            if (this.myMethodFilter != null && frameProxy != null && !(this.myMethodFilter instanceof BreakpointStepMethodFilter) && this.myMethodFilter.locationMatches(context.getDebugProcess(), frameProxy.location()) && !this.isTheSameFrame(context)) {
                this.myTargetMethodMatched = true;
                return this.myMethodFilter.onReached(context, this);
            }
            if ((this.myDepth == 2 || this.myDepth == 1) && this.myPosition != null && (locationPosition = ContextUtil.getSourcePosition((StackFrameContext)context)) != null && (resultDepth = (Integer)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Integer>(){

                public Integer compute() {
                    if (RequestHint.this.myPosition.getFile().equals(locationPosition.getFile()) && RequestHint.this.isTheSameFrame(context) && !RequestHint.this.mySteppedOut) {
                        return RequestHint.this.isOnTheSameLine(locationPosition) ? RequestHint.this.myDepth : 0;
                    }
                    return null;
                }
            })) != null) {
                return resultDepth;
            }
            DebuggerSettings settings = DebuggerSettings.getInstance();
            if ((this.myMethodFilter != null || settings.SKIP_SYNTHETIC_METHODS && !this.myIgnoreFilters) && frameProxy != null && (location = frameProxy.location()) != null && DebuggerUtils.isSynthetic((TypeComponent)location.method())) {
                return this.myDepth;
            }
            if (!this.myIgnoreFilters) {
                boolean isGetter;
                if (settings.SKIP_GETTERS && (isGetter = ((Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                    public Boolean compute() {
                        PsiElement contextElement = ContextUtil.getContextElement((StackFrameContext)context);
                        return contextElement != null && DebuggerUtils.isInsideSimpleGetter((PsiElement)contextElement);
                    }
                })).booleanValue())) {
                    return 3;
                }
                if (frameProxy != null) {
                    Method method2;
                    if (settings.SKIP_CONSTRUCTORS && (location = frameProxy.location()) != null && (method2 = location.method()) != null && method2.isConstructor()) {
                        return 3;
                    }
                    if (settings.SKIP_CLASSLOADERS && (location = frameProxy.location()) != null && DebuggerUtilsEx.isAssignableFrom("java.lang.ClassLoader", location.declaringType())) {
                        return 3;
                    }
                }
                for (ExtraSteppingFilter filter : (ExtraSteppingFilter[])ExtraSteppingFilter.EP_NAME.getExtensions()) {
                    try {
                        if (filter.isApplicable(context)) {
                            return filter.getStepRequestDepth(context);
                        }
                    }
                    catch (AssertionError | Exception e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
            if (this.myMethodFilter != null && !this.mySteppedOut) {
                return 3;
            }
        }
        catch (VMDisconnectedException frameProxy) {
        }
        catch (EvaluateException e) {
            LOG.error((Throwable)e);
        }
        return 0;
    }
}

