/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation;

import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextWithImportsImpl
implements TextWithImports {
    private final CodeFragmentKind myKind;
    private String myText;
    private final FileType myFileType;
    private final String myImports;
    private static final char SEPARATOR = '\r';

    public TextWithImportsImpl(@NotNull PsiElement expression2) {
        this.myKind = CodeFragmentKind.EXPRESSION;
        String text = expression2.getText();
        PsiFile containingFile = expression2.getContainingFile();
        if (containingFile instanceof PsiExpressionCodeFragment) {
            this.myText = text;
            this.myImports = ((JavaCodeFragment)containingFile).importsToString();
            this.myFileType = StdFileTypes.JAVA;
        } else {
            Trinity<String, String, FileType> trinity = TextWithImportsImpl.parseExternalForm(text);
            this.myText = (String)trinity.first;
            this.myImports = (String)trinity.second;
            this.myFileType = (FileType)trinity.third;
        }
    }

    public TextWithImportsImpl(CodeFragmentKind kind2, @NotNull String text, @NotNull String imports2, @Nullable FileType fileType) {
        this.myKind = kind2;
        this.myText = text;
        this.myImports = imports2;
        this.myFileType = fileType;
    }

    public TextWithImportsImpl(CodeFragmentKind kind2, @NotNull String text) {
        this.myKind = kind2;
        Trinity<String, String, FileType> trinity = TextWithImportsImpl.parseExternalForm(text);
        this.myText = (String)trinity.first;
        this.myImports = (String)trinity.second;
        this.myFileType = (FileType)trinity.third;
    }

    private static Trinity<String, String, FileType> parseExternalForm(String s) {
        String[] split = s.split(String.valueOf('\r'));
        return Trinity.create((Object)split[0], (Object)(split.length > 1 ? split[1] : ""), split.length > 2 ? FileTypeManager.getInstance().getStdFileType(split[2]) : null);
    }

    public CodeFragmentKind getKind() {
        return this.myKind;
    }

    public String getText() {
        return this.myText;
    }

    @NotNull
    public String getImports() {
        return this.myImports;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TextWithImportsImpl)) {
            return false;
        }
        TextWithImportsImpl item = (TextWithImportsImpl)object;
        return Comparing.equal((String)item.myText, (String)this.myText) && Comparing.equal((String)item.myImports, (String)this.myImports);
    }

    public String toString() {
        return this.getText();
    }

    public String toExternalForm() {
        String result2 = this.myText;
        if (StringUtil.isNotEmpty((String)this.myImports) || this.myFileType != null) {
            result2 = result2 + '\r' + this.myImports;
        }
        if (this.myFileType != null) {
            result2 = result2 + '\r' + this.myFileType.getName();
        }
        return result2;
    }

    public int hashCode() {
        return this.myText.hashCode();
    }

    public boolean isEmpty() {
        return StringUtil.isEmptyOrSpaces((String)this.getText());
    }

    public void setText(String newText) {
        this.myText = newText;
    }

    public FileType getFileType() {
        return this.myFileType;
    }

    @Nullable
    public static XExpression toXExpression(@Nullable TextWithImports text) {
        if (text != null && !text.getText().isEmpty()) {
            return new XExpressionImpl(text.getText(), LanguageUtil.getFileTypeLanguage((FileType)text.getFileType()), StringUtil.nullize((String)text.getImports()), TextWithImportsImpl.getMode(text.getKind()));
        }
        return null;
    }

    private static EvaluationMode getMode(CodeFragmentKind kind2) {
        switch (kind2) {
            case EXPRESSION: {
                return EvaluationMode.EXPRESSION;
            }
            case CODE_BLOCK: {
                return EvaluationMode.CODE_FRAGMENT;
            }
        }
        throw new IllegalStateException("Unknown kind " + kind2);
    }

    private static CodeFragmentKind getKind(EvaluationMode mode) {
        switch (mode) {
            case EXPRESSION: {
                return CodeFragmentKind.EXPRESSION;
            }
            case CODE_FRAGMENT: {
                return CodeFragmentKind.CODE_BLOCK;
            }
        }
        throw new IllegalStateException("Unknown mode " + mode);
    }

    public static TextWithImports fromXExpression(@Nullable XExpression expression2) {
        if (expression2 == null) {
            return null;
        }
        if (expression2.getCustomInfo() == null && expression2.getLanguage() == null) {
            return new TextWithImportsImpl(TextWithImportsImpl.getKind(expression2.getMode()), expression2.getExpression());
        }
        return new TextWithImportsImpl(TextWithImportsImpl.getKind(expression2.getMode()), expression2.getExpression(), StringUtil.notNullize((String)expression2.getCustomInfo()), LanguageUtil.getLanguageFileType((Language)expression2.getLanguage()));
    }
}

