/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluateRuntimeException;
import com.intellij.debugger.engine.evaluation.expression.BlockStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.HashMap;
import com.sun.jdi.Value;
import java.util.Map;

public class CodeFragmentEvaluator
extends BlockStatementEvaluator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.evaluation.expression.CodeFragmentEvaluator");
    private final CodeFragmentEvaluator myParentFragmentEvaluator;
    private final Map<String, Object> mySyntheticLocals = new HashMap();

    public CodeFragmentEvaluator(CodeFragmentEvaluator parentFragmentEvaluator) {
        super(null);
        this.myParentFragmentEvaluator = parentFragmentEvaluator;
    }

    public void setStatements(Evaluator[] evaluators) {
        this.myStatements = evaluators;
    }

    public Value getValue(String localName, VirtualMachineProxyImpl vm) throws EvaluateException {
        if (!this.mySyntheticLocals.containsKey(localName)) {
            if (this.myParentFragmentEvaluator != null) {
                return this.myParentFragmentEvaluator.getValue(localName, vm);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.variable.not.declared", (Object[])new Object[]{localName}));
        }
        Object value2 = this.mySyntheticLocals.get(localName);
        if (value2 instanceof Value) {
            return (Value)value2;
        }
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Boolean) {
            return vm.mirrorOf((Boolean)value2);
        }
        if (value2 instanceof Byte) {
            return vm.mirrorOf((Byte)value2);
        }
        if (value2 instanceof Character) {
            return vm.mirrorOf(((Character)value2).charValue());
        }
        if (value2 instanceof Short) {
            return vm.mirrorOf((Short)value2);
        }
        if (value2 instanceof Integer) {
            return vm.mirrorOf((Integer)value2);
        }
        if (value2 instanceof Long) {
            return vm.mirrorOf((Long)value2);
        }
        if (value2 instanceof Float) {
            return vm.mirrorOf(((Float)value2).floatValue());
        }
        if (value2 instanceof Double) {
            return vm.mirrorOf((Double)value2);
        }
        if (value2 instanceof String) {
            return vm.mirrorOf((String)value2);
        }
        LOG.error("unknown default initializer type " + value2.getClass().getName());
        return null;
    }

    private boolean hasValue(String localName) {
        if (!this.mySyntheticLocals.containsKey(localName)) {
            if (this.myParentFragmentEvaluator != null) {
                return this.myParentFragmentEvaluator.hasValue(localName);
            }
            return false;
        }
        return true;
    }

    public void setInitialValue(String localName, Object value2) {
        LOG.assertTrue(!(value2 instanceof Value), (Object)"use setValue for jdi values");
        if (this.hasValue(localName)) {
            throw new EvaluateRuntimeException(EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.variable.already.declared", (Object[])new Object[]{localName})));
        }
        this.mySyntheticLocals.put(localName, value2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(String localName, Value value2) throws EvaluateException {
        if (!this.mySyntheticLocals.containsKey(localName)) {
            if (this.myParentFragmentEvaluator == null) throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.variable.not.declared", (Object[])new Object[]{localName}));
            this.myParentFragmentEvaluator.setValue(localName, value2);
            return;
        } else {
            this.mySyntheticLocals.put(localName, value2);
        }
    }
}

