/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.SimpleStackFrameContext;
import com.intellij.debugger.jdi.DecompiledLocalVariable;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.LocalVariablesUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.impl.watch.LocalVariableDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiVariable;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

class LocalVariableEvaluator
implements Evaluator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.evaluation.expression.LocalVariableEvaluator");
    private final String myLocalVariableName;
    private EvaluationContextImpl myContext;
    private LocalVariableProxyImpl myEvaluatedVariable;
    private DecompiledLocalVariable myEvaluatedDecompiledVariable;
    private final boolean myCanScanFrames;

    public LocalVariableEvaluator(String localVariableName, boolean canScanFrames) {
        this.myLocalVariableName = localVariableName;
        this.myCanScanFrames = canScanFrames;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        StackFrameProxyImpl frameProxy = context.getFrameProxy();
        if (frameProxy == null) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.no.stackframe", (Object[])new Object[0]));
        }
        try {
            ThreadReferenceProxyImpl threadProxy = null;
            int lastFrameIndex = -1;
            Object variable = null;
            DebugProcessImpl process2 = context.getDebugProcess();
            boolean topFrame = true;
            while (true) {
                int currentFrameIndex;
                try {
                    LocalVariableProxyImpl local = frameProxy.visibleVariableByName(this.myLocalVariableName);
                    if (local != null && (topFrame || variable.equals(LocalVariableEvaluator.resolveVariable(frameProxy, this.myLocalVariableName, context.getProject(), process2)))) {
                        this.myEvaluatedVariable = local;
                        this.myContext = context;
                        return frameProxy.getValue(local);
                    }
                }
                catch (EvaluateException e) {
                    if (!(e.getCause() instanceof AbsentInformationException)) {
                        throw e;
                    }
                    try {
                        Map<DecompiledLocalVariable, Value> vars = LocalVariablesUtil.fetchValues(frameProxy, process2, true);
                        for (Map.Entry<DecompiledLocalVariable, Value> entry : vars.entrySet()) {
                            DecompiledLocalVariable var = entry.getKey();
                            if (!var.getMatchedNames().contains(this.myLocalVariableName) && !var.getDefaultName().equals(this.myLocalVariableName)) continue;
                            this.myEvaluatedDecompiledVariable = var;
                            this.myContext = context;
                            return entry.getValue();
                        }
                    }
                    catch (Exception e1) {
                        LOG.info((Throwable)e1);
                    }
                }
                if (!this.myCanScanFrames || topFrame && (variable = LocalVariableEvaluator.resolveVariable(frameProxy, this.myLocalVariableName, context.getProject(), process2)) == null) break;
                if (threadProxy == null) {
                    threadProxy = frameProxy.threadProxy();
                    lastFrameIndex = threadProxy.frameCount() - 1;
                }
                if ((currentFrameIndex = frameProxy.getFrameIndex()) >= lastFrameIndex || (frameProxy = threadProxy.frame(currentFrameIndex + 1)) == null) break;
                topFrame = false;
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.local.variable.missing", (Object[])new Object[]{this.myLocalVariableName}));
        }
        catch (EvaluateException e) {
            this.myEvaluatedVariable = null;
            this.myContext = null;
            throw e;
        }
    }

    @Override
    public Modifier getModifier() {
        Modifier modifier = null;
        if ((this.myEvaluatedVariable != null || this.myEvaluatedDecompiledVariable != null) && this.myContext != null) {
            modifier = new Modifier(){

                public boolean canInspect() {
                    return true;
                }

                public boolean canSetValue() {
                    return true;
                }

                public void setValue(Value value2) throws ClassNotLoadedException, InvalidTypeException {
                    StackFrameProxyImpl frameProxy = LocalVariableEvaluator.this.myContext.getFrameProxy();
                    try {
                        assert (frameProxy != null);
                        if (LocalVariableEvaluator.this.myEvaluatedVariable != null) {
                            frameProxy.setValue(LocalVariableEvaluator.this.myEvaluatedVariable, value2);
                        } else {
                            LocalVariablesUtil.setValue(frameProxy.getStackFrame(), LocalVariableEvaluator.this.myEvaluatedDecompiledVariable.getSlot(), value2);
                        }
                    }
                    catch (EvaluateException e) {
                        LOG.error((Throwable)e);
                    }
                }

                public Type getExpectedType() throws ClassNotLoadedException {
                    try {
                        return LocalVariableEvaluator.this.myEvaluatedVariable.getType();
                    }
                    catch (EvaluateException e) {
                        LOG.error((Throwable)e);
                        return null;
                    }
                }

                public NodeDescriptorImpl getInspectItem(Project project2) {
                    return new LocalVariableDescriptorImpl(project2, LocalVariableEvaluator.this.myEvaluatedVariable);
                }
            };
        }
        return modifier;
    }

    @Nullable
    private static PsiVariable resolveVariable(StackFrameProxy frame, String name, Project project2, DebugProcess process2) {
        PsiElement place = ContextUtil.getContextElement(new SimpleStackFrameContext(frame, process2));
        if (place == null) {
            return null;
        }
        return (PsiVariable)ReadAction.compute(() -> JavaPsiFacade.getInstance((Project)project2).getResolveHelper().resolveReferencedVariable(name, place));
    }

    public String toString() {
        return this.myLocalVariableName;
    }
}

