/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.CodeFragmentEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.sun.jdi.Type;
import com.sun.jdi.Value;

public class SyntheticVariableEvaluator
implements Evaluator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.evaluation.expression.SyntheticVariableEvaluator");
    private final CodeFragmentEvaluator myCodeFragmentEvaluator;
    private final String myLocalName;

    public SyntheticVariableEvaluator(CodeFragmentEvaluator codeFragmentEvaluator, String localName) {
        this.myCodeFragmentEvaluator = codeFragmentEvaluator;
        this.myLocalName = localName;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        return this.myCodeFragmentEvaluator.getValue(this.myLocalName, context.getDebugProcess().getVirtualMachineProxy());
    }

    @Override
    public Modifier getModifier() {
        return new Modifier(){

            public boolean canInspect() {
                return false;
            }

            public boolean canSetValue() {
                return false;
            }

            public void setValue(Value value2) throws EvaluateException {
                SyntheticVariableEvaluator.this.myCodeFragmentEvaluator.setValue(SyntheticVariableEvaluator.this.myLocalName, value2);
            }

            public Type getExpectedType() {
                LOG.assertTrue(false);
                return null;
            }

            public NodeDescriptorImpl getInspectItem(Project project2) {
                return null;
            }
        };
    }
}

