/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;

public abstract class DebuggerStateManager {
    private final EventDispatcher<DebuggerContextListener> myEventDispatcher;

    public DebuggerStateManager() {
        EventDispatcher dispatcher;
        try {
            dispatcher = EventDispatcher.create(DebuggerContextListener.class);
        }
        catch (Throwable t) {
            dispatcher = null;
        }
        this.myEventDispatcher = dispatcher;
    }

    @NotNull
    public abstract DebuggerContextImpl getContext();

    public abstract void setState(@NotNull DebuggerContextImpl var1, DebuggerSession.State var2, DebuggerSession.Event var3, String var4);

    public void addListener(DebuggerContextListener listener2) {
        if (this.myEventDispatcher == null) {
            return;
        }
        this.myEventDispatcher.addListener((EventListener)listener2);
    }

    public void removeListener(DebuggerContextListener listener2) {
        if (this.myEventDispatcher == null) {
            return;
        }
        this.myEventDispatcher.removeListener((EventListener)listener2);
    }

    protected void fireStateChanged(@NotNull DebuggerContextImpl newContext, DebuggerSession.Event event) {
        if (this.myEventDispatcher == null) {
            return;
        }
        ((DebuggerContextListener)this.myEventDispatcher.getMulticaster()).changeEvent(newContext, event);
    }
}

