/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl.descriptors.data;

import com.intellij.debugger.impl.descriptors.data.DescriptorData;
import com.intellij.debugger.impl.descriptors.data.DisplayKey;
import com.intellij.debugger.ui.impl.watch.ArrayElementDescriptorImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.sun.jdi.ArrayReference;
import org.jetbrains.annotations.NotNull;

public final class ArrayItemData
extends DescriptorData<ArrayElementDescriptorImpl> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.impl.descriptors.data.ArrayItemData");
    private final ArrayReference myArray;
    private final int myIndex;

    public ArrayItemData(@NotNull ArrayReference arrRef, int idx) {
        LOG.assertTrue(0 <= idx);
        if (LOG.isDebugEnabled()) {
            LOG.assertTrue(idx <= arrRef.length());
        }
        this.myArray = arrRef;
        this.myIndex = idx;
    }

    @Override
    protected ArrayElementDescriptorImpl createDescriptorImpl(@NotNull Project project2) {
        return new ArrayElementDescriptorImpl(project2, this.myArray, this.myIndex);
    }

    @Override
    public DisplayKey<ArrayElementDescriptorImpl> getDisplayKey() {
        return new ArrayItemDisplayKeyImpl(this.myIndex);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ArrayItemData && this.myArray.equals(((ArrayItemData)object).myArray) && ((ArrayItemData)object).myIndex == this.myIndex;
    }

    @Override
    public int hashCode() {
        return this.myArray.hashCode() + this.myIndex;
    }

    private static class ArrayItemDisplayKeyImpl
    implements DisplayKey<ArrayElementDescriptorImpl> {
        private final int myIndex;

        public ArrayItemDisplayKeyImpl(int index) {
            this.myIndex = index;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof ArrayItemDisplayKeyImpl && ((ArrayItemDisplayKeyImpl)o).myIndex == this.myIndex;
        }

        @Override
        public int hashCode() {
            return 0;
        }
    }
}

