/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.Attribute;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public class MethodBytecodeUtil {
    private static final Type OBJECT_TYPE = Type.getObjectType((String)"java/lang/Object");

    private MethodBytecodeUtil() {
    }

    public static void visit(Method method2, MethodVisitor methodVisitor, boolean withLineNumbers) {
        MethodBytecodeUtil.visit(method2, method2.bytecodes(), methodVisitor, withLineNumbers);
    }

    public static void visit(Method method2, long maxOffset, MethodVisitor methodVisitor, boolean withLineNumbers) {
        if (maxOffset > 0L) {
            byte[] originalBytecodes;
            byte[] bytecodes = originalBytecodes = method2.bytecodes();
            if (maxOffset < (long)originalBytecodes.length) {
                bytecodes = new byte[originalBytecodes.length];
                System.arraycopy(originalBytecodes, 0, bytecodes, 0, (int)maxOffset);
            }
            MethodBytecodeUtil.visit(method2, bytecodes, methodVisitor, withLineNumbers);
        }
    }

    public static byte[] getConstantPool(ReferenceType type2) {
        try {
            return type2.constantPool();
        }
        catch (NullPointerException e) {
            ReflectionUtil.resetField((Object)type2, (String)"constantPoolInfoGotten");
            return type2.constantPool();
        }
    }

    private static void visit(final Method method2, byte[] bytecodes, final MethodVisitor methodVisitor, boolean withLineNumbers) {
        ReferenceType type2 = method2.declaringType();
        try {
            byte[] constantPool = MethodBytecodeUtil.getConstantPool(type2);
            try (ByteArrayBuilderOutputStream bos = new ByteArrayBuilderOutputStream(constantPool.length + 24);
                 DataOutputStream dos = new DataOutputStream(bos);){
                dos.writeInt(-889275714);
                dos.writeInt(52);
                dos.writeShort(type2.constantPoolCount());
                dos.write(constantPool);
                dos.writeShort(0);
                dos.writeShort(0);
                dos.writeShort(0);
                dos.writeShort(0);
                dos.writeShort(0);
                dos.writeShort(0);
                dos.writeShort(0);
                ClassReader reader = new ClassReader(bos.getBuffer());
                ClassWriter writer = new ClassWriter(reader, 0);
                String superName = null;
                String[] interfaces = null;
                if (type2 instanceof ClassType) {
                    ClassType classType = (ClassType)type2;
                    ClassType superClass = classType.superclass();
                    superName = superClass != null ? superClass.name() : null;
                    interfaces = (String[])classType.interfaces().stream().map(ReferenceType::name).toArray(String[]::new);
                } else if (type2 instanceof InterfaceType) {
                    interfaces = (String[])((InterfaceType)type2).superinterfaces().stream().map(ReferenceType::name).toArray(String[]::new);
                }
                writer.visit(52, 1, type2.name(), type2.signature(), superName, interfaces);
                Attribute bootstrapMethods = MethodBytecodeUtil.createBootstrapMethods(reader, writer);
                if (bootstrapMethods != null) {
                    writer.visitAttribute(bootstrapMethods);
                }
                MethodVisitor mv = writer.visitMethod(1, method2.name(), method2.signature(), method2.signature(), null);
                mv.visitAttribute(MethodBytecodeUtil.createCode(writer, method2, bytecodes, withLineNumbers));
                new ClassReader(writer.toByteArray()).accept(new ClassVisitor(393216){

                    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                        assert (name.equals(method2.name()));
                        return methodVisitor;
                    }
                }, 0);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private static Attribute createAttribute(String name, ThrowableConsumer<DataOutputStream, IOException> generator) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    private static Attribute createBootstrapMethods(ClassReader classReader, ClassWriter classWriter) throws IOException {
        HashSet<Short> indys = new HashSet<Short>();
        block4: for (int i2 = 1; i2 < classReader.getItemCount(); ++i2) {
            int index = classReader.getItem(i2);
            int tag = classReader.readByte(index - 1);
            switch (tag) {
                case 5: 
                case 6: {
                    ++i2;
                    continue block4;
                }
                case 18: {
                    indys.add(classReader.readShort(index));
                    short s = classReader.readShort(index + 2);
                }
            }
        }
        if (!indys.isEmpty()) {
            int dummyRef = classWriter.newHandle(6, "DummyOwner", "DummyMethod", "", false);
            return MethodBytecodeUtil.createAttribute("BootstrapMethods", (ThrowableConsumer<DataOutputStream, IOException>)((ThrowableConsumer)dos -> {
                dos.writeShort(indys.size());
                for (Short indy : indys) {
                    dos.writeShort(dummyRef);
                    dos.writeShort(0);
                }
            }));
        }
        return null;
    }

    @NotNull
    private static Attribute createCode(ClassWriter cw, Method method2, byte[] bytecodes, boolean withLineNumbers) throws IOException {
        return MethodBytecodeUtil.createAttribute("Code", (ThrowableConsumer<DataOutputStream, IOException>)((ThrowableConsumer)dos -> {
            List<Object> locations;
            dos.writeShort(0);
            dos.writeShort(0);
            dos.writeInt(bytecodes.length);
            dos.write(bytecodes);
            dos.writeShort(0);
            List<Object> list = locations = withLineNumbers ? DebuggerUtilsEx.allLineLocations(method2) : Collections.emptyList();
            if (!locations.isEmpty()) {
                dos.writeShort(1);
                dos.writeShort(cw.newUTF8("LineNumberTable"));
                dos.writeInt(2 * locations.size() + 2);
                dos.writeShort(locations.size());
                for (Location location : locations) {
                    dos.writeShort((short)location.codeIndex());
                    dos.writeShort(location.lineNumber());
                }
            } else {
                dos.writeShort(0);
            }
        }));
    }

    public static Type getVarInstructionType(int opcode) {
        switch (opcode) {
            case 22: 
            case 55: {
                return Type.LONG_TYPE;
            }
            case 24: 
            case 57: {
                return Type.DOUBLE_TYPE;
            }
            case 23: 
            case 56: {
                return Type.FLOAT_TYPE;
            }
            case 21: 
            case 54: {
                return Type.INT_TYPE;
            }
        }
        return OBJECT_TYPE;
    }

    @Nullable
    public static Method getLambdaMethod(ReferenceType clsType, final VirtualMachineProxy vm) {
        List applicableMethods;
        final Ref methodRef = Ref.create();
        if (DebuggerUtilsEx.isLambdaClassName(clsType.name()) && (applicableMethods = ContainerUtil.filter(clsType.methods(), m -> m.isPublic() && !m.isBridge())).size() == 1) {
            MethodBytecodeUtil.visit((Method)applicableMethods.get(0), new MethodVisitor(393216){

                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                    Method method2;
                    ReferenceType cls = (ReferenceType)ContainerUtil.getFirstItem((List)vm.classesByName(owner));
                    if (cls != null && (method2 = DebuggerUtils.findMethod((ReferenceType)cls, (String)name, (String)desc)) != null) {
                        methodRef.setIfNull((Object)method2);
                    }
                }
            }, false);
        }
        return (Method)methodRef.get();
    }

    @Nullable
    public static Method getBridgeTargetMethod(final Method method2, final VirtualMachineProxy vm) {
        final Ref methodRef = Ref.create();
        if (method2.isBridge()) {
            MethodBytecodeUtil.visit(method2, new MethodVisitor(393216){

                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                    Method method22;
                    if ("java/lang/AbstractMethodError".equals(owner)) {
                        return;
                    }
                    ReferenceType declaringType = method2.declaringType();
                    owner = owner.replace("/", ".");
                    ReferenceType cls = declaringType.name().equals(owner) ? declaringType : (ReferenceType)ContainerUtil.getFirstItem((List)vm.classesByName(owner));
                    if (cls != null && (method22 = DebuggerUtils.findMethod((ReferenceType)cls, (String)name, (String)desc)) != null) {
                        methodRef.setIfNull((Object)method22);
                    }
                }
            }, false);
        }
        return (Method)methodRef.get();
    }

    private static class ByteArrayBuilderOutputStream
    extends ByteArrayOutputStream {
        public ByteArrayBuilderOutputStream(int size) {
            super(size);
        }

        byte[] getBuffer() {
            assert (this.buf.length == this.count) : "Buffer is not fully filled";
            return this.buf;
        }
    }
}

