/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.action;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.memory.action.ClassesActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JumpToTypeSourceAction
extends ClassesActionBase {
    @Override
    protected boolean isEnabled(AnActionEvent e) {
        PsiClass psiClass = this.getPsiClass(e);
        return super.isEnabled(e) && psiClass != null && psiClass.isPhysical();
    }

    @Override
    protected void perform(AnActionEvent e) {
        PsiClass psiClass = this.getPsiClass(e);
        if (psiClass != null) {
            NavigationUtil.activateFileWithPsiElement((PsiElement)psiClass);
        }
    }

    @Nullable
    private PsiClass getPsiClass(AnActionEvent e) {
        ReferenceType selectedClass = this.getSelectedClass(e);
        Project project2 = e.getProject();
        if (selectedClass == null || project2 == null) {
            return null;
        }
        ReferenceType targetClass = JumpToTypeSourceAction.getObjectType(selectedClass);
        if (targetClass != null) {
            return DebuggerUtils.findClass((String)targetClass.name(), (Project)project2, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project2));
        }
        return null;
    }

    @Nullable
    private static ReferenceType getObjectType(@NotNull ReferenceType ref) {
        if (!(ref instanceof ArrayType)) {
            return ref;
        }
        String elementTypeName = ref.name().replace("[]", "");
        VirtualMachine vm = ref.virtualMachine();
        List<ReferenceType> referenceTypes = vm.classesByName(elementTypeName);
        if (referenceTypes.size() == 1) {
            return referenceTypes.get(0);
        }
        return null;
    }
}

