/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.action.tracking;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.memory.action.DebuggerTreeAction;
import com.intellij.debugger.memory.component.MemoryViewDebugProcessData;
import com.intellij.debugger.memory.ui.StackFramePopup;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.sun.jdi.ObjectReference;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JumpToAllocationSourceAction
extends DebuggerTreeAction {
    @Override
    public void update(AnActionEvent e) {
        e.getPresentation().setVisible(this.getStack(e) != null);
    }

    @Override
    protected void perform(XValueNodeImpl node, @NotNull String nodeName, AnActionEvent e) {
        XDebugSession session2;
        Project project2 = e.getProject();
        List<StackFrameItem> stack = this.getStack(e);
        if (project2 != null && stack != null && (session2 = XDebuggerManager.getInstance((Project)project2).getCurrentSession()) != null) {
            DebugProcessImpl process2 = (DebugProcessImpl)DebuggerManager.getInstance((Project)project2).getDebugProcess(session2.getDebugProcess().getProcessHandler());
            StackFramePopup.show(stack, process2);
        }
    }

    @Nullable
    private List<StackFrameItem> getStack(AnActionEvent e) {
        ObjectReference ref;
        Project project2 = e.getProject();
        XValueNodeImpl selectedNode = JumpToAllocationSourceAction.getSelectedNode(e.getDataContext());
        ObjectReference objectReference = ref = selectedNode != null ? this.getObjectReference(selectedNode) : null;
        if (project2 == null || ref == null) {
            return null;
        }
        XDebugSession session2 = XDebuggerManager.getInstance((Project)project2).getCurrentSession();
        if (session2 != null) {
            MemoryViewDebugProcessData data = (MemoryViewDebugProcessData)DebuggerManager.getInstance((Project)project2).getDebugProcess(session2.getDebugProcess().getProcessHandler()).getUserData(MemoryViewDebugProcessData.KEY);
            return data != null ? data.getTrackedStacks().getStack(ref) : null;
        }
        return null;
    }
}

