/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.action.tracking;

import com.intellij.debugger.memory.component.InstancesTracker;
import com.intellij.debugger.memory.tracking.TrackingType;
import com.intellij.debugger.memory.ui.ClassesTable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ReferenceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrackInstancesToggleAction
extends ToggleAction {
    public void update(@NotNull AnActionEvent e) {
        ReferenceType selectedClass = TrackInstancesToggleAction.getSelectedClass(e);
        if (selectedClass instanceof ArrayType) {
            e.getPresentation().setEnabled(false);
        } else {
            super.update(e);
        }
    }

    public boolean isSelected(AnActionEvent e) {
        ReferenceType selectedClass = TrackInstancesToggleAction.getSelectedClass(e);
        Project project2 = e.getProject();
        if (project2 != null && selectedClass != null && !project2.isDisposed()) {
            InstancesTracker tracker = InstancesTracker.getInstance(project2);
            return tracker.isTracked(selectedClass.name());
        }
        return false;
    }

    public void setSelected(AnActionEvent e, boolean state) {
        ReferenceType selectedClass = TrackInstancesToggleAction.getSelectedClass(e);
        Project project2 = e.getProject();
        if (selectedClass != null && project2 != null && !project2.isDisposed()) {
            InstancesTracker tracker = InstancesTracker.getInstance(project2);
            boolean isAlreadyTracked = tracker.isTracked(selectedClass.name());
            if (isAlreadyTracked && !state) {
                tracker.remove(selectedClass.name());
            }
            if (!isAlreadyTracked && state) {
                tracker.add(selectedClass.name(), TrackingType.CREATION);
            }
        }
    }

    @Nullable
    private static ReferenceType getSelectedClass(AnActionEvent e) {
        return (ReferenceType)e.getData(ClassesTable.SELECTED_CLASS_KEY);
    }
}

