/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.component;

import com.intellij.debugger.memory.component.MemoryViewManagerState;
import com.intellij.debugger.memory.event.MemoryViewManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;

@State(name="MemoryViewSettings", storages={@Storage(value="memory.view.xml")})
public class MemoryViewManager
extends ApplicationComponent.Adapter
implements PersistentStateComponent<MemoryViewManagerState> {
    public static final String MEMORY_VIEW_CONTENT = "MemoryView";
    private final EventDispatcher<MemoryViewManagerListener> myDispatcher = EventDispatcher.create(MemoryViewManagerListener.class);
    private MemoryViewManagerState myState = new MemoryViewManagerState();

    public static MemoryViewManager getInstance() {
        return (MemoryViewManager)((Object)ApplicationManager.getApplication().getComponent(MemoryViewManager.class));
    }

    @NotNull
    public MemoryViewManagerState getState() {
        return new MemoryViewManagerState(this.myState);
    }

    public void loadState(MemoryViewManagerState state) {
        if (state == null) {
            state = new MemoryViewManagerState();
        }
        this.myState = state;
        this.fireStateChanged();
    }

    public void setShowDiffOnly(boolean value2) {
        if (this.myState.isShowWithDiffOnly != value2) {
            this.myState.isShowWithDiffOnly = value2;
            this.fireStateChanged();
        }
    }

    public void setShowWithInstancesOnly(boolean value2) {
        if (this.myState.isShowWithInstancesOnly != value2) {
            this.myState.isShowWithInstancesOnly = value2;
            this.fireStateChanged();
        }
    }

    public void setShowTrackedOnly(boolean value2) {
        if (this.myState.isShowTrackedOnly != value2) {
            this.myState.isShowTrackedOnly = value2;
            this.fireStateChanged();
        }
    }

    public boolean isNeedShowDiffOnly() {
        return this.myState.isShowWithDiffOnly;
    }

    public boolean isNeedShowInstancesOnly() {
        return this.myState.isShowWithInstancesOnly;
    }

    public boolean isNeedShowTrackedOnly() {
        return this.myState.isShowTrackedOnly;
    }

    public void addMemoryViewManagerListener(MemoryViewManagerListener listener2, @NotNull Disposable parentDisposable) {
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    private void fireStateChanged() {
        ((MemoryViewManagerListener)this.myDispatcher.getMulticaster()).stateChanged(new MemoryViewManagerState(this.myState));
    }
}

