/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.filtering;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.memory.filtering.CheckingResult;
import com.intellij.debugger.memory.filtering.CheckingResultImpl;
import com.intellij.debugger.memory.filtering.ConditionChecker;
import com.intellij.debugger.ui.tree.render.CachedEvaluator;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XExpression;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConditionCheckerImpl
implements ConditionChecker {
    private final DebugProcessImpl myDebugProcess;
    private final MyCachedEvaluator myEvaluator;
    private final AtomicReference<CheckingResult> myResultReference = new AtomicReference();

    public ConditionCheckerImpl(@NotNull DebugProcessImpl debugProcess, @Nullable XExpression expression2, @NotNull String className) {
        this.myDebugProcess = debugProcess;
        this.myEvaluator = new MyCachedEvaluator(this.myDebugProcess.getProject(), className);
        this.myEvaluator.setReferenceExpression(TextWithImportsImpl.fromXExpression(expression2));
    }

    @Override
    public CheckingResult check(@NotNull ObjectReference ref) {
        this.myDebugProcess.getManagerThread().invokeAndWait(new MyCheckerCommand(ref));
        return this.myResultReference.get();
    }

    private static class MyCachedEvaluator
    extends CachedEvaluator {
        private final Project myProject;
        private final String myClassName;

        public MyCachedEvaluator(@NotNull Project project2, @NotNull String className) {
            this.myProject = project2;
            this.myClassName = className;
        }

        ExpressionEvaluator getEvaluator() throws EvaluateException {
            return this.getEvaluator(this.myProject);
        }

        @Override
        protected String getClassName() {
            return this.myClassName;
        }
    }

    private class MyCheckerCommand
    extends DebuggerContextCommandImpl {
        private final ObjectReference myReference;

        protected MyCheckerCommand(ObjectReference ref) {
            super(ConditionCheckerImpl.this.myDebugProcess.getDebuggerContext());
            this.myReference = ref;
        }

        @Override
        public PrioritizedTask.Priority getPriority() {
            return PrioritizedTask.Priority.LOWEST;
        }

        @Override
        public void threadAction(@NotNull SuspendContextImpl suspendContext) {
            try {
                ExpressionEvaluator evaluator = ConditionCheckerImpl.this.myEvaluator.getEvaluator();
                Value result2 = evaluator.evaluate((EvaluationContext)new EvaluationContextImpl(suspendContext, suspendContext.getFrameProxy(), this.myReference));
                if (result2 instanceof BooleanValue && ((BooleanValue)result2).value()) {
                    ConditionCheckerImpl.this.myResultReference.set(CheckingResultImpl.SUCCESS);
                } else {
                    ConditionCheckerImpl.this.myResultReference.set(CheckingResultImpl.FAIL);
                }
            }
            catch (EvaluateException e) {
                ConditionCheckerImpl.this.myResultReference.set(CheckingResultImpl.error(e.getMessage()));
            }
        }
    }
}

