/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.memory.component.InstancesTracker;
import com.intellij.debugger.memory.component.MemoryViewDebugProcessData;
import com.intellij.debugger.memory.component.MemoryViewManager;
import com.intellij.debugger.memory.component.MemoryViewManagerState;
import com.intellij.debugger.memory.event.InstancesTrackerListener;
import com.intellij.debugger.memory.event.MemoryViewManagerListener;
import com.intellij.debugger.memory.tracking.ClassPreparedListener;
import com.intellij.debugger.memory.tracking.ConstructorInstancesTracker;
import com.intellij.debugger.memory.tracking.TrackerForNewInstances;
import com.intellij.debugger.memory.tracking.TrackingType;
import com.intellij.debugger.memory.ui.ClassesTable;
import com.intellij.debugger.memory.ui.InstancesWindow;
import com.intellij.debugger.memory.utils.AndroidUtil;
import com.intellij.debugger.memory.utils.KeyboardUtils;
import com.intellij.debugger.memory.utils.LowestPriorityCommand;
import com.intellij.debugger.memory.utils.SingleAlarmWithMutableDelay;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.FocusManager;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassesFilteredView
extends BorderLayoutPanel
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ClassesFilteredView.class);
    private static final double DELAY_BEFORE_INSTANCES_QUERY_COEFFICIENT = 0.5;
    private static final double MAX_DELAY_MILLIS = TimeUnit.SECONDS.toMillis(2L);
    private static final int DEFAULT_BATCH_SIZE = Integer.MAX_VALUE;
    private static final String EMPTY_TABLE_CONTENT_WHEN_RUNNING = "The application is running";
    private static final String EMPTY_TABLE_CONTENT_WHEN_SUSPENDED = "Nothing to show";
    private static final String EMPTY_TABLE_CONTENT_WHEN_STOPPED = "Classes are not available";
    private final Project myProject;
    private final SingleAlarmWithMutableDelay mySingleAlarm;
    private final SearchTextField myFilterTextField = new FilterTextField();
    private final ClassesTable myTable;
    private final InstancesTracker myInstancesTracker;
    private final Map<ReferenceType, ConstructorInstancesTracker> myConstructorTrackedClasses = new ConcurrentHashMap<ReferenceType, ConstructorInstancesTracker>();
    private final MyDebuggerSessionListener myDebugSessionListener;
    private final AtomicInteger myTime = new AtomicInteger(0);
    private final AtomicInteger myLastUpdatingTime = new AtomicInteger(Integer.MIN_VALUE);
    private final AtomicBoolean myIsTrackersActivated = new AtomicBoolean(false);
    private boolean myIsActive;

    public ClassesFilteredView(final @NotNull XDebugSession debugSession, final @NotNull DebugProcessImpl debugProcess, final @NotNull InstancesTracker tracker) {
        this.myProject = debugSession.getProject();
        final DebuggerManagerThreadImpl managerThread = debugProcess.getManagerThread();
        this.myInstancesTracker = tracker;
        final InstancesTrackerListener instancesTrackerListener = new InstancesTrackerListener(){

            @Override
            public void classChanged(@NotNull String name, final @NotNull TrackingType type2) {
                final ReferenceType ref = ClassesFilteredView.this.myTable.getClassByName(name);
                if (ref != null) {
                    final boolean activated = ClassesFilteredView.this.myIsTrackersActivated.get();
                    managerThread.schedule(new DebuggerCommandImpl(){

                        @Override
                        protected void action() throws Exception {
                            ClassesFilteredView.this.trackClass(debugSession, ref, type2, activated);
                        }
                    });
                }
                ClassesFilteredView.this.myTable.repaint();
            }

            @Override
            public void classRemoved(@NotNull String name) {
                ReferenceType ref = ClassesFilteredView.this.myTable.getClassByName(name);
                if (ref != null && ClassesFilteredView.this.myConstructorTrackedClasses.containsKey(ref)) {
                    ConstructorInstancesTracker removed = (ConstructorInstancesTracker)ClassesFilteredView.this.myConstructorTrackedClasses.remove(ref);
                    Disposer.dispose((Disposable)removed);
                    ClassesFilteredView.this.myTable.getRowSorter().allRowsChanged();
                }
            }
        };
        managerThread.schedule(new DebuggerCommandImpl(){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.LOWEST;
            }

            @Override
            protected void action() throws Exception {
                boolean activated = ClassesFilteredView.this.myIsTrackersActivated.get();
                tracker.getTrackedClasses().forEach((className, type2) -> {
                    List<ReferenceType> classes2 = debugProcess.getVirtualMachineProxy().classesByName((String)className);
                    if (classes2.isEmpty()) {
                        new ClassPreparedListener((String)className, debugSession, (TrackingType)((Object)type2)){
                            final /* synthetic */ TrackingType val$type;
                            {
                                this.val$type = trackingType;
                                super(className, debugSession);
                            }

                            @Override
                            public void onClassPrepared(@NotNull ReferenceType referenceType, @NotNull XDebugSession session2) {
                                ClassesFilteredView.this.trackClass(session2, referenceType, this.val$type, ClassesFilteredView.this.myIsTrackersActivated.get());
                            }
                        };
                    } else {
                        for (ReferenceType ref : classes2) {
                            ClassesFilteredView.this.trackClass(debugSession, ref, type2, activated);
                        }
                    }
                });
                tracker.addTrackerListener(instancesTrackerListener, ClassesFilteredView.this);
            }
        });
        MemoryViewManagerState memoryViewManagerState = MemoryViewManager.getInstance().getState();
        this.myTable = new ClassesTable(tracker, this, memoryViewManagerState.isShowWithDiffOnly, memoryViewManagerState.isShowWithInstancesOnly, memoryViewManagerState.isShowTrackedOnly);
        this.myTable.getEmptyText().setText(EMPTY_TABLE_CONTENT_WHEN_RUNNING);
        Disposer.register((Disposable)this, (Disposable)this.myTable);
        this.myTable.addMouseMotionListener(new MyMouseMotionListener());
        this.myTable.addMouseListener(new MyOpenNewInstancesListener());
        new MyDoubleClickListener().installOn((Component)((Object)this.myTable));
        this.myTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (KeyboardUtils.isEnterKey(keyCode)) {
                    ClassesFilteredView.this.handleClassSelection(ClassesFilteredView.this.myTable.getSelectedClass());
                } else if (KeyboardUtils.isCharacter(keyCode) || KeyboardUtils.isBackSpace(keyCode)) {
                    String text = ClassesFilteredView.this.myFilterTextField.getText();
                    String newText = KeyboardUtils.isBackSpace(keyCode) ? text.substring(0, text.length() - 1) : text + e.getKeyChar();
                    ClassesFilteredView.this.myFilterTextField.setText(newText);
                    FocusManager.getCurrentManager().focusNextComponent((Component)ClassesFilteredView.this.myFilterTextField);
                }
            }
        });
        this.myFilterTextField.addKeyboardListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                this.dispatch(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.dispatch(e);
            }

            private void dispatch(KeyEvent e) {
                if (KeyboardUtils.isUpDownKey(e.getKeyCode()) || KeyboardUtils.isEnterKey(e.getKeyCode())) {
                    ClassesFilteredView.this.myTable.dispatchEvent(e);
                }
            }
        });
        this.myFilterTextField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ClassesFilteredView.this.myTable.setFilterPattern(ClassesFilteredView.this.myFilterTextField.getText());
            }
        });
        MemoryViewManagerListener memoryViewManagerListener = state -> {
            this.myTable.setFilteringByDiffNonZero(state.isShowWithDiffOnly);
            this.myTable.setFilteringByInstanceExists(state.isShowWithInstancesOnly);
            this.myTable.setFilteringByTrackingState(state.isShowTrackedOnly);
        };
        MemoryViewManager.getInstance().addMemoryViewManagerListener(memoryViewManagerListener, this);
        this.myDebugSessionListener = new MyDebuggerSessionListener();
        debugSession.addSessionListener((XDebugSessionListener)this.myDebugSessionListener, (Disposable)this);
        this.mySingleAlarm = new SingleAlarmWithMutableDelay(() -> {
            SuspendContextImpl suspendContext = debugProcess.getDebuggerContext().getSuspendContext();
            if (suspendContext != null) {
                ApplicationManager.getApplication().invokeLater(() -> this.myTable.setBusy(true));
                managerThread.schedule(new MyUpdateClassesCommand(suspendContext));
            }
        }, this);
        this.myTable.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionPopupMenu menu = ClassesFilteredView.createContextMenu();
                if (menu != null) {
                    menu.getComponent().show(comp, x, y);
                }
            }
        });
        JScrollPane scroll = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTable), (int)2);
        DefaultActionGroup group = (DefaultActionGroup)ActionManager.getInstance().getAction("MemoryView.SettingsPopupActionGroup");
        group.setPopup(true);
        Presentation actionsPresentation = new Presentation("Memory View Settings");
        actionsPresentation.setIcon(AllIcons.General.SecondaryGroup);
        ActionButton button = new ActionButton((AnAction)group, actionsPresentation, "unknown", (Dimension)new JBDimension(25, 25));
        BorderLayoutPanel topPanel = new BorderLayoutPanel();
        topPanel.addToCenter((Component)this.myFilterTextField);
        topPanel.addToRight((Component)button);
        this.addToTop((Component)topPanel);
        this.addToCenter(scroll);
    }

    @Nullable
    TrackerForNewInstances getStrategy(@NotNull ReferenceType ref) {
        return this.myConstructorTrackedClasses.getOrDefault(ref, null);
    }

    private void trackClass(@NotNull XDebugSession session2, @NotNull ReferenceType ref, @NotNull TrackingType type2, boolean isTrackerEnabled) {
        LOG.assertTrue(DebuggerManager.getInstance((Project)this.myProject).isDebuggerManagerThread());
        if (type2 == TrackingType.CREATION) {
            ConstructorInstancesTracker old = this.myConstructorTrackedClasses.getOrDefault(ref, null);
            if (old != null) {
                Disposer.dispose((Disposable)old);
            }
            ConstructorInstancesTracker tracker = new ConstructorInstancesTracker(ref, session2, this.myInstancesTracker);
            tracker.setBackgroundMode(!this.myIsActive);
            if (isTrackerEnabled) {
                tracker.enable();
            } else {
                tracker.disable();
            }
            this.myConstructorTrackedClasses.put(ref, tracker);
        }
    }

    private void handleClassSelection(@Nullable ReferenceType ref) {
        XDebugSession debugSession = XDebuggerManager.getInstance((Project)this.myProject).getCurrentSession();
        if (ref != null && debugSession != null && debugSession.isSuspended()) {
            new InstancesWindow(debugSession, limit -> {
                List<ObjectReference> instances = ref.instances(limit);
                return instances == null ? Collections.emptyList() : instances;
            }, ref.name()).show();
        }
    }

    private void commitAllTrackers() {
        this.myConstructorTrackedClasses.values().forEach(ConstructorInstancesTracker::commitTracked);
    }

    private void updateClassesAndCounts() {
        ApplicationManager.getApplication().invokeLater(() -> {
            DebugProcess debugProcess;
            XDebugSession debugSession = XDebuggerManager.getInstance((Project)this.myProject).getCurrentSession();
            if (debugSession != null && (debugProcess = DebuggerManager.getInstance((Project)this.myProject).getDebugProcess(debugSession.getDebugProcess().getProcessHandler())) != null && debugProcess.isAttached()) {
                this.mySingleAlarm.cancelAndRequest();
            }
        }, x -> this.myProject.isDisposed());
    }

    private static ActionPopupMenu createContextMenu() {
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("MemoryView.ClassesPopupActionGroup");
        return ActionManager.getInstance().createActionPopupMenu("MemoryView.ClassesPopupActionGroup", group);
    }

    public void dispose() {
        this.myConstructorTrackedClasses.clear();
    }

    public void setActive(final boolean active, @NotNull DebugProcessImpl process2) {
        if (this.myIsActive == active) {
            return;
        }
        this.myIsActive = active;
        process2.getManagerThread().schedule(new DebuggerCommandImpl(){

            @Override
            protected void action() throws Exception {
                if (active) {
                    ClassesFilteredView.this.doActivate();
                } else {
                    ClassesFilteredView.this.doPause();
                }
            }
        });
    }

    private void doActivate() {
        this.myDebugSessionListener.setActive(true);
        this.myConstructorTrackedClasses.values().forEach(x -> x.setBackgroundMode(false));
        if (this.isNeedUpdateView()) {
            this.updateClassesAndCounts();
        }
    }

    private void doPause() {
        this.myDebugSessionListener.setActive(false);
        this.myConstructorTrackedClasses.values().forEach(x -> x.setBackgroundMode(true));
    }

    private boolean isNeedUpdateView() {
        return this.myLastUpdatingTime.get() != this.myTime.get();
    }

    private void viewUpdated() {
        this.myLastUpdatingTime.set(this.myTime.get());
    }

    private boolean isShowNewInstancesEvent(@NotNull MouseEvent e) {
        int col = this.myTable.columnAtPoint(e.getPoint());
        int row = this.myTable.rowAtPoint(e.getPoint());
        if (col == -1 || row == -1 || this.myTable.convertColumnIndexToModel(col) != 2) {
            return false;
        }
        int modelRow = this.myTable.convertRowIndexToModel(row);
        ReferenceType ref = (ReferenceType)this.myTable.getModel().getValueAt(modelRow, 0);
        ConstructorInstancesTracker tracker = this.myConstructorTrackedClasses.getOrDefault(ref, null);
        return tracker != null && tracker.isReady() && tracker.getCount() > 0;
    }

    private class MyDebuggerSessionListener
    implements XDebugSessionListener {
        private volatile boolean myIsActive = false;

        private MyDebuggerSessionListener() {
        }

        void setActive(boolean value2) {
            this.myIsActive = value2;
        }

        public void sessionResumed() {
            if (this.myIsActive) {
                ClassesFilteredView.this.myConstructorTrackedClasses.values().forEach(ConstructorInstancesTracker::obsolete);
                ApplicationManager.getApplication().invokeLater(() -> {
                    ClassesFilteredView.this.myTable.getEmptyText().setText(ClassesFilteredView.EMPTY_TABLE_CONTENT_WHEN_RUNNING);
                    ClassesFilteredView.this.myTable.hideContent();
                });
                ClassesFilteredView.this.mySingleAlarm.cancelAllRequests();
            }
        }

        public void sessionStopped() {
            ClassesFilteredView.this.myConstructorTrackedClasses.values().forEach(Disposer::dispose);
            ClassesFilteredView.this.myConstructorTrackedClasses.clear();
            ClassesFilteredView.this.mySingleAlarm.cancelAllRequests();
            ApplicationManager.getApplication().invokeLater(() -> {
                ClassesFilteredView.this.myTable.getEmptyText().setText(ClassesFilteredView.EMPTY_TABLE_CONTENT_WHEN_STOPPED);
                ClassesFilteredView.this.myTable.clean();
            });
        }

        public void sessionPaused() {
            if (this.myIsActive) {
                ApplicationManager.getApplication().invokeLater(() -> ClassesFilteredView.this.myTable.getEmptyText().setText(ClassesFilteredView.EMPTY_TABLE_CONTENT_WHEN_SUSPENDED));
                ClassesFilteredView.this.updateClassesAndCounts();
            }
            ClassesFilteredView.this.myTime.incrementAndGet();
        }
    }

    private class MyMouseMotionListener
    implements MouseMotionListener {
        private MyMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (ClassesFilteredView.this.isShowNewInstancesEvent(e)) {
                ClassesFilteredView.this.myTable.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                ClassesFilteredView.this.myTable.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private class MyDoubleClickListener
    extends DoubleClickListener {
        private MyDoubleClickListener() {
        }

        protected boolean onDoubleClick(MouseEvent event) {
            if (!ClassesFilteredView.this.isShowNewInstancesEvent(event)) {
                ClassesFilteredView.this.handleClassSelection(ClassesFilteredView.this.myTable.getSelectedClass());
                return true;
            }
            return false;
        }
    }

    private class MyOpenNewInstancesListener
    extends MouseAdapter {
        private MyOpenNewInstancesListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() != 1 || e.getButton() != 1 || !ClassesFilteredView.this.isShowNewInstancesEvent(e)) {
                return;
            }
            ReferenceType ref = ClassesFilteredView.this.myTable.getSelectedClass();
            TrackerForNewInstances strategy = ref == null ? null : ClassesFilteredView.this.getStrategy(ref);
            XDebugSession debugSession = XDebuggerManager.getInstance((Project)ClassesFilteredView.this.myProject).getCurrentSession();
            if (strategy != null && debugSession != null) {
                DebugProcess debugProcess = DebuggerManager.getInstance((Project)ClassesFilteredView.this.myProject).getDebugProcess(debugSession.getDebugProcess().getProcessHandler());
                MemoryViewDebugProcessData data = (MemoryViewDebugProcessData)debugProcess.getUserData(MemoryViewDebugProcessData.KEY);
                if (data != null) {
                    List<ObjectReference> newInstances = strategy.getNewInstances();
                    data.getTrackedStacks().pinStacks(ref);
                    InstancesWindow instancesWindow = new InstancesWindow(debugSession, limit -> newInstances, ref.name());
                    Disposer.register((Disposable)instancesWindow.getDisposable(), () -> data.getTrackedStacks().unpinStacks(ref));
                    instancesWindow.show();
                } else {
                    LOG.warn("MemoryViewDebugProcessData not found in debug session user data");
                }
            }
        }
    }

    private static class FilterTextField
    extends SearchTextField {
        FilterTextField() {
            super(false);
        }

        protected void showPopup() {
        }

        protected boolean hasIconsOutsideOfTextField() {
            return false;
        }
    }

    private final class MyUpdateClassesCommand
    extends LowestPriorityCommand {
        MyUpdateClassesCommand(SuspendContextImpl suspendContext) {
            super(suspendContext);
        }

        @Override
        public void contextAction(@NotNull SuspendContextImpl suspendContext) throws Exception {
            this.handleTrackers();
            List<ReferenceType> classes2 = suspendContext.getDebugProcess().getVirtualMachineProxy().allClasses();
            if (!classes2.isEmpty()) {
                VirtualMachine vm = classes2.get(0).virtualMachine();
                if (vm.canGetInstanceInfo()) {
                    Map<ReferenceType, Long> counts = this.getInstancesCounts(classes2, vm);
                    ApplicationManager.getApplication().invokeLater(() -> ClassesFilteredView.this.myTable.updateContent(counts));
                } else {
                    ApplicationManager.getApplication().invokeLater(() -> ClassesFilteredView.this.myTable.updateClassesOnly(classes2));
                }
            }
            ApplicationManager.getApplication().invokeLater(() -> ClassesFilteredView.this.myTable.setBusy(false));
            ClassesFilteredView.this.viewUpdated();
        }

        private void handleTrackers() {
            if (!ClassesFilteredView.this.myIsTrackersActivated.get()) {
                ClassesFilteredView.this.myConstructorTrackedClasses.values().forEach(ConstructorInstancesTracker::enable);
                ClassesFilteredView.this.myIsTrackersActivated.set(true);
            } else {
                ClassesFilteredView.this.commitAllTrackers();
            }
        }

        private Map<ReferenceType, Long> getInstancesCounts(@NotNull List<ReferenceType> classes2, @NotNull VirtualMachine vm) {
            int batchSize = AndroidUtil.isAndroidVM(vm) ? 500 : Integer.MAX_VALUE;
            int size = classes2.size();
            LinkedHashMap<ReferenceType, Long> result2 = new LinkedHashMap<ReferenceType, Long>();
            int begin = 0;
            int end = Math.min(batchSize, size);
            while (begin != size) {
                List<ReferenceType> batch = classes2.subList(begin, end);
                long start = System.nanoTime();
                long[] counts = vm.instanceCounts(batch);
                long delay = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
                for (int i2 = 0; i2 < batch.size(); ++i2) {
                    result2.put(batch.get(i2), counts[i2]);
                }
                int waitTime = (int)Math.min(0.5 * (double)delay, MAX_DELAY_MILLIS);
                ClassesFilteredView.this.mySingleAlarm.setDelay(waitTime);
                LOG.info(String.format("Instances query time = %d ms. Count of classes = %d", delay, batch.size()));
                begin = end;
                end = Math.min(end + batchSize, size);
            }
            return result2;
        }
    }
}

