/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionEditor;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingWorker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExpressionEditorWithHistory
extends XDebuggerExpressionEditor {
    private static final String HISTORY_ID_PREFIX = "filtering";

    ExpressionEditorWithHistory(final @NotNull Project project2, final @NotNull String className, @NotNull XDebuggerEditorsProvider debuggerEditorsProvider, @Nullable Disposable parentDisposable) {
        super(project2, debuggerEditorsProvider, HISTORY_ID_PREFIX + className, null, XExpressionImpl.EMPTY_EXPRESSION, false, true, true);
        new AnAction("InstancesWindow.ShowHistory"){

            public void actionPerformed(AnActionEvent e) {
                ExpressionEditorWithHistory.this.showHistory();
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(LookupManager.getActiveLookup(ExpressionEditorWithHistory.this.getEditor()) == null);
            }
        }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"DOWN"}), this.getComponent(), parentDisposable);
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                ApplicationManager.getApplication().runReadAction(() -> {
                    PsiClass psiClass = DebuggerUtils.findClass((String)className, (Project)project2, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project2));
                    ApplicationManager.getApplication().invokeLater(() -> ExpressionEditorWithHistory.this.setContext((PsiElement)psiClass));
                });
                return null;
            }
        }.execute();
    }

    private void showHistory() {
        List<XExpression> expressions2 = this.getRecentExpressions();
        if (!expressions2.isEmpty()) {
            ListPopupImpl historyPopup = new ListPopupImpl((ListPopupStep)new BaseListPopupStep<XExpression>(null, expressions2){

                public PopupStep onChosen(XExpression selectedValue, boolean finalChoice) {
                    ExpressionEditorWithHistory.this.setExpression(selectedValue);
                    ExpressionEditorWithHistory.this.requestFocusInEditor();
                    return FINAL_CHOICE;
                }
            }){

                @Override
                protected ListCellRenderer getListElementRenderer() {
                    return new ColoredListCellRenderer<XExpression>(){

                        protected void customizeCellRenderer(@NotNull JList list, XExpression value2, int index, boolean selected, boolean hasFocus) {
                            this.append(value2.getExpression(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        }
                    };
                }
            };
            historyPopup.getList().setFont(EditorUtil.getEditorFont());
            historyPopup.showUnderneathOf(this.getEditorComponent());
        }
    }
}

