/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorProvider;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstancesTree
extends XDebuggerTree {
    private final XValueNodeImpl myRoot;
    private final Runnable myOnRootExpandAction;
    private List<XValueChildrenList> myChildren;

    InstancesTree(@NotNull Project project2, @NotNull XDebuggerEditorsProvider editorsProvider, @Nullable XValueMarkers<?, ?> valueMarkers, @NotNull Runnable onRootExpand) {
        super(project2, editorsProvider, null, "XDebugger.Inspect.Tree.Popup", valueMarkers);
        this.myOnRootExpandAction = onRootExpand;
        this.myRoot = new XValueNodeImpl(this, null, "root", new MyRootValue());
        this.myRoot.children();
        this.setRoot(this.myRoot, false);
        this.myRoot.setLeaf(false);
        this.setSelectionRow(0);
        this.expandNodesOnLoad((Condition<TreeNode>)((Condition)node -> node == this.myRoot));
    }

    void addChildren(@NotNull XValueChildrenList children2, boolean last) {
        if (this.myChildren == null) {
            this.myChildren = new ArrayList<XValueChildrenList>();
        }
        this.myChildren.add(children2);
        this.myRoot.addChildren(children2, last);
    }

    void rebuildTree(@NotNull RebuildPolicy policy, @NotNull XDebuggerTreeState state) {
        if (policy == RebuildPolicy.RELOAD_INSTANCES) {
            this.myChildren = null;
        }
        this.rebuildAndRestore(state);
    }

    void rebuildTree(@NotNull RebuildPolicy policy) {
        this.rebuildTree(policy, XDebuggerTreeState.saveState(this));
    }

    void setInfoMessage(@NotNull String text) {
        this.myChildren = null;
        this.myRoot.clearChildren();
        this.myRoot.setMessage(text, XDebuggerUIConstants.INFORMATION_MESSAGE_ICON, SimpleTextAttributes.REGULAR_ATTRIBUTES, null);
    }

    @Nullable
    ObjectReference getSelectedReference() {
        Value value2;
        NodeDescriptorImpl descriptor;
        XValueNodeImpl xValueNode;
        XValue valueContainer;
        Object selectedItem;
        TreePath selectionPath = this.getSelectionPath();
        Object object = selectedItem = selectionPath != null ? selectionPath.getLastPathComponent() : null;
        if (selectedItem instanceof XValueNodeImpl && (valueContainer = (XValue)(xValueNode = (XValueNodeImpl)selectedItem).getValueContainer()) instanceof NodeDescriptorProvider && (descriptor = ((NodeDescriptorProvider)valueContainer).getDescriptor()) instanceof ValueDescriptor && (value2 = ((ValueDescriptor)((Object)descriptor)).getValue()) instanceof ObjectReference) {
            return (ObjectReference)value2;
        }
        return null;
    }

    private class MyRootValue
    extends XValue {
        private MyRootValue() {
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            if (InstancesTree.this.myChildren == null) {
                InstancesTree.this.myOnRootExpandAction.run();
            } else {
                for (XValueChildrenList children2 : InstancesTree.this.myChildren) {
                    InstancesTree.this.myRoot.addChildren(children2, false);
                }
                InstancesTree.this.myRoot.addChildren(XValueChildrenList.EMPTY, true);
            }
        }

        public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
            node.setPresentation(null, "", "", true);
        }
    }

    static enum RebuildPolicy {
        RELOAD_INSTANCES,
        ONLY_UPDATE_LABELS;

    }
}

