/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.memory.filtering.FilteringResult;
import com.intellij.debugger.memory.filtering.FilteringTask;
import com.intellij.debugger.memory.filtering.FilteringTaskCallback;
import com.intellij.debugger.memory.ui.ExpressionEditorWithHistory;
import com.intellij.debugger.memory.ui.FilteringProgressView;
import com.intellij.debugger.memory.ui.InstancesTree;
import com.intellij.debugger.memory.ui.InstancesWithStackFrameView;
import com.intellij.debugger.memory.ui.StackFrameList;
import com.intellij.debugger.memory.utils.AndroidUtil;
import com.intellij.debugger.memory.utils.ErrorsValueGroup;
import com.intellij.debugger.memory.utils.InstanceJavaValue;
import com.intellij.debugger.memory.utils.InstanceValueDescriptor;
import com.intellij.debugger.memory.utils.InstancesProvider;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.actions.XDebuggerActionBase;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionEditor;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.sun.jdi.ObjectReference;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.JavaDebuggerEditorsProvider;

public class InstancesWindow
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(InstancesWindow.class);
    private static final int DEFAULT_WINDOW_WIDTH = 870;
    private static final int DEFAULT_WINDOW_HEIGHT = 400;
    private static final int FILTERING_BUTTON_ADDITIONAL_WIDTH = 30;
    private static final int BORDER_LAYOUT_DEFAULT_GAP = 5;
    private static final int DEFAULT_INSTANCES_LIMIT = 500000;
    private final Project myProject;
    private final DebugProcessImpl myDebugProcess;
    private final InstancesProvider myInstancesProvider;
    private final String myClassName;
    private final MyInstancesView myInstancesView;

    public InstancesWindow(@NotNull XDebugSession session2, @NotNull InstancesProvider provider2, @NotNull String className) {
        super(session2.getProject(), false);
        this.myProject = session2.getProject();
        this.myDebugProcess = (DebugProcessImpl)DebuggerManager.getInstance((Project)this.myProject).getDebugProcess(session2.getDebugProcess().getProcessHandler());
        this.myInstancesProvider = provider2;
        this.myClassName = className;
        this.addWarningMessage(null);
        session2.addSessionListener(new XDebugSessionListener(){

            public void sessionStopped() {
                ApplicationManager.getApplication().invokeLater(() -> InstancesWindow.this.close(0));
            }
        }, this.myDisposable);
        this.setModal(false);
        this.myInstancesView = new MyInstancesView(session2);
        this.myInstancesView.setPreferredSize((Dimension)new JBDimension(870, 400));
        this.init();
        JRootPane root = this.myInstancesView.getRootPane();
        root.setDefaultButton(this.myInstancesView.myFilterButton);
    }

    private void addWarningMessage(@Nullable String message2) {
        String warning = message2 == null ? "" : String.format(". Warning: %s", message2);
        this.setTitle(String.format("Instances of %s%s", this.myClassName, warning));
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "#org.jetbrains.debugger.memory.view.InstancesWindow";
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myInstancesView;
    }

    @Nullable
    protected JComponent createSouthPanel() {
        JComponent comp = super.createSouthPanel();
        if (comp != null) {
            comp.add((Component)((Object)this.myInstancesView.myProgress), "West");
        }
        return comp;
    }

    @NotNull
    protected Action[] createActions() {
        return new Action[]{new DialogWrapper.DialogWrapperExitAction((DialogWrapper)this, "Close", 1)};
    }

    private static final class MyNodeManager
    extends NodeManagerImpl {
        MyNodeManager(Project project2) {
            super(project2, null);
        }

        @Override
        public DebuggerTreeNodeImpl createNode(NodeDescriptor descriptor, EvaluationContext evaluationContext) {
            return new DebuggerTreeNodeImpl(null, descriptor);
        }

        @Override
        public DebuggerTreeNodeImpl createMessageNode(MessageDescriptor descriptor) {
            return new DebuggerTreeNodeImpl(null, descriptor);
        }

        @Override
        public DebuggerTreeNodeImpl createMessageNode(String message2) {
            return new DebuggerTreeNodeImpl(null, new MessageDescriptor(message2));
        }
    }

    private class MyInstancesView
    extends JBPanel
    implements Disposable {
        private static final int MAX_TREE_NODE_COUNT = 2000;
        private static final int FILTERING_CHUNK_SIZE = 50;
        private static final int MAX_DURATION_TO_UPDATE_TREE_SECONDS = 3;
        private static final int FILTERING_PROGRESS_UPDATING_MIN_DELAY_MILLIS = 17;
        private final InstancesTree myInstancesTree;
        private final XDebuggerExpressionEditor myFilterConditionEditor;
        private final XDebugSessionListener myDebugSessionListener;
        private final MyNodeManager myNodeManager;
        private final JButton myFilterButton;
        private final FilteringProgressView myProgress;
        private final Object myFilteringTaskLock;
        private boolean myIsAndroidVM;
        private volatile MyFilteringWorker myFilteringTask;

        MyInstancesView(XDebugSession session2) {
            super((LayoutManager)new BorderLayout(0, JBUI.scale((int)5)));
            this.myDebugSessionListener = new MySessionListener();
            this.myNodeManager = new MyNodeManager(InstancesWindow.this.myProject);
            this.myFilterButton = new JButton("Filter");
            this.myProgress = new FilteringProgressView();
            this.myFilteringTaskLock = new Object();
            this.myIsAndroidVM = false;
            this.myFilteringTask = null;
            Disposer.register((Disposable)InstancesWindow.this.myDisposable, (Disposable)this);
            XValueMarkers<?, ?> markers = this.getValueMarkers(session2);
            if (markers != null) {
                MyActionListener listener2 = new MyActionListener(markers);
                ActionManager.getInstance().addAnActionListener((AnActionListener)listener2, InstancesWindow.this.myDisposable);
            }
            session2.addSessionListener(this.myDebugSessionListener, InstancesWindow.this.myDisposable);
            JavaDebuggerEditorsProvider editorsProvider = new JavaDebuggerEditorsProvider();
            this.myFilterConditionEditor = new ExpressionEditorWithHistory(InstancesWindow.this.myProject, InstancesWindow.this.myClassName, (XDebuggerEditorsProvider)editorsProvider, InstancesWindow.this.myDisposable);
            this.myFilterButton.setBorder(BorderFactory.createEmptyBorder());
            Dimension filteringButtonSize = this.myFilterConditionEditor.getEditorComponent().getPreferredSize();
            filteringButtonSize.width = JBUI.scale((int)30) + this.myFilterButton.getPreferredSize().width;
            this.myFilterButton.setPreferredSize(filteringButtonSize);
            JBPanel filteringPane = new JBPanel((LayoutManager)new BorderLayout(JBUI.scale((int)5), 0));
            JBLabel sideEffectsWarning = new JBLabel("Warning: filtering may have side effects", 4);
            sideEffectsWarning.setBorder((Border)JBUI.Borders.empty((int)1, (int)0, (int)0, (int)0));
            sideEffectsWarning.setComponentStyle(UIUtil.ComponentStyle.SMALL);
            sideEffectsWarning.setFontColor(UIUtil.FontColor.BRIGHTER);
            filteringPane.add((Component)new JBLabel("Condition:"), (Object)"West");
            filteringPane.add((Component)this.myFilterConditionEditor.getComponent(), (Object)"Center");
            filteringPane.add((Component)this.myFilterButton, (Object)"East");
            filteringPane.add((Component)sideEffectsWarning, (Object)"South");
            this.myProgress.addStopActionListener(this::cancelFilteringTask);
            this.myInstancesTree = new InstancesTree(InstancesWindow.this.myProject, (XDebuggerEditorsProvider)editorsProvider, markers, this::updateInstances);
            this.myFilterButton.addActionListener(e -> {
                String expression2 = this.myFilterConditionEditor.getExpression().getExpression();
                if (!expression2.isEmpty()) {
                    this.myFilterConditionEditor.saveTextInHistory();
                }
                this.myFilterButton.setEnabled(false);
                this.myInstancesTree.rebuildTree(InstancesTree.RebuildPolicy.RELOAD_INSTANCES);
            });
            final StackFrameList list = new StackFrameList(InstancesWindow.this.myDebugProcess);
            list.addListSelectionListener(e -> list.navigateToSelectedValue(false));
            new DoubleClickListener(){

                protected boolean onDoubleClick(MouseEvent event) {
                    list.navigateToSelectedValue(true);
                    return true;
                }
            }.installOn((Component)((Object)list));
            InstancesWithStackFrameView instancesWithStackFrame = new InstancesWithStackFrameView(session2, this.myInstancesTree, list, InstancesWindow.this.myClassName);
            this.add((Component)filteringPane, "North");
            this.add(instancesWithStackFrame.getComponent(), "Center");
            JComponent focusedComponent = this.myFilterConditionEditor.getEditorComponent();
            UiNotifyConnector.doWhenFirstShown((JComponent)focusedComponent, () -> IdeFocusManager.findInstanceByComponent((Component)focusedComponent).requestFocus((Component)focusedComponent, true));
        }

        public void dispose() {
            this.cancelFilteringTask();
            Disposer.dispose((Disposable)this.myInstancesTree);
        }

        private void updateInstances() {
            this.cancelFilteringTask();
            InstancesWindow.this.myDebugProcess.getManagerThread().schedule(new DebuggerContextCommandImpl(InstancesWindow.this.myDebugProcess.getDebuggerContext()){

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return PrioritizedTask.Priority.LOWEST;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                    MyInstancesView.this.myIsAndroidVM = AndroidUtil.isAndroidVM(InstancesWindow.this.myDebugProcess.getVirtualMachineProxy().getVirtualMachine());
                    int limit = MyInstancesView.this.myIsAndroidVM ? 30000 : 500000;
                    List<ObjectReference> instances = InstancesWindow.this.myInstancesProvider.getInstances(limit + 1);
                    EvaluationContextImpl evaluationContext = InstancesWindow.this.myDebugProcess.getDebuggerContext().createEvaluationContext();
                    if (instances.size() > limit) {
                        InstancesWindow.this.addWarningMessage(String.format("Not all instances will be loaded (only %d)", limit));
                        instances = instances.subList(0, limit);
                    }
                    if (evaluationContext != null) {
                        Object object = MyInstancesView.this.myFilteringTaskLock;
                        synchronized (object) {
                            MyInstancesView.this.myFilteringTask = new MyFilteringWorker(instances, MyInstancesView.this.myFilterConditionEditor.getExpression(), evaluationContext);
                            MyInstancesView.this.myFilteringTask.execute();
                        }
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancelFilteringTask() {
            if (this.myFilteringTask != null) {
                Object object = this.myFilteringTaskLock;
                synchronized (object) {
                    if (this.myFilteringTask != null) {
                        this.myFilteringTask.cancel();
                        this.myFilteringTask = null;
                    }
                }
            }
        }

        private XValueMarkers<?, ?> getValueMarkers(@NotNull XDebugSession session2) {
            return session2 instanceof XDebugSessionImpl ? ((XDebugSessionImpl)session2).getValueMarkers() : null;
        }

        private class MyFilteringWorker
        extends SwingWorker<Void, Void> {
            private final FilteringTask myTask;

            MyFilteringWorker(@NotNull List<ObjectReference> refs, @NotNull XExpression expression2, EvaluationContextImpl evaluationContext) {
                this.myTask = new FilteringTask(InstancesWindow.this.myClassName, InstancesWindow.this.myDebugProcess, expression2, refs, new MyFilteringCallback(evaluationContext));
            }

            @Override
            protected Void doInBackground() throws Exception {
                this.myTask.run();
                return null;
            }

            public void cancel() {
                this.myTask.cancel();
                super.cancel(false);
            }
        }

        private class MyFilteringCallback
        implements FilteringTaskCallback {
            private final ErrorsValueGroup myErrorsGroup = new ErrorsValueGroup();
            private final EvaluationContextImpl myEvaluationContext;
            private long myFilteringStartedTime;
            private int myProceedCount = 0;
            private int myMatchedCount = 0;
            private int myErrorsCount = 0;
            private long myLastTreeUpdatingTime;
            private long myLastProgressUpdatingTime;
            private XValueChildrenList myChildren = new XValueChildrenList();

            public MyFilteringCallback(EvaluationContextImpl evaluationContext) {
                this.myEvaluationContext = evaluationContext;
            }

            @Override
            public void started(int total) {
                this.myLastTreeUpdatingTime = this.myFilteringStartedTime = System.nanoTime();
                this.myLastProgressUpdatingTime = System.nanoTime();
                ApplicationManager.getApplication().invokeLater(() -> MyInstancesView.this.myProgress.start(total));
            }

            @Override
            @NotNull
            public FilteringTaskCallback.Action matched(@NotNull ObjectReference ref) {
                InstanceJavaValue val = new InstanceJavaValue(new InstanceValueDescriptor(InstancesWindow.this.myProject, ref), this.myEvaluationContext, MyInstancesView.this.myNodeManager);
                ++this.myMatchedCount;
                ++this.myProceedCount;
                this.myChildren.add((XNamedValue)val);
                this.updateProgress();
                this.updateTree();
                return this.myMatchedCount < 2000 ? FilteringTaskCallback.Action.CONTINUE : FilteringTaskCallback.Action.STOP;
            }

            @Override
            @NotNull
            public FilteringTaskCallback.Action notMatched(@NotNull ObjectReference ref) {
                ++this.myProceedCount;
                this.updateProgress();
                return FilteringTaskCallback.Action.CONTINUE;
            }

            @Override
            @NotNull
            public FilteringTaskCallback.Action error(@NotNull ObjectReference ref, @NotNull String description) {
                InstanceJavaValue val = new InstanceJavaValue(new InstanceValueDescriptor(InstancesWindow.this.myProject, ref), this.myEvaluationContext, MyInstancesView.this.myNodeManager);
                this.myErrorsGroup.addErrorValue(description, val);
                ++this.myProceedCount;
                ++this.myErrorsCount;
                this.updateProgress();
                return FilteringTaskCallback.Action.CONTINUE;
            }

            @Override
            public void completed(@NotNull FilteringResult reason) {
                if (!this.myErrorsGroup.isEmpty()) {
                    this.myChildren.addBottomGroup((XValueGroup)this.myErrorsGroup);
                }
                long duration = System.nanoTime() - this.myFilteringStartedTime;
                LOG.info(String.format("Filtering completed in %d ms for %d instances", TimeUnit.NANOSECONDS.toMillis(duration), this.myProceedCount));
                int proceed = this.myProceedCount;
                int matched = this.myMatchedCount;
                int errors = this.myErrorsCount;
                XValueChildrenList childrenList = this.myChildren;
                ApplicationManager.getApplication().invokeLater(() -> {
                    MyInstancesView.this.myProgress.updateProgress(proceed, matched, errors);
                    MyInstancesView.this.myInstancesTree.addChildren(childrenList, true);
                    MyInstancesView.this.myFilterButton.setEnabled(true);
                    MyInstancesView.this.myProgress.complete(reason);
                });
            }

            private void updateProgress() {
                long now = System.nanoTime();
                if (now - this.myLastProgressUpdatingTime > TimeUnit.MILLISECONDS.toNanos(17L)) {
                    int proceed = this.myProceedCount;
                    int matched = this.myMatchedCount;
                    int errors = this.myErrorsCount;
                    ApplicationManager.getApplication().invokeLater(() -> MyInstancesView.this.myProgress.updateProgress(proceed, matched, errors));
                    this.myLastProgressUpdatingTime = now;
                }
            }

            private void updateTree() {
                long now = System.nanoTime();
                int newChildrenCount = this.myChildren.size();
                if (newChildrenCount >= 50 || newChildrenCount > 0 && now - this.myLastTreeUpdatingTime > TimeUnit.SECONDS.toNanos(3L)) {
                    XValueChildrenList children2 = this.myChildren;
                    ApplicationManager.getApplication().invokeLater(() -> MyInstancesView.this.myInstancesTree.addChildren(children2, false));
                    this.myChildren = new XValueChildrenList();
                    this.myLastTreeUpdatingTime = System.nanoTime();
                }
            }
        }

        private class MyActionListener
        extends AnActionListener.Adapter {
            private final XValueMarkers<?, ?> myValueMarkers;

            private MyActionListener(XValueMarkers<?, ?> markers) {
                this.myValueMarkers = markers;
            }

            public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
                XValueNodeImpl selectedNode;
                if (dataContext.getData(PlatformDataKeys.CONTEXT_COMPONENT) == MyInstancesView.this.myInstancesTree && (this.isAddToWatchesAction(action) || this.isEvaluateExpressionAction(action)) && (selectedNode = XDebuggerTreeActionBase.getSelectedNode(dataContext)) != null) {
                    TreeNode currentNode = selectedNode;
                    while (!MyInstancesView.this.myInstancesTree.getRoot().equals(currentNode.getParent())) {
                        currentNode = currentNode.getParent();
                    }
                    XValue valueContainer = (XValue)currentNode.getValueContainer();
                    String expression2 = valueContainer.getEvaluationExpression();
                    if (expression2 != null) {
                        this.myValueMarkers.markValue(valueContainer, new ValueMarkup(expression2.replace("@", ""), (Color)new JBColor(0, 0), null));
                    }
                    ApplicationManager.getApplication().invokeLater(() -> MyInstancesView.this.myInstancesTree.rebuildTree(InstancesTree.RebuildPolicy.ONLY_UPDATE_LABELS));
                }
            }

            private boolean isAddToWatchesAction(AnAction action) {
                String className = action.getClass().getSimpleName();
                return action instanceof XDebuggerTreeActionBase && className.equals("XAddToWatchesAction");
            }

            private boolean isEvaluateExpressionAction(AnAction action) {
                String className = action.getClass().getSimpleName();
                return action instanceof XDebuggerActionBase && className.equals("EvaluateAction");
            }
        }

        private class MySessionListener
        implements XDebugSessionListener {
            private volatile XDebuggerTreeState myTreeState = null;

            private MySessionListener() {
            }

            public void sessionResumed() {
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.myTreeState = XDebuggerTreeState.saveState(MyInstancesView.this.myInstancesTree);
                    MyInstancesView.this.cancelFilteringTask();
                    MyInstancesView.this.myInstancesTree.setInfoMessage("The application is running");
                });
            }

            public void sessionPaused() {
                ApplicationManager.getApplication().invokeLater(() -> {
                    MyInstancesView.this.myProgress.setVisible(true);
                    MyInstancesView.this.myInstancesTree.rebuildTree(InstancesTree.RebuildPolicy.RELOAD_INSTANCES, this.myTreeState);
                });
            }
        }
    }
}

