/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.frame.XDebuggerFramesList;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class StackFrameList
extends XDebuggerFramesList {
    private static final MyOpenFilesState myEditorState = new MyOpenFilesState();
    private final DebugProcessImpl myDebugProcess;

    StackFrameList(DebugProcessImpl debugProcess) {
        super(debugProcess.getProject());
        this.myDebugProcess = debugProcess;
    }

    void setFrameItems(@NotNull List<StackFrameItem> items) {
        this.setFrameItems(items, null);
    }

    void setFrameItems(final @NotNull List<StackFrameItem> items, final Runnable onDone) {
        this.clear();
        if (!items.isEmpty()) {
            this.myDebugProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    boolean separator = false;
                    for (StackFrameItem frameInfo : items) {
                        if (frameInfo == null) {
                            separator = true;
                            continue;
                        }
                        StackFrameItem.CapturedStackFrame frame = frameInfo.createFrame(StackFrameList.this.myDebugProcess);
                        frame.setWithSeparator(separator);
                        DebuggerUIUtil.invokeLater(() -> StackFrameList.this.getModel().addElement(frame));
                        separator = false;
                    }
                    if (onDone != null) {
                        onDone.run();
                    }
                }
            });
        }
    }

    @Override
    protected void onFrameChanged(Object selectedValue) {
        this.navigateTo(selectedValue, false);
    }

    void navigateToSelectedValue(boolean focusOnEditor) {
        this.navigateTo(this.getSelectedValue(), focusOnEditor);
    }

    private void navigateTo(Object frame, boolean focusOnEditor) {
        if (frame instanceof XStackFrame) {
            this.navigateToFrame((XStackFrame)frame, focusOnEditor);
        }
    }

    private void navigateToFrame(@NotNull XStackFrame frame, boolean focusOnEditor) {
        XSourcePosition position = frame.getSourcePosition();
        if (position == null) {
            return;
        }
        VirtualFile file2 = position.getFile();
        int line = position.getLine();
        Project project2 = this.myDebugProcess.getProject();
        OpenFileHyperlinkInfo info = new OpenFileHyperlinkInfo(project2, file2, line);
        OpenFileDescriptor descriptor = info.getDescriptor();
        if (descriptor != null) {
            FileEditorManagerImpl manager = (FileEditorManagerImpl)FileEditorManager.getInstance((Project)project2);
            VirtualFile lastFile = StackFrameList.myEditorState.myLastOpenedFile;
            if (StackFrameList.myEditorState.myIsNeedToCloseLastOpenedFile && lastFile != null && manager.isFileOpen(lastFile) && !lastFile.equals(descriptor.getFile())) {
                manager.closeFile(StackFrameList.myEditorState.myLastOpenedFile, false, true);
            }
            descriptor.setScrollType(ScrollType.CENTER);
            descriptor.setUseCurrentWindow(true);
            if (lastFile == null || !lastFile.equals(descriptor.getFile())) {
                StackFrameList.myEditorState.myIsNeedToCloseLastOpenedFile = !manager.isFileOpen(descriptor.getFile());
            }
            descriptor.navigateInEditor(project2, focusOnEditor);
            FileEditor[] editors = manager.getEditors(descriptor.getFile());
            if (editors.length != 0) {
                StackFrameList.myEditorState.myLastOpenedFile = descriptor.getFile();
            }
        }
    }

    private static class MyOpenFilesState {
        VirtualFile myLastOpenedFile;
        boolean myIsNeedToCloseLastOpenedFile;

        private MyOpenFilesState() {
        }
    }
}

