/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.CommonBundle;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.OptionsDialog;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NotNull;

public class RunHotswapDialog
extends OptionsDialog {
    private final JPanel myPanel;
    private final ElementsChooser<SessionItem> myElementsChooser;
    private final boolean myDisplayHangWarning;

    public RunHotswapDialog(Project project2, List<DebuggerSession> sessions, boolean displayHangWarning) {
        super(project2);
        this.myDisplayHangWarning = displayHangWarning;
        this.myPanel = new JPanel(new BorderLayout());
        ArrayList<SessionItem> items = new ArrayList<SessionItem>(sessions.size());
        for (DebuggerSession session2 : sessions) {
            items.add(new SessionItem(session2));
        }
        items.sort(Comparator.comparing(debuggerSession -> debuggerSession.getSession().getSessionName()));
        this.myElementsChooser = new ElementsChooser(items, true);
        this.myPanel.setBorder(IdeBorderFactory.createEmptyBorder((int)10, (int)0, (int)5, (int)0));
        if (sessions.size() > 0) {
            this.myElementsChooser.selectElements(items.subList(0, 1));
        }
        this.myPanel.add(this.myElementsChooser, "Center");
        if (sessions.size() == 1) {
            this.setTitle(DebuggerBundle.message((String)"hotswap.dialog.title.with.session", (Object[])new Object[]{sessions.get(0).getSessionName()}));
            this.myPanel.setVisible(false);
        } else {
            this.setTitle(DebuggerBundle.message((String)"hotswap.dialog.title", (Object[])new Object[0]));
        }
        this.setButtonsAlignment(0);
        this.init();
    }

    protected boolean isToBeShown() {
        return "RunHotswapAsk".equals(DebuggerSettings.getInstance().RUN_HOTSWAP_AFTER_COMPILE);
    }

    protected void setToBeShown(boolean value2, boolean onOk) {
        DebuggerSettings.getInstance().RUN_HOTSWAP_AFTER_COMPILE = value2 ? "RunHotswapAsk" : (onOk ? "RunHotswapAlways" : "RunHotswapNever");
    }

    protected boolean shouldSaveOptionsOnCancel() {
        return true;
    }

    @NotNull
    protected Action[] createActions() {
        this.setOKButtonText(CommonBundle.getYesButtonText());
        this.setCancelButtonText(CommonBundle.getNoButtonText());
        return new Action[]{this.getOKAction(), this.getCancelAction()};
    }

    protected JComponent createNorthPanel() {
        JLabel label = new JLabel(DebuggerBundle.message((String)"hotswap.dialog.run.prompt", (Object[])new Object[0]));
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)label, "Center");
        Icon icon = UIUtil.getQuestionIcon();
        label.setIcon(icon);
        label.setIconTextGap(7);
        if (this.myDisplayHangWarning) {
            JLabel warningLabel = new JLabel("WARNING! " + DebuggerBundle.message((String)"hotswap.dialog.hang.warning", (Object[])new Object[0]));
            warningLabel.setUI((LabelUI)new MultiLineLabelUI());
            panel2.add((Component)warningLabel, "South");
        }
        return panel2;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public Collection<DebuggerSession> getSessionsToReload() {
        List<SessionItem> markedElements = this.myElementsChooser.getMarkedElements();
        ArrayList<DebuggerSession> sessions = new ArrayList<DebuggerSession>(markedElements.size());
        for (SessionItem item : markedElements) {
            sessions.add(item.getSession());
        }
        return sessions;
    }

    private static class SessionItem {
        private final DebuggerSession mySession;

        public SessionItem(DebuggerSession session2) {
            this.mySession = session2;
        }

        public DebuggerSession getSession() {
            return this.mySession;
        }

        public String toString() {
            return this.mySession.getSessionName();
        }
    }
}

