/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.InstanceFilter;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnsupportedExpressionException;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.LocatableEventRequestor;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.debugger.ui.breakpoints.FilteredRequestorImpl;
import com.intellij.debugger.ui.impl.watch.CompilingEvaluatorImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerHistoryManager;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VoidValue;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.EventRequest;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;

public abstract class Breakpoint<P extends JavaBreakpointProperties>
implements FilteredRequestor,
ClassPrepareRequestor {
    public static final Key<Breakpoint> DATA_KEY = Key.create((String)"JavaBreakpoint");
    private static final Key<Long> HIT_COUNTER = Key.create((String)"HIT_COUNTER");
    final XBreakpoint<P> myXBreakpoint;
    protected final Project myProject;
    @NonNls
    private static final String LOG_MESSAGE_OPTION_NAME = "LOG_MESSAGE";
    protected boolean myCachedVerifiedState = false;

    protected Breakpoint(@NotNull Project project2, XBreakpoint<P> xBreakpoint) {
        this.myProject = project2;
        this.myXBreakpoint = xBreakpoint;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    protected P getProperties() {
        return (P)((Object)((JavaBreakpointProperties)this.myXBreakpoint.getProperties()));
    }

    public XBreakpoint<P> getXBreakpoint() {
        return this.myXBreakpoint;
    }

    @Nullable
    public abstract PsiClass getPsiClass();

    public abstract void createRequest(DebugProcessImpl var1);

    static boolean shouldCreateRequest(Requestor requestor, XBreakpoint xBreakpoint, DebugProcessImpl debugProcess, boolean forPreparedClass) {
        return (Boolean)ReadAction.compute(() -> {
            JavaDebugProcess process2 = debugProcess.getXdebugProcess();
            return !(process2 == null || !debugProcess.isAttached() || xBreakpoint != null && !((XDebugSessionImpl)process2.getSession()).isBreakpointActive(xBreakpoint) || !forPreparedClass && !debugProcess.getRequestsManager().findRequests(requestor).isEmpty());
        });
    }

    protected final boolean shouldCreateRequest(DebugProcessImpl debugProcess, boolean forPreparedClass) {
        return Breakpoint.shouldCreateRequest(this, this.getXBreakpoint(), debugProcess, forPreparedClass);
    }

    protected final boolean shouldCreateRequest(DebugProcessImpl debugProcess) {
        return this.shouldCreateRequest(debugProcess, false);
    }

    public abstract void processClassPrepare(DebugProcess var1, ReferenceType var2);

    public abstract String getDisplayName();

    public String getShortName() {
        return this.getDisplayName();
    }

    @Nullable
    public String getClassName() {
        return null;
    }

    public void markVerified(boolean isVerified) {
        this.myCachedVerifiedState = isVerified;
    }

    public boolean isRemoveAfterHit() {
        return this.myXBreakpoint instanceof XLineBreakpoint && ((XLineBreakpoint)this.myXBreakpoint).isTemporary();
    }

    public void setRemoveAfterHit(boolean value2) {
        if (this.myXBreakpoint instanceof XLineBreakpoint) {
            ((XLineBreakpoint)this.myXBreakpoint).setTemporary(value2);
        }
    }

    @Nullable
    public String getShortClassName() {
        String className = this.getClassName();
        if (className == null) {
            return null;
        }
        int dotIndex = className.lastIndexOf(46);
        return dotIndex >= 0 && dotIndex + 1 < className.length() ? className.substring(dotIndex + 1) : className;
    }

    @Nullable
    public String getPackageName() {
        return null;
    }

    public abstract Icon getIcon();

    public abstract void reload();

    public abstract String getEventMessage(LocatableEvent var1);

    public abstract boolean isValid();

    public abstract Key<? extends Breakpoint> getCategory();

    protected void createOrWaitPrepare(DebugProcessImpl debugProcess, String classToBeLoaded) {
        debugProcess.getRequestsManager().callbackOnPrepareClasses((ClassPrepareRequestor)this, classToBeLoaded);
        debugProcess.getVirtualMachineProxy().classesByName(classToBeLoaded).stream().filter(ReferenceType::isPrepared).forEach(aList -> this.processClassPrepare(debugProcess, (ReferenceType)aList));
    }

    protected void createOrWaitPrepare(DebugProcessImpl debugProcess, @NotNull SourcePosition classPosition) {
        debugProcess.getRequestsManager().callbackOnPrepareClasses((ClassPrepareRequestor)this, classPosition);
        debugProcess.getPositionManager().getAllClasses(classPosition).stream().filter(ReferenceType::isPrepared).forEach(refType -> this.processClassPrepare(debugProcess, (ReferenceType)refType));
    }

    protected ObjectReference getThisObject(SuspendContextImpl context, LocatableEvent event) throws EvaluateException {
        StackFrameProxyImpl stackFrameProxy;
        ThreadReferenceProxyImpl thread = context.getThread();
        if (thread != null && (stackFrameProxy = thread.frame(0)) != null) {
            return stackFrameProxy.thisObject();
        }
        return null;
    }

    @Override
    public boolean processLocatableEvent(SuspendContextCommandImpl action, LocatableEvent event) throws LocatableEventRequestor.EventProcessingException {
        SuspendContextImpl context = action.getSuspendContext();
        if (!this.isValid()) {
            context.getDebugProcess().getRequestsManager().deleteRequest(this);
            return false;
        }
        String title = DebuggerBundle.message((String)"title.error.evaluating.breakpoint.condition", (Object[])new Object[0]);
        try {
            StackFrameProxyImpl frameProxy = context.getThread().frame(0);
            if (frameProxy == null) {
                return false;
            }
            EvaluationContextImpl evaluationContext = new EvaluationContextImpl(context, frameProxy, this.getThisObject(context, event));
            if (!this.evaluateCondition(evaluationContext, event)) {
                return false;
            }
            title = DebuggerBundle.message((String)"title.error.evaluating.breakpoint.action", (Object[])new Object[0]);
            this.runAction(evaluationContext, event);
        }
        catch (EvaluateException ex) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                System.out.println(ex.getMessage());
                return false;
            }
            throw new LocatableEventRequestor.EventProcessingException(title, ex.getMessage(), ex);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAction(EvaluationContextImpl context, LocatableEvent event) {
        DebugProcessImpl debugProcess = context.getDebugProcess();
        if (this.isLogEnabled() || this.isLogExpressionEnabled()) {
            StringBuilder buf = StringBuilderSpinAllocator.alloc();
            try {
                if (this.myXBreakpoint.isLogMessage()) {
                    buf.append(this.getEventMessage(event)).append("\n");
                }
                if (this.isLogExpressionEnabled()) {
                    if (!debugProcess.isAttached()) {
                        return;
                    }
                    TextWithImports logMessage = this.getLogMessage();
                    try {
                        SourcePosition position = ContextUtil.getSourcePosition((StackFrameContext)context);
                        PsiElement element = ContextUtil.getContextElement((StackFrameContext)context, position);
                        ExpressionEvaluator evaluator = DebuggerInvocationUtil.commitAndRunReadAction(this.myProject, () -> EvaluatorCache.cacheOrGet("LogMessageEvaluator", event.request(), element, logMessage, () -> Breakpoint.createExpressionEvaluator(this.myProject, element, position, logMessage, this::createLogMessageCodeFragment)));
                        Value eval = evaluator.evaluate((EvaluationContext)context);
                        buf.append(eval instanceof VoidValue ? "void" : DebuggerUtils.getValueAsString((EvaluationContext)context, (Value)eval));
                    }
                    catch (EvaluateException e) {
                        buf.append(DebuggerBundle.message((String)"error.unable.to.evaluate.expression", (Object[])new Object[0])).append(" \"").append(logMessage).append("\"").append(" : ").append(e.getMessage());
                    }
                    buf.append("\n");
                }
                if (buf.length() > 0) {
                    debugProcess.printToConsole(buf.toString());
                }
            }
            finally {
                StringBuilderSpinAllocator.dispose((StringBuilder)buf);
            }
        }
        if (this.isRemoveAfterHit()) {
            this.handleTemporaryBreakpointHit(debugProcess);
        }
    }

    private boolean hasObjectID(long id) {
        return Arrays.stream(this.getInstanceFilters()).anyMatch(instanceFilter -> instanceFilter.getId() == id);
    }

    public boolean evaluateCondition(EvaluationContextImpl context, LocatableEvent event) throws EvaluateException {
        ObjectReference reference;
        Value value2;
        DebugProcessImpl debugProcess = context.getDebugProcess();
        if (this.isCountFilterEnabled() && !this.isConditionEnabled()) {
            debugProcess.getVirtualMachineProxy().suspend();
            debugProcess.getRequestsManager().deleteRequest(this);
            this.createRequest(debugProcess);
            debugProcess.getVirtualMachineProxy().resume();
        }
        if (this.isInstanceFiltersEnabled() && (value2 = context.getThisObject()) != null && !this.hasObjectID((reference = (ObjectReference)value2).uniqueID())) {
            return false;
        }
        if (this.isClassFiltersEnabled() && !Breakpoint.typeMatchesClassFilters(this.calculateEventClass(context, event), this.getClassFilters(), this.getClassExclusionFilters())) {
            return false;
        }
        if (this.isConditionEnabled()) {
            ThreeState result2;
            Location location;
            TextWithImports condition2 = this.getCondition();
            if (condition2.isEmpty()) {
                return true;
            }
            StackFrameProxyImpl frame = context.getFrameProxy();
            if (frame != null && (location = frame.location()) != null && (result2 = debugProcess.getPositionManager().evaluateCondition(context, frame, location, condition2.getText())) != ThreeState.UNSURE) {
                return result2 == ThreeState.YES;
            }
            try {
                SourcePosition contextSourcePosition = ContextUtil.getSourcePosition((StackFrameContext)context);
                ExpressionEvaluator evaluator = DebuggerInvocationUtil.commitAndRunReadAction(this.myProject, () -> {
                    PsiElement contextElement = ContextUtil.getContextElement(contextSourcePosition);
                    PsiElement contextPsiElement = contextElement != null ? contextElement : this.getEvaluationElement();
                    return EvaluatorCache.cacheOrGet("ConditionEvaluator", event.request(), contextPsiElement, condition2, () -> Breakpoint.createExpressionEvaluator(this.myProject, contextPsiElement, contextSourcePosition, condition2, this::createConditionCodeFragment));
                });
                if (!DebuggerUtilsEx.evaluateBoolean(evaluator, context)) {
                    return false;
                }
            }
            catch (EvaluateException ex) {
                if (ex.getCause() instanceof VMDisconnectedException) {
                    return false;
                }
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"error.failed.evaluating.breakpoint.condition", (Object[])new Object[]{condition2, ex.getMessage()}));
            }
        }
        if (this.isCountFilterEnabled() && this.isConditionEnabled()) {
            Long hitCount = (Long)ObjectUtils.notNull((Object)((Long)event.request().getProperty(HIT_COUNTER)), (Object)0L) + 1L;
            event.request().putProperty(HIT_COUNTER, hitCount);
            return hitCount % (long)this.getCountFilter() == 0L;
        }
        return true;
    }

    private static ExpressionEvaluator createExpressionEvaluator(Project project2, PsiElement contextPsiElement, SourcePosition contextSourcePosition, TextWithImports text, Function<PsiElement, PsiCodeFragment> fragmentFactory) throws EvaluateException {
        try {
            return EvaluatorBuilderImpl.build(text, contextPsiElement, contextSourcePosition, project2);
        }
        catch (UnsupportedExpressionException ex) {
            ExpressionEvaluator eval = CompilingEvaluatorImpl.create(project2, contextPsiElement, fragmentFactory);
            if (eval != null) {
                return eval;
            }
            throw ex;
        }
    }

    private PsiCodeFragment createConditionCodeFragment(PsiElement context) {
        return Breakpoint.createCodeFragment(this.myProject, this.getCondition(), context);
    }

    private PsiCodeFragment createLogMessageCodeFragment(PsiElement context) {
        return Breakpoint.createCodeFragment(this.myProject, this.getLogMessage(), context);
    }

    private static PsiCodeFragment createCodeFragment(Project project2, TextWithImports text, PsiElement context) {
        return DebuggerUtilsEx.findAppropriateCodeFragmentFactory(text, context).createCodeFragment(text, context, project2);
    }

    protected String calculateEventClass(EvaluationContextImpl context, LocatableEvent event) throws EvaluateException {
        return event.location().declaringType().name();
    }

    protected static boolean typeMatchesClassFilters(@Nullable String typeName, ClassFilter[] includeFilters, ClassFilter[] exludeFilters) {
        if (typeName == null) {
            return true;
        }
        boolean matches = false;
        boolean hasEnabled = false;
        for (ClassFilter classFilter2 : includeFilters) {
            if (!classFilter2.isEnabled()) continue;
            hasEnabled = true;
            if (!classFilter2.matches(typeName)) continue;
            matches = true;
            break;
        }
        if (hasEnabled && !matches) {
            return false;
        }
        return Arrays.stream(exludeFilters).noneMatch(classFilter -> classFilter.isEnabled() && classFilter.matches(typeName));
    }

    private void handleTemporaryBreakpointHit(final DebugProcessImpl debugProcess) {
        debugProcess.getRequestsManager().deleteRequest(this);
        debugProcess.addDebugProcessListener(new DebugProcessListener(){

            public void resumed(SuspendContext suspendContext) {
                this.removeBreakpoint();
            }

            public void processDetached(DebugProcess process2, boolean closedByUser) {
                this.removeBreakpoint();
            }

            private void removeBreakpoint() {
                AppUIUtil.invokeOnEdt(() -> DebuggerManagerEx.getInstanceEx(Breakpoint.this.myProject).getBreakpointManager().removeBreakpoint(Breakpoint.this));
                debugProcess.removeDebugProcessListener(this);
            }
        });
    }

    public void updateUI() {
    }

    public void readExternal(Element parentNode) throws InvalidDataException {
        FilteredRequestorImpl requestor = new FilteredRequestorImpl(this.myProject);
        requestor.readTo(parentNode, this);
        try {
            this.setEnabled(Boolean.valueOf(JDOMExternalizerUtil.readField((Element)parentNode, (String)"ENABLED")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.setLogEnabled(Boolean.valueOf(JDOMExternalizerUtil.readField((Element)parentNode, (String)"LOG_ENABLED")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String logMessage = JDOMExternalizerUtil.readField((Element)parentNode, (String)LOG_MESSAGE_OPTION_NAME);
            if (logMessage != null && !logMessage.isEmpty()) {
                XExpressionImpl expression2 = XExpressionImpl.fromText(logMessage);
                XDebuggerHistoryManager.getInstance(this.myProject).addRecentExpression("breakpointLogExpression", expression2);
                this.myXBreakpoint.setLogExpressionObject((XExpression)expression2);
                ((XBreakpointBase)this.myXBreakpoint).setLogExpressionEnabled(Boolean.valueOf(JDOMExternalizerUtil.readField((Element)parentNode, (String)"LOG_EXPRESSION_ENABLED")));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.setRemoveAfterHit(Boolean.valueOf(JDOMExternalizerUtil.readField((Element)parentNode, (String)"REMOVE_AFTER_HIT")));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    public abstract PsiElement getEvaluationElement();

    protected TextWithImports getLogMessage() {
        return TextWithImportsImpl.fromXExpression(this.myXBreakpoint.getLogExpressionObject());
    }

    protected TextWithImports getCondition() {
        return TextWithImportsImpl.fromXExpression(this.myXBreakpoint.getConditionExpression());
    }

    public boolean isEnabled() {
        return this.myXBreakpoint.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.myXBreakpoint.setEnabled(enabled);
    }

    protected boolean isLogEnabled() {
        return this.myXBreakpoint.isLogMessage();
    }

    public void setLogEnabled(boolean logEnabled) {
        this.myXBreakpoint.setLogMessage(logEnabled);
    }

    protected boolean isLogExpressionEnabled() {
        if (XDebuggerUtilImpl.isEmptyExpression(this.myXBreakpoint.getLogExpressionObject())) {
            return false;
        }
        return !this.getLogMessage().isEmpty();
    }

    @Override
    public boolean isCountFilterEnabled() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).isCOUNT_FILTER_ENABLED() && this.getCountFilter() > 0;
    }

    public void setCountFilterEnabled(boolean enabled) {
        if (((JavaBreakpointProperties)((Object)this.getProperties())).setCOUNT_FILTER_ENABLED(enabled)) {
            this.fireBreakpointChanged();
        }
    }

    @Override
    public int getCountFilter() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).getCOUNT_FILTER();
    }

    public void setCountFilter(int filter) {
        if (((JavaBreakpointProperties)((Object)this.getProperties())).setCOUNT_FILTER(filter)) {
            this.fireBreakpointChanged();
        }
    }

    @Override
    public boolean isClassFiltersEnabled() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).isCLASS_FILTERS_ENABLED();
    }

    public void setClassFiltersEnabled(boolean enabled) {
        if (((JavaBreakpointProperties)((Object)this.getProperties())).setCLASS_FILTERS_ENABLED(enabled)) {
            this.fireBreakpointChanged();
        }
    }

    @Override
    public ClassFilter[] getClassFilters() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).getClassFilters();
    }

    public void setClassFilters(ClassFilter[] filters) {
        if (((JavaBreakpointProperties)((Object)this.getProperties())).setClassFilters(filters)) {
            this.fireBreakpointChanged();
        }
    }

    @Override
    public ClassFilter[] getClassExclusionFilters() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).getClassExclusionFilters();
    }

    public void setClassExclusionFilters(ClassFilter[] filters) {
        if (((JavaBreakpointProperties)((Object)this.getProperties())).setClassExclusionFilters(filters)) {
            this.fireBreakpointChanged();
        }
    }

    @Override
    public boolean isInstanceFiltersEnabled() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).isINSTANCE_FILTERS_ENABLED();
    }

    public void setInstanceFiltersEnabled(boolean enabled) {
        if (((JavaBreakpointProperties)((Object)this.getProperties())).setINSTANCE_FILTERS_ENABLED(enabled)) {
            this.fireBreakpointChanged();
        }
    }

    @Override
    public InstanceFilter[] getInstanceFilters() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).getInstanceFilters();
    }

    public void setInstanceFilters(InstanceFilter[] filters) {
        if (((JavaBreakpointProperties)((Object)this.getProperties())).setInstanceFilters(filters)) {
            this.fireBreakpointChanged();
        }
    }

    private static String getSuspendPolicy(XBreakpoint breakpoint) {
        switch (breakpoint.getSuspendPolicy()) {
            case ALL: {
                return "SuspendAll";
            }
            case THREAD: {
                return "SuspendThread";
            }
            case NONE: {
                return "SuspendNone";
            }
        }
        throw new IllegalArgumentException("unknown suspend policy");
    }

    static SuspendPolicy transformSuspendPolicy(String policy) {
        if ("SuspendAll".equals(policy)) {
            return SuspendPolicy.ALL;
        }
        if ("SuspendThread".equals(policy)) {
            return SuspendPolicy.THREAD;
        }
        if ("SuspendNone".equals(policy)) {
            return SuspendPolicy.NONE;
        }
        throw new IllegalArgumentException("unknown suspend policy");
    }

    protected boolean isSuspend() {
        return this.myXBreakpoint.getSuspendPolicy() != SuspendPolicy.NONE;
    }

    @Override
    public String getSuspendPolicy() {
        return Breakpoint.getSuspendPolicy(this.myXBreakpoint);
    }

    public void setSuspendPolicy(String policy) {
        this.myXBreakpoint.setSuspendPolicy(Breakpoint.transformSuspendPolicy(policy));
    }

    @Override
    public boolean isConditionEnabled() {
        XExpression condition2 = this.myXBreakpoint.getConditionExpression();
        if (XDebuggerUtilImpl.isEmptyExpression(condition2)) {
            return false;
        }
        return !this.getCondition().isEmpty();
    }

    public void setCondition(@Nullable TextWithImports condition2) {
        this.myXBreakpoint.setConditionExpression(TextWithImportsImpl.toXExpression(condition2));
    }

    public void addInstanceFilter(long l) {
        ((JavaBreakpointProperties)((Object)this.getProperties())).addInstanceFilter(l);
    }

    protected void fireBreakpointChanged() {
        ((XBreakpointBase)this.myXBreakpoint).fireBreakpointChanged();
    }

    private static class EvaluatorCache {
        private final PsiElement myContext;
        private final TextWithImports myTextWithImports;
        private final ExpressionEvaluator myEvaluator;

        private EvaluatorCache(PsiElement context, TextWithImports textWithImports, ExpressionEvaluator evaluator) {
            this.myContext = context;
            this.myTextWithImports = textWithImports;
            this.myEvaluator = evaluator;
        }

        @Nullable
        static ExpressionEvaluator cacheOrGet(String propertyName, EventRequest request, PsiElement context, TextWithImports text, EvaluatingComputable<ExpressionEvaluator> supplier) throws EvaluateException {
            EvaluatorCache cache2 = (EvaluatorCache)request.getProperty(propertyName);
            if (cache2 != null && Objects.equals(cache2.myContext, context) && Objects.equals(cache2.myTextWithImports, text)) {
                return cache2.myEvaluator;
            }
            ExpressionEvaluator evaluator = supplier.compute();
            request.putProperty(propertyName, new EvaluatorCache(context, text, evaluator));
            return evaluator;
        }
    }
}

