/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiExpression;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Method;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;

public class MethodReturnValueDescriptorImpl
extends ValueDescriptorImpl {
    private final Method myMethod;

    public MethodReturnValueDescriptorImpl(Project project2, @NotNull Method method2, Value value2) {
        super(project2, value2);
        this.myMethod = method2;
    }

    @Override
    public Value calcValue(EvaluationContextImpl evaluationContext) throws EvaluateException {
        return this.getValue();
    }

    @NotNull
    public Method getMethod() {
        return this.myMethod;
    }

    @Override
    public String getName() {
        return NodeRendererSettings.getInstance().getClassRenderer().renderTypeName(this.myMethod.declaringType().name()) + "." + DebuggerUtilsEx.methodNameWithArguments(this.myMethod);
    }

    @Override
    public Type getType() {
        Type type2 = super.getType();
        if (type2 == null) {
            try {
                type2 = this.myMethod.returnType();
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                // empty catch block
            }
        }
        return type2;
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext context) throws EvaluateException {
        return null;
    }

    @Override
    public boolean canSetValue() {
        return false;
    }
}

