/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.HexRenderer;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiExpression;
import com.sun.jdi.CharValue;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VoidType;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class PrimitiveRenderer
extends NodeRendererImpl {
    @NonNls
    public static final String UNIQUE_ID = "PrimitiveRenderer";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.tree.render.PrimitiveRenderer");
    public boolean SHOW_HEX_VALUE = false;

    public PrimitiveRenderer() {
        super("Primitive");
    }

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    public void setName(String text) {
    }

    @Override
    public final boolean isEnabled() {
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public boolean isApplicable(Type type2) {
        return type2 == null || type2 instanceof PrimitiveType || type2 instanceof VoidType;
    }

    @Override
    public String calcLabel(ValueDescriptor valueDescriptor, EvaluationContext evaluationContext, DescriptorLabelListener labelListener) {
        Value value2 = valueDescriptor.getValue();
        if (value2 == null) {
            return "null";
        }
        if (value2 instanceof PrimitiveValue) {
            if (value2 instanceof CharValue) {
                StringBuilder buf = new StringBuilder();
                PrimitiveRenderer.appendCharValue((CharValue)value2, buf);
                if (this.SHOW_HEX_VALUE) {
                    PrimitiveRenderer.appendHexValue((CharValue)value2, buf);
                } else {
                    buf.append(' ').append(((PrimitiveValue)value2).longValue());
                }
                return buf.toString();
            }
            if (this.SHOW_HEX_VALUE) {
                StringBuilder buf = new StringBuilder();
                buf.append(value2.toString());
                PrimitiveRenderer.appendHexValue((PrimitiveValue)value2, buf);
                return buf.toString();
            }
            return value2.toString();
        }
        return DebuggerBundle.message((String)"label.undefined", (Object[])new Object[0]);
    }

    static void appendCharValue(CharValue value2, StringBuilder buf) {
        buf.append('\'');
        String s = value2.toString();
        StringUtil.escapeStringCharacters((int)s.length(), (String)s, (String)"'", (StringBuilder)buf);
        buf.append('\'');
    }

    private static void appendHexValue(PrimitiveValue value2, StringBuilder buf) {
        if (NodeRendererSettings.getInstance().getHexRenderer().isApplicable(value2.type())) {
            buf.append(" (");
            HexRenderer.appendHexValue(value2, buf);
            buf.append(')');
        }
    }

    @Override
    public void buildChildren(Value value2, ChildrenBuilder builder, EvaluationContext evaluationContext) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
    }

    public PsiExpression getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) {
        LOG.assertTrue(false);
        return null;
    }

    @Override
    public boolean isExpandable(Value value2, EvaluationContext evaluationContext, NodeDescriptor parentDescriptor) {
        return false;
    }

    public boolean isShowHexValue() {
        return this.SHOW_HEX_VALUE;
    }

    public void setShowHexValue(boolean show) {
        this.SHOW_HEX_VALUE = show;
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }
}

