/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.util.PlatformIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractComboBoxAction<T>
extends ComboBoxAction {
    protected static final Icon CHECKED = PlatformIcons.CHECK_ICON;
    protected List<T> myItems = Collections.emptyList();
    private T mySelection;
    private Presentation myPresentation;
    private boolean myShowDisabledActions;

    public void setItems(List<T> items, @Nullable T selection) {
        this.myItems = items;
        this.setSelection(selection);
    }

    public T getSelection() {
        return this.mySelection;
    }

    public void setSelection(T selection) {
        this.mySelection = selection;
        if (selection == null && !this.myItems.isEmpty()) {
            this.mySelection = this.myItems.get(0);
        }
        this.update();
    }

    public void clearSelection() {
        this.mySelection = null;
        this.update();
    }

    public void showDisabledActions(boolean value2) {
        this.myShowDisabledActions = value2;
    }

    public JComponent createCustomComponent(Presentation presentation) {
        this.myPresentation = presentation;
        this.update();
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.add((Component)this.createComboBoxButton(presentation), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 1, 2, 1), 0, 0));
        return panel2;
    }

    protected ComboBoxAction.ComboBoxButton createComboBoxButton(Presentation presentation) {
        if (this.myShowDisabledActions) {
            return new ComboBoxAction.ComboBoxButton(presentation){

                protected JBPopup createPopup(Runnable onDispose) {
                    ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)AbstractComboBoxAction.this.createPopupActionGroup((JComponent)((Object)this)), this.getDataContext(), true, onDispose, AbstractComboBoxAction.this.getMaxRows());
                    popup.setMinimumSize(new Dimension(AbstractComboBoxAction.this.getMinWidth(), AbstractComboBoxAction.this.getMinHeight()));
                    return popup;
                }
            };
        }
        return super.createComboBoxButton(presentation);
    }

    public void update() {
        this.update(this.mySelection, this.myPresentation == null ? this.getTemplatePresentation() : this.myPresentation, false);
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        for (final T item : this.myItems) {
            if (this.addSeparator(actionGroup, item)) continue;
            AnAction action = new AnAction(){

                public void actionPerformed(AnActionEvent e) {
                    if (AbstractComboBoxAction.this.mySelection != item && AbstractComboBoxAction.this.selectionChanged(item)) {
                        AbstractComboBoxAction.this.mySelection = item;
                        AbstractComboBoxAction.this.update(item, AbstractComboBoxAction.this.myPresentation, false);
                    }
                }
            };
            actionGroup.add(action);
            Presentation presentation = action.getTemplatePresentation();
            presentation.setIcon(this.mySelection == item ? CHECKED : null);
            this.update(item, presentation, true);
        }
        return actionGroup;
    }

    protected boolean addSeparator(DefaultActionGroup actionGroup, T item) {
        return false;
    }

    protected abstract void update(T var1, Presentation var2, boolean var3);

    protected abstract boolean selectionChanged(T var1);
}

