/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.componentTree;

import com.intellij.designer.clipboard.SimpleTransferable;
import com.intellij.designer.componentTree.ComponentTree;
import com.intellij.designer.componentTree.TreeTransfer;
import com.intellij.designer.designSurface.ComponentTargetFilter;
import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.tools.CreationTool;
import com.intellij.designer.designSurface.tools.ToolProvider;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadComponentVisitor;
import com.intellij.designer.model.RadLayout;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.designer.utils.Cursors;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.ArrayUtil;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;

public class TreeDropListener
extends DropTargetAdapter {
    private final EditableArea myArea;
    private final ToolProvider myToolProvider;
    private final Class[] myDragTargets;
    private final OperationContext myContext = new OperationContext();
    private DropTargetDragEvent myEvent;
    private EditOperation myTargetOperation;
    private RadComponent myTarget;
    private boolean myExecuteEnabled;
    private boolean myShowFeedback;
    private static final Cursor myDragCursor = Cursors.getMoveCursor();

    public TreeDropListener(ComponentTree tree, EditableArea area, ToolProvider provider2) {
        this((JComponent)((Object)tree), area, provider2, TreeDropListener.class, PaletteItem.class);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            tree.setDragEnabled(true);
            tree.setTransferHandler(new TreeTransfer(TreeDropListener.class));
        }
    }

    public TreeDropListener(JComponent component, EditableArea area, ToolProvider provider2, Class ... dragTargets) {
        this.myArea = area;
        this.myContext.setArea(area);
        this.myToolProvider = provider2;
        this.myDragTargets = dragTargets;
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            component.setDropTarget(new DropTarget(component, this));
        }
    }

    @Override
    public void dragExit(DropTargetEvent event) {
        this.eraseFeedback();
        this.clearState(false);
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
        this.myEvent = event;
        this.updateContext();
        this.updateTargetUnderMouse();
        this.updateCommand();
        this.showFeedback();
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        event.acceptDrop(event.getDropAction());
        this.eraseFeedback();
        this.executeCommand();
        this.clearState(true);
        event.dropComplete(true);
    }

    private void showFeedback() {
        if (this.myTargetOperation != null) {
            this.myTargetOperation.showFeedback();
        }
        this.myShowFeedback = true;
    }

    private void eraseFeedback() {
        if (this.myShowFeedback) {
            this.myShowFeedback = false;
            if (this.myTargetOperation != null) {
                this.myTargetOperation.eraseFeedback();
            }
        }
    }

    private void updateContext() {
        this.myContext.setLocation(this.getLocation());
        if (this.myContext.getComponents() == null) {
            if (!ArrayUtil.contains((Object)SimpleTransferable.getData(this.myEvent.getTransferable(), Class.class), (Object[])this.myDragTargets)) {
                this.myContext.setComponents(Collections.emptyList());
                return;
            }
            if (this.myToolProvider.getActiveTool() instanceof CreationTool) {
                this.myContext.setType("create_children");
                CreationTool tool = (CreationTool)this.myToolProvider.getActiveTool();
                try {
                    this.myContext.setComponents(Collections.singletonList(tool.getFactory().create()));
                }
                catch (Throwable e) {
                    this.myContext.setComponents(Collections.emptyList());
                    this.myToolProvider.loadDefaultTool();
                }
                return;
            }
            List<RadComponent> components = RadComponent.getPureSelection(this.myArea.getSelection());
            RadComponent parent = null;
            for (RadComponent component : components) {
                if (parent == null) {
                    parent = component.getParent();
                    continue;
                }
                if (parent == component.getParent()) continue;
                components = Collections.emptyList();
                break;
            }
            this.myContext.setComponents(components);
            this.myContext.resetMoveAddEnabled();
            for (RadComponent component : components) {
                component.processDropOperation(this.myContext);
            }
        }
    }

    private void updateTargetUnderMouse() {
        if (this.myContext.getComponents().isEmpty()) {
            return;
        }
        final ArrayList<RadComponent> excludeComponents = new ArrayList<RadComponent>(this.myContext.getComponents());
        if (!this.myContext.isCreate()) {
            for (RadComponent component : this.myContext.getComponents()) {
                component.accept(new RadComponentVisitor(){

                    @Override
                    public void endVisit(RadComponent component) {
                        excludeComponents.add(component);
                    }
                }, true);
            }
        }
        final EditOperation[] operation = new EditOperation[1];
        ComponentTargetFilter filter = new ComponentTargetFilter(){

            @Override
            public boolean preFilter(RadComponent component) {
                return TreeDropListener.this.myContext.isCreate() || !excludeComponents.contains(component);
            }

            @Override
            public boolean resultFilter(RadComponent target) {
                if (!TreeDropListener.this.myContext.isCreate()) {
                    if (TreeDropListener.this.myContext.getComponents().get(0).getParent() == target) {
                        TreeDropListener.this.myContext.setType("move_children");
                    } else {
                        TreeDropListener.this.myContext.setType("add_children");
                    }
                }
                if (TreeDropListener.this.myTarget == target) {
                    return true;
                }
                RadLayout layout = target.getLayout();
                if (layout != null) {
                    operation[0] = layout.processChildOperation(TreeDropListener.this.myContext);
                }
                return operation[0] != null;
            }
        };
        Point location = this.getLocation();
        RadComponent target = this.myArea.findTarget(location.x, location.y, filter);
        if (target != this.myTarget) {
            if (this.myTargetOperation != null) {
                this.eraseFeedback();
            }
            this.myTarget = target;
            this.myTargetOperation = operation[0];
        }
        if (target == null) {
            if (!this.myContext.isCreate()) {
                this.myContext.setType(null);
            }
        } else {
            this.myTargetOperation.setComponents(this.myContext.getComponents());
        }
    }

    private Point getLocation() {
        return this.myEvent.getLocation();
    }

    private void updateCommand() {
        if (this.myTargetOperation != null) {
            if (this.myContext.isMove()) {
                this.setExecuteEnabled(this.myContext.isMoveEnabled() && this.myTargetOperation.canExecute());
            } else if (this.myContext.isAdd()) {
                this.setExecuteEnabled(this.myContext.isAddEnabled() && this.myTargetOperation.canExecute());
            } else if (this.myContext.isCreate()) {
                this.setExecuteEnabled(this.myTargetOperation.canExecute());
            } else {
                this.setExecuteEnabled(false);
            }
        } else {
            this.setExecuteEnabled(false);
        }
    }

    private void setExecuteEnabled(boolean enabled) {
        this.myExecuteEnabled = enabled;
        if (enabled) {
            this.myEvent.acceptDrag(this.myEvent.getDropAction());
            this.myArea.setCursor(this.myContext.isCreate() ? Cursors.getCopyCursor() : myDragCursor);
        } else {
            this.myEvent.rejectDrag();
            this.myArea.setCursor(Cursors.getSystemNoCursor());
        }
    }

    private void executeCommand() {
        if (this.myExecuteEnabled) {
            this.myToolProvider.execute(Collections.singletonList(this.myTargetOperation), this.myContext.getMessage());
            if (this.myContext.isCreate()) {
                this.myArea.setSelection(this.myContext.getComponents());
            }
        }
    }

    private void clearState(boolean full) {
        this.myContext.setComponents(null);
        this.myEvent = null;
        this.myTargetOperation = null;
        this.myTarget = null;
        this.myExecuteEnabled = false;
        if (full || !this.myContext.isCreate()) {
            this.myContext.setType(null);
            this.myToolProvider.loadDefaultTool();
        }
        this.myArea.setCursor(null);
    }
}

