/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface;

import com.intellij.designer.DesignerBundle;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.model.RadComponent;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class OperationContext {
    public static final String MOVE = "move_children";
    public static final String ADD = "add_children";
    public static final String CREATE = "create_children";
    public static final String PASTE = "paste_children";
    private Object myType;
    private EditableArea myArea;
    private RadComponent myContainer;
    private List<RadComponent> myComponents;
    private InputEvent myInputEvent;
    private int myModifiers;
    private Point myLocation;
    private Point myMoveDelta;
    private Dimension mySizeDelta;
    private int myResizeDirection;
    private boolean myMoveEnabled = true;
    private boolean myAddEnabled = true;

    public OperationContext() {
    }

    public OperationContext(Object type2) {
        this.myType = type2;
    }

    public Object getType() {
        return this.myType;
    }

    public void setType(@Nullable Object type2) {
        this.myType = type2;
    }

    public String getMessage() {
        return DesignerBundle.message(this.myType == null ? "command.tool_operation" : this.myType.toString(), new Object[0]);
    }

    public boolean is(Object type2) {
        if (this.myType == type2) {
            return true;
        }
        if (this.myType != null) {
            return this.myType.equals(type2);
        }
        return false;
    }

    public boolean isMove() {
        return this.is(MOVE);
    }

    public boolean isAdd() {
        return this.is(ADD);
    }

    public boolean isCreate() {
        return this.is(CREATE);
    }

    public boolean isPaste() {
        return this.is(PASTE);
    }

    public boolean isTree() {
        return this.myArea.isTree();
    }

    public EditableArea getArea() {
        return this.myArea;
    }

    public void setArea(EditableArea area) {
        this.myArea = area;
    }

    public RadComponent getContainer() {
        return this.myContainer;
    }

    public void setContainer(RadComponent container) {
        this.myContainer = container;
    }

    public List<RadComponent> getComponents() {
        return this.myComponents;
    }

    public void setComponents(@Nullable List<RadComponent> components) {
        this.myComponents = components;
    }

    public boolean isMoveEnabled() {
        return this.myMoveEnabled;
    }

    public void resetMoveAddEnabled() {
        this.myMoveEnabled = true;
        this.myAddEnabled = true;
    }

    public void setMoveEnabled(boolean enabled) {
        this.myMoveEnabled &= enabled;
    }

    public void setAddEnabled(boolean enabled) {
        this.myAddEnabled &= enabled;
    }

    public boolean isAddEnabled() {
        return this.myAddEnabled;
    }

    public InputEvent getInputEvent() {
        return this.myInputEvent;
    }

    public void setInputEvent(InputEvent inputEvent) {
        this.myInputEvent = inputEvent;
    }

    public int getModifiers() {
        return this.myModifiers;
    }

    public void setModifiers(int modifiers) {
        this.myModifiers = modifiers;
    }

    public Point getLocation() {
        return this.myLocation;
    }

    public void setLocation(Point location) {
        this.myLocation = location;
    }

    public Point getMoveDelta() {
        return this.myMoveDelta;
    }

    public void setMoveDelta(Point moveDelta) {
        this.myMoveDelta = moveDelta;
    }

    public Dimension getSizeDelta() {
        return this.mySizeDelta;
    }

    public void setSizeDelta(Dimension sizeDelta) {
        this.mySizeDelta = sizeDelta;
    }

    public Rectangle getTransformedRectangle(Rectangle r) {
        return new Rectangle(r.x + this.myMoveDelta.x, r.y + this.myMoveDelta.y, r.width + this.mySizeDelta.width, r.height + this.mySizeDelta.height);
    }

    public int getResizeDirection() {
        return this.myResizeDirection;
    }

    public void setResizeDirection(int resizeDirection) {
        this.myResizeDirection = resizeDirection;
    }
}

