/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.tools;

import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.ZoomType;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.designSurface.tools.MarqueeTracker;
import com.intellij.designer.designSurface.tools.ResizeTracker;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.propertyTable.InplaceContext;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.application.ApplicationManager;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class SelectionTool
extends InputTool {
    private InputTool myTracker;

    @Override
    public void deactivate() {
        this.deactivateTracker();
        super.deactivate();
    }

    @Override
    public void refreshCursor() {
        if (this.myTracker == null) {
            super.refreshCursor();
        }
    }

    @Override
    protected void handleButtonDown(int button) {
        if (this.myState == 1) {
            InputTool tracker;
            this.myState = 2;
            this.deactivateTracker();
            if (this.handleTracker()) {
                return;
            }
            if (!this.myArea.isTree() && (tracker = this.myArea.findTargetTool(this.myCurrentScreenX, this.myCurrentScreenY)) != null) {
                this.setTracker(tracker);
                if (tracker instanceof ResizeTracker) {
                    this.myArea.showSelection(false);
                }
                return;
            }
            RadComponent component = this.myArea.findTarget(this.myCurrentScreenX, this.myCurrentScreenY, null);
            if (component == null || component.isBackground()) {
                if (!this.myArea.isTree()) {
                    MarqueeTracker tracker2 = new MarqueeTracker();
                    tracker2.setSelectBackground(component != null && component.isBackground());
                    this.setTracker(tracker2);
                }
            } else {
                Point location = component.convertPoint(this.myArea.getNativeComponent(), this.myCurrentScreenX, this.myCurrentScreenY);
                this.setTracker(component.getDragTracker(location, this.myInputEvent, this.myArea.isTree()));
            }
        }
    }

    protected boolean handleTracker() {
        if (!this.myArea.isTree() && this.myInputEvent.isAltDown()) {
            this.setTracker(new MarqueeTracker());
            return true;
        }
        return false;
    }

    @Override
    protected void handleButtonUp(int button) {
        this.myState = 1;
        this.setTracker(null);
        this.handleMove();
    }

    @Override
    protected void handlePopup() {
        ActionManager actionManager = ActionManager.getInstance();
        ActionPopupMenu popupMenu = actionManager.createActionPopupMenu(this.myArea.getPopupPlace(), this.myArea.getPopupActions());
        MouseEvent event = (MouseEvent)this.myInputEvent;
        popupMenu.getComponent().show(this.myArea.getNativeComponent(), event.getX(), event.getY());
    }

    @Override
    protected void handleDoubleClick(int button) {
        if (button == 1 && this.myToolProvider != null && !this.myArea.isTree()) {
            this.myToolProvider.startInplaceEditing(null);
        }
    }

    @Override
    protected void handleMove() {
        if (this.myState == 1) {
            InputTool tracker = this.myArea.findTargetTool(this.myCurrentScreenX, this.myCurrentScreenY);
            if (tracker == null) {
                this.refreshCursor();
                if (ApplicationManager.getApplication().isInternal()) {
                    this.myArea.setDescription("Location (" + this.myCurrentScreenX + " x " + this.myCurrentScreenY + ")");
                } else {
                    this.myArea.setDescription(null);
                }
            } else {
                if (this.myInputEvent instanceof MouseEvent) {
                    try {
                        tracker.mouseMove((MouseEvent)this.myInputEvent, this.myArea);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.myArea.setCursor(tracker.getDefaultCursor());
                this.myArea.setDescription(tracker.getDescription());
            }
        }
    }

    private void setTracker(@Nullable InputTool tracker) {
        if (this.myTracker != tracker) {
            this.deactivateTracker();
            this.myTracker = tracker;
            this.refreshCursor();
            if (this.myTracker != null) {
                this.myToolProvider.hideInspections();
                this.myTracker.setToolProvider(this.myToolProvider);
                this.myTracker.setArea(this.myArea);
                this.myTracker.myModifiers = this.myModifiers;
                this.myTracker.activate();
            }
        }
    }

    private void deactivateTracker() {
        if (this.myTracker != null) {
            this.myTracker.deactivate();
            this.myTracker = null;
            if (this.myArea != null) {
                this.myArea.showSelection(true);
            }
        }
    }

    @Override
    public void mouseDown(MouseEvent event, EditableArea area) throws Exception {
        super.mouseDown(event, area);
        if (this.myTracker != null) {
            this.myTracker.mouseDown(event, area);
        }
    }

    @Override
    public void mouseUp(MouseEvent event, EditableArea area) throws Exception {
        if (this.myTracker != null) {
            this.myTracker.mouseUp(event, area);
        }
        super.mouseUp(event, area);
    }

    @Override
    public void mouseMove(MouseEvent event, EditableArea area) throws Exception {
        if (this.myTracker != null) {
            this.myTracker.mouseMove(event, area);
        }
        super.mouseMove(event, area);
    }

    @Override
    public void mouseDrag(MouseEvent event, EditableArea area) throws Exception {
        if (this.myTracker != null) {
            this.myTracker.mouseDrag(event, area);
        }
        super.mouseDrag(event, area);
    }

    @Override
    public void mousePopup(MouseEvent event, EditableArea area) throws Exception {
        if (this.myTracker != null) {
            this.myTracker.mousePopup(event, area);
        }
        super.mousePopup(event, area);
    }

    @Override
    public void mouseDoubleClick(MouseEvent event, EditableArea area) throws Exception {
        super.mouseDoubleClick(event, area);
        if (this.myTracker != null) {
            this.myTracker.mouseDoubleClick(event, area);
        }
    }

    @Override
    public void keyPressed(KeyEvent event, EditableArea area) throws Exception {
        RadComponent component;
        List<RadComponent> selection;
        super.keyTyped(event, area);
        if (this.myTracker != null) {
            this.myTracker.keyPressed(event, area);
        } else if (event.getKeyCode() == 27 && !(selection = area.getSelection()).isEmpty() && (component = selection.get(0).getParent()) != null) {
            area.select(component);
        }
    }

    @Override
    public void keyTyped(KeyEvent event, EditableArea area) throws Exception {
        super.keyTyped(event, area);
        if (this.myTracker != null) {
            this.myTracker.keyTyped(event, area);
        } else if (this.myToolProvider != null && !area.isTree()) {
            this.handleKeyTyped(event);
        }
    }

    protected void handleKeyTyped(KeyEvent event) {
        char keyChar = event.getKeyChar();
        switch (keyChar) {
            case '+': 
            case '-': 
            case '0': 
            case '1': {
                ZoomType type2 = keyChar == '-' ? ZoomType.OUT : (keyChar == '+' ? ZoomType.IN : (keyChar == '0' ? ZoomType.FIT : ZoomType.ACTUAL));
                if (!this.myToolProvider.isZoomSupported()) break;
                this.myToolProvider.zoom(type2);
                event.consume();
                return;
            }
        }
        if (Character.isLetterOrDigit(keyChar) && (event.getModifiers() & 0xE) == 0) {
            this.myToolProvider.startInplaceEditing(new InplaceContext(keyChar));
        }
    }

    @Override
    public void keyReleased(KeyEvent event, EditableArea area) throws Exception {
        super.keyReleased(event, area);
        if (this.myTracker != null) {
            this.myTracker.keyReleased(event, area);
        }
    }
}

