/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.propertyTable.renderers;

import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.model.PropertyContext;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.propertyTable.PropertyRenderer;
import com.intellij.designer.propertyTable.PropertyTable;
import com.intellij.designer.propertyTable.renderers.ColorIcon;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractResourceRenderer<T>
implements PropertyRenderer {
    protected final ColorIcon myColorIcon = (ColorIcon)JBUI.scale((JBUI.JBIcon)new ColorIcon(10, 9));
    protected final SimpleColoredComponent myColoredComponent = new SimpleColoredComponent(){

        protected void doPaintIcon(@NotNull Graphics2D g, @NotNull Icon icon, int offset) {
            g.setColor(this.getBackground());
            g.fillRect(offset, 0, icon.getIconWidth() + this.getIpad().left + this.myIconTextGap, this.getHeight());
            this.paintIcon(g, icon, offset + this.getIpad().left);
        }
    };

    @Override
    @NotNull
    public JComponent getComponent(@Nullable PropertiesContainer container, PropertyContext context, @Nullable Object value2, boolean selected, boolean hasFocus) {
        this.myColoredComponent.clear();
        PropertyTable.updateRenderer((JComponent)this.myColoredComponent, selected);
        this.formatValue((RadComponent)container, value2);
        return this.myColoredComponent;
    }

    protected abstract void formatValue(RadComponent var1, T var2);

    @Override
    public void updateUI() {
        SwingUtilities.updateComponentTreeUI((Component)this.myColoredComponent);
    }
}

