/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.concurrency.JobScheduler;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.IdeMessagePanel;
import com.intellij.icons.AllIcons;
import com.intellij.ui.ClickListener;
import com.intellij.ui.LayeredIcon;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public class IdeFatalErrorsIcon
extends JLabel {
    private final LayeredIcon myIcon;
    private final ActionListener myListener;
    private Future myBlinker;
    private State myState;

    public IdeFatalErrorsIcon(ActionListener aListener) {
        this.myListener = aListener;
        this.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (IdeFatalErrorsIcon.this.myState != State.NoErrors) {
                    IdeFatalErrorsIcon.this.myListener.actionPerformed(null);
                    return true;
                }
                return false;
            }
        }.installOn((Component)this);
        this.myIcon = new LayeredIcon(new Icon[]{AllIcons.Ide.FatalError, AllIcons.Ide.FatalError_read, AllIcons.Ide.EmptyFatalError}){

            public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
                super.paintIcon(c, g, x, y);
            }

            public synchronized void setLayerEnabled(int layer, boolean enabled) {
                super.setLayerEnabled(layer, enabled);
            }
        };
        this.setIcon((Icon)this.myIcon);
    }

    public void setState(State state) {
        this.myState = state;
        switch (state) {
            case UnreadErrors: {
                this.myIcon.setLayerEnabled(0, true);
                this.myIcon.setLayerEnabled(1, false);
                this.myIcon.setLayerEnabled(2, false);
                this.startBlinker();
                this.setCursor(Cursor.getPredefinedCursor(12));
                this.setToolTipText(IdeMessagePanel.INTERNAL_ERROR_NOTICE);
                break;
            }
            case ReadErrors: {
                this.stopBlinker();
                this.myIcon.setLayerEnabled(0, false);
                this.myIcon.setLayerEnabled(1, true);
                this.myIcon.setLayerEnabled(2, false);
                this.setCursor(Cursor.getPredefinedCursor(12));
                this.setToolTipText(IdeMessagePanel.INTERNAL_ERROR_NOTICE);
                break;
            }
            case NoErrors: {
                this.stopBlinker();
                this.myIcon.setLayerEnabled(0, false);
                this.myIcon.setLayerEnabled(1, false);
                this.myIcon.setLayerEnabled(2, true);
                this.setCursor(Cursor.getPredefinedCursor(0));
                this.setToolTipText(DiagnosticBundle.message("error.notification.empty.text", new Object[0]));
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.repaint();
    }

    private synchronized void startBlinker() {
        if (this.myBlinker != null) {
            return;
        }
        this.myBlinker = JobScheduler.getScheduler().scheduleWithFixedDelay(new Runnable(){
            boolean enabled = false;

            @Override
            public void run() {
                IdeFatalErrorsIcon.this.myIcon.setLayerEnabled(0, this.enabled);
                IdeFatalErrorsIcon.this.myIcon.setLayerEnabled(1, false);
                IdeFatalErrorsIcon.this.myIcon.setLayerEnabled(2, !this.enabled);
                IdeFatalErrorsIcon.this.repaint();
                this.enabled = !this.enabled;
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    private synchronized void stopBlinker() {
        if (this.myBlinker != null) {
            this.myBlinker.cancel(true);
            this.myBlinker = null;
        }
    }

    public static enum State {
        UnreadErrors,
        ReadErrors,
        NoErrors;

    }
}

