/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.LogMessageEx;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class LogEventException
extends RuntimeException
implements ExceptionWithAttachments {
    private final IdeaLoggingEvent myLogMessage;

    public LogEventException(String userMessage, String details, Attachment ... attachments) {
        this(LogMessageEx.createEvent(userMessage, details + "\n\n" + DebugUtil.currentStackTrace(), attachments));
    }

    public LogEventException(IdeaLoggingEvent logMessage) {
        super(logMessage.getMessage());
        this.myLogMessage = logMessage;
    }

    public IdeaLoggingEvent getLogMessage() {
        return this.myLogMessage;
    }

    @NotNull
    public Attachment[] getAttachments() {
        Object data = this.myLogMessage.getData();
        if (data instanceof LogMessageEx) {
            Object[] attachments = ((LogMessageEx)data).getAllAttachments().toArray(Attachment.EMPTY_ARRAY);
            Throwable throwable = this.myLogMessage.getThrowable();
            return throwable == null ? attachments : (Attachment[])ArrayUtil.prepend((Object)new Attachment("details.trace", throwable), (Object[])attachments);
        }
        return Attachment.EMPTY_ARRAY;
    }
}

