/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.errordialog;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class DisablePluginWarningDialog
extends DialogWrapper {
    private JLabel myPromptLabel;
    private JLabel myRestartLabel;
    private JPanel myContentPane;
    private static final int DISABLE_EXIT_CODE = 0;
    private static final int DISABLE_AND_RESTART_EXIT_CODE = 2;
    private final boolean myRestartCapable;

    private DisablePluginWarningDialog(@NotNull Component parent, String pluginName, boolean hasDependants, boolean restartCapable) {
        super(parent, false);
        this.myRestartCapable = restartCapable;
        this.$$$setupUI$$$();
        this.myPromptLabel.setText(DiagnosticBundle.message(hasDependants ? "error.dialog.disable.plugin.prompt.dependants" : "error.dialog.disable.plugin.prompt", pluginName));
        this.myRestartLabel.setText(DiagnosticBundle.message(restartCapable ? "error.dialog.disable.plugin.restart" : "error.dialog.disable.plugin.norestart", ApplicationNamesInfo.getInstance().getFullProductName()));
        this.setTitle(DiagnosticBundle.message("error.dialog.disable.plugin.title", new Object[0]));
        this.init();
    }

    public static void disablePlugin(@NotNull PluginId pluginId, @NotNull JComponent parentComponent) {
        IdeaPluginDescriptor plugin = PluginManager.getPlugin(pluginId);
        Ref hasDependants = new Ref((Object)false);
        PluginManagerCore.checkDependants(plugin, (Function<PluginId, IdeaPluginDescriptor>)((Function)pluginId1 -> PluginManager.getPlugin(pluginId1)), (Condition<PluginId>)((Condition)pluginId12 -> {
            if ("com.intellij".equals(pluginId12.getIdString())) {
                return true;
            }
            hasDependants.set((Object)true);
            return false;
        }));
        Application app = ApplicationManager.getApplication();
        DisablePluginWarningDialog d = new DisablePluginWarningDialog(parentComponent, plugin.getName(), (Boolean)hasDependants.get(), app.isRestartCapable());
        d.show();
        switch (d.getExitCode()) {
            case 1: {
                return;
            }
            case 0: {
                PluginManagerCore.disablePlugin(pluginId.getIdString());
                break;
            }
            case 2: {
                PluginManagerCore.disablePlugin(pluginId.getIdString());
                app.restart();
            }
        }
    }

    protected JComponent createCenterPanel() {
        return this.myContentPane;
    }

    @NotNull
    protected Action[] createActions() {
        if (SystemInfo.isMac) {
            if (this.myRestartCapable) {
                return new Action[]{this.getCancelAction(), new DisableAction(), new DisableAndRestartAction()};
            }
            return new Action[]{this.getCancelAction(), new DisableAction()};
        }
        if (this.myRestartCapable) {
            return new Action[]{new DisableAction(), new DisableAndRestartAction(), this.getCancelAction()};
        }
        return new Action[]{new DisableAction(), this.getCancelAction()};
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myPromptLabel = jLabel2 = new JLabel();
        jLabel2.setText("prompt");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRestartLabel = jLabel = new JLabel();
        jLabel.setText("restart");
        jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, new Dimension(-1, 15), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private class DisableAndRestartAction
    extends DialogWrapper.DialogWrapperAction {
        protected DisableAndRestartAction() {
            super((DialogWrapper)DisablePluginWarningDialog.this, DiagnosticBundle.message("error.dialog.disable.plugin.action.disableAndRestart", new Object[0]));
        }

        protected void doAction(ActionEvent e) {
            DisablePluginWarningDialog.this.close(2);
        }
    }

    private class DisableAction
    extends DialogWrapper.DialogWrapperAction {
        protected DisableAction() {
            super((DialogWrapper)DisablePluginWarningDialog.this, DiagnosticBundle.message("error.dialog.disable.plugin.action.disable", new Object[0]));
        }

        protected void doAction(ActionEvent e) {
            DisablePluginWarningDialog.this.close(0);
        }
    }
}

