/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.actions.DocumentFragmentContent;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DiffPsiFileSupport;
import com.intellij.diff.contents.DirectoryContentImpl;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.DocumentContentImpl;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.contents.FileContentImpl;
import com.intellij.diff.contents.FileDocumentContentImpl;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.testFramework.BinaryLightVirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.LightColors;
import com.intellij.util.LineSeparator;
import com.intellij.util.PathUtil;
import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffContentFactoryImpl
extends DiffContentFactoryEx {
    private static final Logger LOG = Logger.getInstance(DiffContentFactoryImpl.class);

    @NotNull
    public EmptyContent createEmpty() {
        return new EmptyContent();
    }

    @NotNull
    public DocumentContent create(@NotNull String text) {
        return this.create(null, text);
    }

    @NotNull
    public DocumentContent create(@NotNull String text, @Nullable FileType type2) {
        return this.create(null, text, type2);
    }

    @NotNull
    public DocumentContent create(@NotNull String text, @Nullable FileType type2, boolean respectLineSeparators) {
        return this.create(null, text, type2, respectLineSeparators);
    }

    @NotNull
    public DocumentContent create(@NotNull String text, @Nullable VirtualFile highlightFile) {
        return this.create(null, text, highlightFile);
    }

    @NotNull
    public DocumentContent create(@NotNull String text, @Nullable DocumentContent referent) {
        return this.create(null, text, referent);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull String text) {
        return this.create(project2, text, (FileType)null);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull String text, @Nullable FileType type2) {
        return this.create(project2, text, type2, true);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull String text, @Nullable FileType type2, boolean respectLineSeparators) {
        return DiffContentFactoryImpl.createImpl(project2, text, type2, null, null, respectLineSeparators, true);
    }

    @Override
    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull String text, @NotNull FilePath filePath) {
        return DiffContentFactoryImpl.createImpl(project2, text, filePath.getFileType(), filePath.getName(), filePath.getVirtualFile(), true, true);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull String text, @Nullable VirtualFile highlightFile) {
        FileType fileType = highlightFile != null ? highlightFile.getFileType() : null;
        String fileName = highlightFile != null ? highlightFile.getName() : null;
        return DiffContentFactoryImpl.createImpl(project2, text, fileType, fileName, highlightFile, true, true);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull String text, @Nullable DocumentContent referent) {
        if (referent == null) {
            return this.create(text);
        }
        return DiffContentFactoryImpl.createImpl(project2, text, referent.getContentType(), null, referent.getHighlightFile(), false, true);
    }

    @NotNull
    public DocumentContent create(@NotNull Document document, @Nullable DocumentContent referent) {
        return this.create(null, document, referent);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull Document document) {
        return this.create(project2, document, (FileType)null);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull Document document, @Nullable FileType fileType) {
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 == null) {
            return new DocumentContentImpl(project2, document, fileType, null, null, null, null);
        }
        return this.create(project2, document, file2);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull Document document, @Nullable VirtualFile file2) {
        if (file2 != null) {
            return new FileDocumentContentImpl(project2, document, file2);
        }
        return new DocumentContentImpl(document);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull Document document, @Nullable DocumentContent referent) {
        if (referent == null) {
            return new DocumentContentImpl(document);
        }
        return new DocumentContentImpl(project2, document, referent.getContentType(), referent.getHighlightFile(), null, null, null);
    }

    @NotNull
    public DiffContent create(@Nullable Project project2, @NotNull VirtualFile file2) {
        if (file2.isDirectory()) {
            return new DirectoryContentImpl(project2, file2);
        }
        DocumentContent content = this.createDocument(project2, file2);
        if (content != null) {
            return content;
        }
        return new FileContentImpl(project2, file2);
    }

    @Nullable
    public DocumentContent createDocument(@Nullable Project project2, @NotNull VirtualFile file2) {
        if (file2.isDirectory()) {
            return null;
        }
        Document document = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(file2));
        if (document == null) {
            return null;
        }
        return new FileDocumentContentImpl(project2, document, file2);
    }

    @Nullable
    public FileContent createFile(@Nullable Project project2, @NotNull VirtualFile file2) {
        if (file2.isDirectory()) {
            return null;
        }
        return (FileContent)this.create(project2, file2);
    }

    @NotNull
    public DocumentContent createFragment(@Nullable Project project2, @NotNull Document document, @NotNull TextRange range) {
        DocumentContent content = this.create(project2, document);
        return new DocumentFragmentContent(project2, content, range);
    }

    @NotNull
    public DocumentContent createFragment(@Nullable Project project2, @NotNull DocumentContent content, @NotNull TextRange range) {
        return new DocumentFragmentContent(project2, content, range);
    }

    @NotNull
    public DiffContent createClipboardContent() {
        return this.createClipboardContent(null, null);
    }

    @NotNull
    public DocumentContent createClipboardContent(@Nullable DocumentContent referent) {
        return this.createClipboardContent(null, referent);
    }

    @NotNull
    public DiffContent createClipboardContent(@Nullable Project project2) {
        return this.createClipboardContent(project2, null);
    }

    @NotNull
    public DocumentContent createClipboardContent(@Nullable Project project2, @Nullable DocumentContent referent) {
        String text = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
        FileType type2 = referent != null ? referent.getContentType() : null;
        VirtualFile highlightFile = referent != null ? referent.getHighlightFile() : null;
        return DiffContentFactoryImpl.createImpl(project2, StringUtil.notNullize((String)text), type2, "Clipboard.txt", highlightFile, false, false);
    }

    @Override
    @NotNull
    public DiffContent createFromBytes(@Nullable Project project2, @NotNull byte[] content, @NotNull FilePath filePath) throws IOException {
        if (DiffContentFactoryImpl.isBinaryContent(content, filePath.getFileType())) {
            return DiffContentFactoryImpl.createBinaryImpl(project2, content, filePath.getFileType(), filePath.getName(), filePath.getVirtualFile());
        }
        return this.createDocumentFromBytes(project2, content, filePath);
    }

    @Override
    @NotNull
    public DiffContent createFromBytes(@Nullable Project project2, @NotNull byte[] content, @NotNull VirtualFile highlightFile) throws IOException {
        if (DiffContentFactoryImpl.isBinaryContent(content, highlightFile.getFileType())) {
            return DiffContentFactoryImpl.createBinaryImpl(project2, content, highlightFile.getFileType(), highlightFile.getName(), highlightFile);
        }
        return this.createDocumentFromBytes(project2, content, highlightFile);
    }

    @Override
    @NotNull
    public DocumentContent createDocumentFromBytes(@Nullable Project project2, @NotNull byte[] content, @NotNull FilePath filePath) {
        return DiffContentFactoryImpl.createFromBytesImpl(project2, content, filePath.getFileType(), filePath.getName(), filePath.getVirtualFile(), filePath.getCharset());
    }

    @Override
    @NotNull
    public DocumentContent createDocumentFromBytes(@Nullable Project project2, @NotNull byte[] content, @NotNull VirtualFile highlightFile) {
        return DiffContentFactoryImpl.createFromBytesImpl(project2, content, highlightFile.getFileType(), highlightFile.getName(), highlightFile, highlightFile.getCharset());
    }

    @NotNull
    public DiffContent createBinary(@Nullable Project project2, @NotNull byte[] content, @NotNull FileType type2, @NotNull String fileName) throws IOException {
        return DiffContentFactoryImpl.createBinaryImpl(project2, content, type2, fileName, null);
    }

    @NotNull
    private static DiffContent createBinaryImpl(@Nullable Project project2, @NotNull byte[] content, @NotNull FileType type2, @NotNull String fileName, @Nullable VirtualFile highlightFile) throws IOException {
        VirtualFile file2;
        boolean useTemporalFile;
        boolean bl = useTemporalFile = type2 instanceof ArchiveFileType || BinaryFileTypeDecompilers.INSTANCE.forFileType(type2) != null;
        if (useTemporalFile) {
            file2 = DiffContentFactoryImpl.createTemporalFile(project2, "tmp", fileName, content);
        } else {
            file2 = new BinaryLightVirtualFile(fileName, type2, content);
            file2.setWritable(false);
        }
        return new FileContentImpl(project2, file2, highlightFile);
    }

    @NotNull
    private static DocumentContent createImpl(@Nullable Project project2, @NotNull String text, @Nullable FileType fileType, @Nullable String fileName, @Nullable VirtualFile highlightFile, boolean respectLineSeparators, boolean readOnly) {
        return DiffContentFactoryImpl.createImpl(project2, text, fileType, fileName, highlightFile, null, null, respectLineSeparators, readOnly);
    }

    @NotNull
    private static DocumentContent createImpl(@Nullable Project project2, @NotNull String text, @Nullable FileType fileType, @Nullable String fileName, @Nullable VirtualFile highlightFile, @Nullable Charset charset, @Nullable Boolean bom, boolean respectLineSeparators, boolean readOnly) {
        if (FileTypes.UNKNOWN.equals(fileType)) {
            fileType = PlainTextFileType.INSTANCE;
        }
        LineSeparator separator = respectLineSeparators ? StringUtil.detectSeparators((CharSequence)text) : null;
        String correctedContent = StringUtil.convertLineSeparators((String)text);
        Document document = DiffContentFactoryImpl.createDocument(project2, correctedContent, fileType, fileName, readOnly);
        DocumentContentImpl content = new DocumentContentImpl(project2, document, (FileType)fileType, highlightFile, separator, charset, bom);
        if (fileName != null) {
            content.putUserData(DiffUserDataKeysEx.FILE_NAME, fileName);
        }
        return content;
    }

    @NotNull
    private static DocumentContent createFromBytesImpl(@Nullable Project project2, @NotNull byte[] content, @NotNull FileType fileType, @NotNull String fileName, @Nullable VirtualFile highlightFile, @NotNull Charset charset) {
        String text;
        Charset bomCharset;
        boolean isBOM;
        if (fileType.isBinary()) {
            fileType = PlainTextFileType.INSTANCE;
            Charset guessedCharset = DiffContentFactoryImpl.guessCharsetFromContent(content);
            if (guessedCharset != null) {
                charset = guessedCharset;
            }
        }
        boolean bl = isBOM = (bomCharset = CharsetToolkit.guessFromBOM((byte[])content)) != null;
        if (isBOM) {
            charset = bomCharset;
        }
        boolean malformedContent = false;
        try {
            text = CharsetToolkit.tryDecodeString((byte[])content, (Charset)charset);
        }
        catch (CharacterCodingException e) {
            text = CharsetToolkit.decodeString((byte[])content, (Charset)charset);
            malformedContent = true;
        }
        DocumentContent documentContent = DiffContentFactoryImpl.createImpl(project2, text, fileType, fileName, highlightFile, charset, isBOM, true, true);
        if (malformedContent) {
            String notificationText = "Content was decoded with errors (using '" + charset.name() + "' charset)";
            DiffUtil.addNotification(DiffNotifications.createNotification(notificationText, LightColors.RED), (UserDataHolder)documentContent);
        }
        return documentContent;
    }

    @NotNull
    private static VirtualFile createTemporalFile(@Nullable Project project2, @NotNull String prefix, @NotNull String suffix, @NotNull byte[] content) throws IOException {
        VirtualFile file2;
        File tempFile = FileUtil.createTempFile((String)PathUtil.suggestFileName((String)(prefix + "_"), (boolean)true, (boolean)false), (String)PathUtil.suggestFileName((String)("_" + suffix), (boolean)true, (boolean)false), (boolean)true);
        if (content.length != 0) {
            FileUtil.writeToFile((File)tempFile, (byte[])content);
        }
        if (!tempFile.setWritable(false, false)) {
            LOG.warn("Can't set writable attribute of temporal file");
        }
        if ((file2 = VfsUtil.findFileByIoFile((File)tempFile, (boolean)true)) == null) {
            throw new IOException("Can't create temp file for revision content");
        }
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{file2});
        return file2;
    }

    @NotNull
    private static Document createDocument(@Nullable Project project2, @NotNull String content, @Nullable FileType fileType, @Nullable String fileName, boolean readOnly) {
        Document document;
        if (project2 != null && !project2.isDefault() && fileType != null && !fileType.isBinary() && Registry.is((String)"diff.enable.psi.highlighting")) {
            if (fileName == null) {
                fileName = "diff." + StringUtil.defaultIfEmpty((String)fileType.getDefaultExtension(), (String)"txt");
            }
            if ((document = DiffContentFactoryImpl.createPsiDocument(project2, content, fileType, fileName, readOnly)) != null) {
                return document;
            }
        }
        document = EditorFactory.getInstance().createDocument((CharSequence)content);
        document.setReadOnly(readOnly);
        return document;
    }

    @Nullable
    private static Document createPsiDocument(@NotNull Project project2, @NotNull String content, @NotNull FileType fileType, @NotNull String fileName, boolean readOnly) {
        return (Document)ReadAction.compute(() -> {
            LightVirtualFile file2 = new LightVirtualFile(fileName, fileType, (CharSequence)content);
            file2.setWritable(!readOnly);
            file2.putUserData(DiffPsiFileSupport.KEY, (Object)true);
            Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)file2);
            if (document == null) {
                return null;
            }
            PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
            return document;
        });
    }

    private static boolean isBinaryContent(@NotNull byte[] content, @NotNull FileType fileType) {
        if (UnknownFileType.INSTANCE.equals(fileType)) {
            return DiffContentFactoryImpl.guessCharsetFromContent(content) == null;
        }
        return fileType.isBinary();
    }

    @Nullable
    private static Charset guessCharsetFromContent(@NotNull byte[] content) {
        CharsetToolkit toolkit = new CharsetToolkit(content);
        Charset fromBOM = toolkit.guessFromBOM();
        if (fromBOM != null) {
            return fromBOM;
        }
        CharsetToolkit.GuessedEncoding guessedEncoding = toolkit.guessFromContent(content.length);
        switch (guessedEncoding) {
            case SEVEN_BIT: {
                return Charset.forName("US-ASCII");
            }
            case VALID_UTF8: {
                return CharsetToolkit.UTF8_CHARSET;
            }
        }
        return null;
    }
}

